/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderOwner;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.xml.navigator.FolderElement;
import oracle.dbtools.xml.navigator.IconElement;
import oracle.dbtools.xml.navigator.LabelElement;
import oracle.ide.model.Element;

public class XmlFolderImpl
implements DatabaseFolder {
    private XmlFolderOwner m_type;
    private String m_labelKey;
    private String m_label;
    private String m_iconKey;
    private String m_iconPath;
    private Icon m_icon;
    private ObjectQueries m_queries;
    private boolean m_currentSchemaOnly;
    private boolean m_singleClickOpen;
    private NavigatorDescriptor m_desc;
    private String m_override;
    private double m_weight = Double.NEGATIVE_INFINITY;
    private double m_relWeight;
    private Set<String> m_requiredLicenses;
    private boolean m_ignoreComparator;

    public XmlFolderImpl(XmlFolderOwner xmlFolderOwner, NavigatorDescriptor navigatorDescriptor, FolderElement folderElement) {
        IconElement iconElement;
        this.m_type = xmlFolderOwner;
        this.m_desc = navigatorDescriptor;
        LabelElement labelElement = folderElement.getLabel();
        if (labelElement != null) {
            this.m_labelKey = labelElement.getKey();
        }
        if ((iconElement = folderElement.getIcon()) != null) {
            this.m_iconKey = iconElement.getKey();
            if (this.m_iconKey == null) {
                this.m_iconPath = iconElement.getPath();
            }
        }
        this.m_queries = folderElement.getQueries();
        this.m_currentSchemaOnly = folderElement.isCurrentSchemaOnly();
        this.m_singleClickOpen = folderElement.isSingleClickOpen();
        this.m_relWeight = folderElement.getRelativeWeight();
        this.m_override = folderElement.getSchemaOverride();
        this.m_ignoreComparator = folderElement.isIgnoreComparator();
        this.m_requiredLicenses = xmlFolderOwner.getRequiredLicenses();
    }

    @Override
    public String getLabel() {
        if (this.m_label == null) {
            this.m_label = this.m_desc != null && this.m_labelKey != null ? this.m_desc.getResource(this.m_labelKey) : this.m_type.getType();
        }
        return this.m_label;
    }

    @Override
    public Icon getIcon() {
        if (this.m_icon == null) {
            if (this.m_iconKey != null) {
                this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconKey, this.m_desc);
            } else if (this.m_iconPath != null) {
                this.m_icon = XmlNavigatorUtils.getIcon(this.m_iconPath);
            }
        }
        return this.m_icon;
    }

    @Override
    public String getType() {
        return this.m_type.getType();
    }

    public ObjectQueries getQueries() {
        return this.m_queries;
    }

    @Override
    public double getWeight() {
        if (this.m_weight == Double.NEGATIVE_INFINITY) {
            this.m_weight = this.m_type.getWeight() + this.m_relWeight;
        }
        return this.m_weight;
    }

    @Override
    public String getSchemaOverride() {
        return this.m_override;
    }

    @Override
    public boolean isCurrentSchemaOnly() {
        return this.m_currentSchemaOnly;
    }

    @Override
    public boolean isSingleClickOpen() {
        return this.m_singleClickOpen;
    }

    @Override
    public Class<? extends Element> getImplementationClass() {
        return null;
    }

    boolean isSupportsSynonyms() {
        return this.m_type.isIncludesSynonyms();
    }

    @Override
    public boolean ignoreDefaultComparator() {
        return this.m_ignoreComparator;
    }

    @Override
    public Set<String> getRequiredLicenses() {
        return Collections.unmodifiableSet(this.m_requiredLicenses);
    }
}

