/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.navigator.ColoredDisplayable;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.db.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.db.impl.FilterableTreeNode;
import oracle.dbtools.raptor.navigator.db.impl.TypeContainerTreeNode;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;

public class DatabaseTreeNode
extends TypeContainerTreeNode
implements FilterableTreeNode,
ColoredDisplayable {
    private String m_tooltip;
    private DBItemInstance m_instance;

    protected AbstractConnectionNode getConnectionNode() {
        Element element = this.getElement();
        return element instanceof AbstractConnectionNode ? (AbstractConnectionNode)element : null;
    }

    @Override
    protected void cleanupOnClose() {
        this.m_instance = null;
    }

    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        return new LoadTask(this.getConnectionNode());
    }

    @Override
    public String getToolTipText() {
        if (this.m_tooltip == null) {
            this.m_tooltip = super.getToolTipText();
        }
        return this.m_tooltip;
    }

    protected void updateToolTipText(String string) {
        this.m_tooltip = string;
    }

    protected ObjectFactory getObjectFactory(AbstractConnectionNode abstractConnectionNode) throws IOException {
        Connection connection = (Connection)abstractConnectionNode.getConnection();
        return ObjectFactoryRegistry.getDatabaseNavigatorRegistry().getFactory(abstractConnectionNode.getQualifiedConnectionName(), connection);
    }

    protected void fillInInitialProperties(DBItemInstance dBItemInstance) {
        if (dBItemInstance instanceof DBSchemasInstance || dBItemInstance instanceof DBSchemaInstance) {
            dBItemInstance.setProperty("CATALOG", "");
        }
    }

    public DBItemInstance getItemInstance() {
        return this.m_instance;
    }

    @Override
    public boolean clearFilter() {
        boolean bl = false;
        if (this.m_instance instanceof DBSchemaInstance) {
            ((DBSchemaInstance)this.m_instance).clearFilter();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isFiltered() {
        return this.m_instance instanceof DBSchemaInstance && ((DBSchemaInstance)this.m_instance).isSchemaFiltered();
    }

    @Override
    public boolean canHaveFilter() {
        return this.m_instance instanceof DBSchemaInstance;
    }

    @Override
    public boolean promptForFilter() {
        boolean bl = false;
        if (this.m_instance instanceof DBSchemaInstance) {
            bl = ((DBSchemaInstance)this.m_instance).promptForSchemaFilter();
        }
        return bl;
    }

    @Override
    public String getShortLabel() {
        String string = super.getShortLabel();
        return this.isFiltered() ? DatabaseNavigatorResources.format("FILTER_FORMAT", string) : string;
    }

    @Override
    protected void updateImpl(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.PROPERTY_SET || n == UpdateMessage.OBJECT_CLOSED || n == UpdateMessage.OBJECT_OPENED) {
            this.m_tooltip = null;
        }
        super.updateImpl(object, updateMessage);
    }

    @Override
    public Color getColor() {
        AbstractConnectionNode abstractConnectionNode = this.getConnectionNode();
        return abstractConnectionNode instanceof ColoredDisplayable ? ((ColoredDisplayable)((Object)abstractConnectionNode)).getColor() : null;
    }

    private class LoadTask
    extends DatabaseQueryTask<Collection<Element>> {
        private AbstractConnectionNode m_connNode;
        private String m_connName;

        LoadTask(AbstractConnectionNode abstractConnectionNode) {
            super(DatabaseNavigatorResources.getString("CONNECTION_FILTER_OPEN"), IRaptorTaskRunMode.IDE_STATUSBAR, false, true, true);
            this.m_connNode = abstractConnectionNode;
            this.m_connName = abstractConnectionNode != null ? abstractConnectionNode.getQualifiedConnectionName() : null;
        }

        public String getConnectionName() {
            return this.m_connName;
        }

        public String getQuery() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Collection<Element> doWork() throws TaskException {
            ArrayList<Element> arrayList;
            block20: {
                arrayList = new ArrayList<Element>();
                try {
                    String string;
                    if (this.m_connNode == null) break block20;
                    this.checkStatus("getFactory");
                    ObjectFactory objectFactory = DatabaseTreeNode.this.getObjectFactory(this.m_connNode);
                    if (objectFactory != null && (string = DatabaseTreeNode.this.getURLProtocol()) != null) {
                        if (objectFactory.isSupportsCatalog()) {
                            DBCatalogsInstance dBCatalogsInstance = objectFactory.getCatalogsInstance();
                            try {
                                DatabaseTreeNode.this.fillInInitialProperties(dBCatalogsInstance);
                                for (DBChildInstance dBChildInstance : dBCatalogsInstance.listChildren()) {
                                    this.checkStatus("create catalogs");
                                    DBCatalogInstance dBCatalogInstance = (DBCatalogInstance)dBChildInstance;
                                    CatalogFolder catalogFolder = new CatalogFolder(DBURLFormatHelper.getURL(string, this.m_connName, (String)dBCatalogInstance.getProperty("CATALOG"), null, null), dBCatalogInstance);
                                    arrayList.add(catalogFolder);
                                }
                            }
                            catch (SQLException sQLException) {
                                ExceptionHandler.handleException((Throwable)sQLException);
                            }
                            DatabaseTreeNode.this.m_instance = dBCatalogsInstance;
                        } else {
                            String string2 = this.m_connNode.getQualifiedConnectionName();
                            if (objectFactory.isShowAllSchemasAtTopLevel()) {
                                DBSchemasInstance dBSchemasInstance = objectFactory.getSchemasInstance(null);
                                String string3 = (String)dBSchemasInstance.getProperty("ConnectionType");
                                try {
                                    DatabaseTreeNode.this.fillInInitialProperties(dBSchemasInstance);
                                    for (DBChildInstance dBChildInstance : dBSchemasInstance.listChildren()) {
                                        this.checkStatus("create schemas");
                                        DBSchemaInstance dBSchemaInstance = (DBSchemaInstance)dBChildInstance;
                                        SchemaFolder schemaFolder = new SchemaFolder(DBURLFormatHelper.getURL(string, string2, null, (String)dBSchemaInstance.getProperty("SCHEMA"), null), dBSchemaInstance, string3);
                                        schemaFolder.setProperty("ConnectionType", string3);
                                        arrayList.add(schemaFolder);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    ExceptionHandler.handleException((Throwable)sQLException);
                                }
                                DatabaseTreeNode.this.m_instance = dBSchemasInstance;
                            } else {
                                String string4 = objectFactory.getSchema();
                                DBSchemaInstance dBSchemaInstance = objectFactory.createSchemaInstance(string4);
                                DatabaseTreeNode.this.fillInInitialProperties(dBSchemaInstance);
                                arrayList.addAll(DatabaseTreeNode.this.loadTypeFolders(dBSchemaInstance, string2, null, string4));
                                String string5 = dBSchemaInstance.getObjectFactory().getConnectionType();
                                boolean bl = DatabaseTreeNode.this.isNavigationFilterEnabled() && string.equals("sqldev.nav") && (string5.equals("Oracle") || string5.equals("TimesTen"));
                                Set<String> set = DatabaseTreeNode.this.getNodesFromPreference(string5);
                                for (CategoryInstance object : dBSchemaInstance.listCategories()) {
                                    String string3 = object.getDescriptor().getType();
                                    URL uRL = DBURLFormatHelper.getURL(string, string2, null, string4, string3);
                                    if (bl && !set.contains(string3)) continue;
                                    arrayList.add(new CategoryFolder(uRL, object));
                                }
                                if (objectFactory.isShowOtherSchemas()) {
                                    DBSchemasInstance dBSchemasInstance = objectFactory.getSchemasInstance(null);
                                    URL uRL = DBURLFormatHelper.getURL(string, string2, null, null, "Schemas");
                                    arrayList.add((Element)new OtherSchemasFolder(uRL, dBSchemasInstance));
                                }
                                DatabaseTreeNode.this.m_instance = dBSchemaInstance;
                            }
                        }
                    }
                    if (!Connections.getInstance().lock(this.m_connName)) break block20;
                    try {
                        new DBObject(this.m_connNode).getDictionary();
                    }
                    finally {
                        Connections.getInstance().unlock(this.m_connName);
                    }
                }
                catch (AbortException abortException) {
                    throw new TaskException((Throwable)abortException);
                }
                catch (IOException iOException) {
                    Throwable throwable = iOException;
                    if (iOException instanceof WrappedException) {
                        throwable = iOException.getCause();
                    }
                    throw new TaskException(throwable);
                }
            }
            return arrayList;
        }

        private void checkStatus(String string) throws AbortException {
            try {
                this.checkCanProceed();
            }
            catch (ExecutionException executionException) {
                throw new AbortException(string);
            }
        }
    }
}

