/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.ConnectionOwner;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.config.NavigatorSettings;
import oracle.dbtools.raptor.navigator.db.ConnectionFolderOwner;
import oracle.dbtools.raptor.navigator.db.ConnectionStores;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeRoot;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeSupport;
import oracle.dbtools.raptor.navigator.db.GroupedConnections;
import oracle.dbtools.raptor.navigator.db.IConnectionNode;
import oracle.dbtools.raptor.navigator.db.TypedConnections;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.SynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.StoreListener;

public class ConnectionStoresTreeNode
extends SynchronousNavigatorTreeNode {
    private static Comparator<NavigatorTreeNode> COMP = new Comparator<NavigatorTreeNode>(){

        @Override
        public int compare(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
            if (navigatorTreeNode == navigatorTreeNode2) {
                return 0;
            }
            ConnectionOwner connectionOwner = (ConnectionOwner)navigatorTreeNode.getElement();
            ConnectionOwner connectionOwner2 = (ConnectionOwner)navigatorTreeNode2.getElement();
            return connectionOwner.compareTo(connectionOwner2);
        }
    };
    private Observer mObserver = new Observer(){

        public void update(final Object object, final UpdateMessage updateMessage) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.doUpdate(object, updateMessage);
                    }
                });
            } else {
                this.doUpdate(object, updateMessage);
            }
        }

        private void doUpdate(Object object, UpdateMessage updateMessage) {
            int n = updateMessage.getMessageID();
            if (n == UpdateMessage.CHILD_ADDED) {
                ConnectionStoresTreeNode.this.processAddedChildren(updateMessage.getAddObjects().iterator());
            } else if (n == UpdateMessage.CHILD_REMOVED) {
                List list = updateMessage.getRemoveObjects();
                ConnectionStoresTreeNode.this.processRemovedChildren(list.iterator());
            }
        }
    };
    private SL mListener;
    private boolean mTypeGrouped;
    private Map<String, TypedConnections> mTypedFolders;

    public static List<DatabaseTypeRoot> fetchRoots() {
        ArrayList<DatabaseTypeRoot> arrayList = new ArrayList<DatabaseTypeRoot>();
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        for (String string : databaseConnectionStores.listStores()) {
            arrayList.add(Databases.findOrCreateConnectionStore(string));
        }
        for (String string : DatabaseTypeSupport.getSupportedDatabaseTypes()) {
            DatabaseTypeRoot databaseTypeRoot = DatabaseTypeSupport.getRootContainer(string);
            if (databaseTypeRoot == null) continue;
            arrayList.add(databaseTypeRoot);
        }
        return arrayList;
    }

    public ConnectionStoresTreeNode() {
        this.setComparator(COMP);
        this.mListener = new SL();
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        databaseConnectionStores.addStoreListener((StoreListener)this.mListener);
    }

    @Override
    protected Iterator<Element> loadChildrenImpl() {
        Connections connections = Connections.getInstance();
        ArrayList<ConnectionFolderOwner> arrayList = new ArrayList<ConnectionFolderOwner>();
        ConnectionStores connectionStores = (ConnectionStores)this.getElement();
        this.mTypeGrouped = NavigatorSettings.getDefaultInstance().isGroupedByType();
        if (this.mTypeGrouped) {
            this.setComparator(COMP);
            List<DatabaseTypeRoot> list = ConnectionStoresTreeNode.fetchRoots();
            this.mTypedFolders = new HashMap<String, TypedConnections>();
            TypedConnections typedConnections = TypedConnections.create("Oracle");
            this.mTypedFolders.put(typedConnections.getType(), typedConnections);
            arrayList.add(typedConnections);
            for (DatabaseTypeRoot databaseTypeRoot : list) {
                if ("sqldev.nav".equals(databaseTypeRoot.getDatabaseType())) {
                    databaseTypeRoot.attach(this.mObserver);
                    Iterator iterator = databaseTypeRoot.getChildren();
                    while (iterator.hasNext()) {
                        IConnectionNode iConnectionNode = (IConnectionNode)iterator.next();
                        String string = iConnectionNode.getQualifiedConnectionName();
                        String string2 = ConnectionStoresTreeNode.getConnectionType(string);
                        typedConnections = this.mTypedFolders.get(string2);
                        if (typedConnections == null) {
                            typedConnections = TypedConnections.create(string2);
                            this.mTypedFolders.put(string2, typedConnections);
                            arrayList.add(typedConnections);
                        }
                        typedConnections.add(iConnectionNode);
                    }
                    continue;
                }
                arrayList.add(databaseTypeRoot);
            }
        } else {
            arrayList.add(GroupedConnections.getInstance());
        }
        return arrayList.iterator();
    }

    private static String getConnectionType(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        String string2 = properties.getProperty("RaptorConnectionType", "Oracle");
        return string2;
    }

    @Override
    protected void cleanupOnClose() {
        super.cleanupOnClose();
        this.mTypedFolders = null;
        for (DatabaseTypeRoot databaseTypeRoot : ConnectionStoresTreeNode.fetchRoots()) {
            if (!"sqldev.nav".equals(databaseTypeRoot.getDatabaseType())) continue;
            databaseTypeRoot.detach(this.mObserver);
        }
    }

    private void processAddedChildren(Iterator<IConnectionNode<?>> iterator) {
        NavigatorTree navigatorTree = this.getOwningNavigatorTree();
        while (iterator.hasNext()) {
            IConnectionNode<?> iConnectionNode = iterator.next();
            String string = iConnectionNode.getQualifiedConnectionName();
            String string2 = ConnectionStoresTreeNode.getConnectionType(string);
            TypedConnections typedConnections = this.mTypedFolders.get(string2);
            if (typedConnections == null) {
                typedConnections = TypedConnections.create(string2);
                this.mTypedFolders.put(string2, typedConnections);
                navigatorTree.addChildToNode((NavigatorTreeNode)this, typedConnections);
                NavigatorTreeNode navigatorTreeNode = this.lookup(typedConnections);
                if (navigatorTreeNode != null) {
                    navigatorTree.expand(navigatorTreeNode, false);
                }
            }
            typedConnections.add(iConnectionNode);
            UpdateMessage.fireChildAdded((Subject)typedConnections, iConnectionNode);
        }
    }

    private void processRemovedChildren(Iterator<IConnectionNode<?>> iterator) {
        while (iterator.hasNext()) {
            TypedConnections typedConnections;
            IConnectionNode<?> iConnectionNode = iterator.next();
            NavigatorTreeNode navigatorTreeNode = this.getOwningNavigatorTree().findTreeNode(iConnectionNode, (NavigatorTreeNode)this);
            if (navigatorTreeNode == null || (typedConnections = navigatorTreeNode.findAncestorElement(TypedConnections.class, false)) == null || !typedConnections.remove(iConnectionNode)) continue;
            if ("Oracle".equals(typedConnections.getType()) || typedConnections.size() > 0) {
                UpdateMessage.fireChildRemoved((Subject)typedConnections, iConnectionNode);
                continue;
            }
            this.getOwningNavigatorTree().removeChildrenFromNode(this, Collections.singletonList(typedConnections));
            this.mTypedFolders.remove(typedConnections.getType());
        }
    }

    protected class SL
    implements StoreListener {
        protected SL() {
        }

        public void storeAdded(String string) {
            if (ConnectionStoresTreeNode.this.mTypeGrouped && ConnectionStoresTreeNode.this.mTypedFolders != null) {
                Databases databases = Databases.findOrCreateConnectionStore(string);
                ConnectionStoresTreeNode.this.processAddedChildren(databases.getChildren());
            }
        }

        public void storeRemoved(String string) {
            Databases databases = Databases.findConnectionStore(string);
            if (databases != null) {
                if (ConnectionStoresTreeNode.this.mTypeGrouped && ConnectionStoresTreeNode.this.mTypedFolders != null) {
                    NavigatorTree navigatorTree = ConnectionStoresTreeNode.this.getOwningNavigatorTree();
                    ConnectionStoresTreeNode.this.processRemovedChildren(databases.getChildren());
                }
                Databases.removeConnectionStore(string);
            }
        }
    }
}

