/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;

public class CatalogTreeNode
extends AsynchronousNavigatorTreeNode {
    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        CatalogFolder catalogFolder = (CatalogFolder)this.getElement();
        String string = (String)catalogFolder.getProviderIdentifier();
        return new LoadTask(catalogFolder, string);
    }

    private class LoadTask
    extends NavigatorQueryTask {
        private CatalogFolder m_folder;

        LoadTask(CatalogFolder catalogFolder, String string) {
            super(DatabaseNavigatorResources.getString("CATALOGS_LOAD_MSG"), string, true);
            this.m_folder = catalogFolder;
        }

        @Override
        protected Collection<Element> doWorkImpl() throws TaskException {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            DBCatalogInstance dBCatalogInstance = this.m_folder.getCatalogInstance();
            String string = DBURLFormatHelper.getCatalog(this.m_folder.getURL());
            DBSchemasInstance dBSchemasInstance = dBCatalogInstance.getSchemasInstance();
            try {
                this.checkCanProceed();
                String string2 = CatalogTreeNode.getURLProtocol(this.m_folder);
                String string3 = this.getConnectionName();
                String string4 = (String)dBSchemasInstance.getProperty("ConnectionType");
                for (DBChildInstance dBChildInstance : dBSchemasInstance.listChildren()) {
                    DBSchemaInstance dBSchemaInstance = (DBSchemaInstance)dBChildInstance;
                    SchemaFolder schemaFolder = new SchemaFolder(DBURLFormatHelper.getURL(string2, string3, string, (String)dBSchemaInstance.getProperty("SCHEMA"), null), dBSchemaInstance, string4);
                    arrayList.add(schemaFolder);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }
    }
}

