/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.ConnectionFolderOwner;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeRoot;
import oracle.dbtools.raptor.navigator.db.IConnectionNode;
import oracle.dbtools.raptor.navigator.db.Uncollapsable;
import oracle.dbtools.raptor.navigator.db.impl.ConnectionStoresTreeNode;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class GroupedConnections
extends DefaultContainer
implements ConnectionFolderOwner,
Uncollapsable {
    private Observer mObserver = new Observer(){

        public void update(final Object object, final UpdateMessage updateMessage) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.doUpdate(object, updateMessage);
                    }
                });
            } else {
                this.doUpdate(object, updateMessage);
            }
        }

        private void doUpdate(Object object, UpdateMessage updateMessage) {
            int n = updateMessage.getMessageID();
            if (n == UpdateMessage.CHILD_ADDED) {
                GroupedConnections.this.handleChildrenAdded(updateMessage.getAddObjects());
            } else if (n == UpdateMessage.CHILD_REMOVED) {
                GroupedConnections.this.handleChildrenRemoved(updateMessage.getRemoveObjects());
            }
        }
    };
    private List<DatabaseTypeRoot> mRoots;

    public static GroupedConnections getInstance() {
        return Holder.INSTANCE;
    }

    private GroupedConnections() {
    }

    protected void handleChildrenAdded(List list) {
        if (list != null) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (Object e : list) {
                Element element = (Element)e;
                if (!this.add(element, false)) continue;
                arrayList.add(element);
            }
            if (arrayList.size() > 0) {
                UpdateMessage.fireChildrenAdded((Subject)this, arrayList);
            }
        }
    }

    protected void handleChildrenRemoved(List list) {
        if (list != null) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (Object e : list) {
                Element element = (Element)e;
                if (!this.remove(element, false)) continue;
                arrayList.add(element);
            }
            if (arrayList.size() > 0) {
                UpdateMessage.fireChildrenRemoved((Subject)this, arrayList);
            }
        }
    }

    public String getShortLabel() {
        return DatabaseNavigatorResources.getString("STANDALONE_NAVIGATOR_LABEL");
    }

    public Icon getIcon() {
        return DatabaseConnectionStores.getInstance().getIcon("IdeConnections");
    }

    protected void openImpl() throws IOException {
        this.mRoots = ConnectionStoresTreeNode.fetchRoots();
        ArrayList<IConnectionNode> arrayList = new ArrayList<IConnectionNode>();
        for (DatabaseTypeRoot databaseTypeRoot : this.mRoots) {
            databaseTypeRoot.attach(this.mObserver);
            Iterator iterator = databaseTypeRoot.getChildren();
            while (iterator.hasNext()) {
                arrayList.add((IConnectionNode)iterator.next());
            }
        }
        this._children.addAll(arrayList);
    }

    protected void closeImpl() throws IOException {
        List<DatabaseTypeRoot> list = this.mRoots;
        if (list != null) {
            this.mRoots = null;
            for (DatabaseTypeRoot databaseTypeRoot : list) {
                databaseTypeRoot.detach(this.mObserver);
            }
        }
        this._children.clear();
    }

    public void markDirty(boolean bl) {
    }

    private static class Holder {
        static GroupedConnections INSTANCE = new GroupedConnections();

        private Holder() {
        }
    }
}

