/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.raptor.navigator.CreateActionProvider;
import oracle.dbtools.raptor.navigator.db.AbstractDBViewController;
import oracle.dbtools.raptor.navigator.db.DBViewControllerImpl;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.TextNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;

public final class DefaultCreateActionProvider
implements CreateActionProvider {
    private static Set<String> s_unsupportedTypes = new HashSet<String>(Arrays.asList("SYNONYM", "PUBLIC_SYNONYM"));

    public static IdeAction getDefaultNewAction(DBObject dBObject) {
        DBEditorFactory dBEditorFactory;
        Database database;
        IdeAction ideAction = null;
        String string = dBObject.getObjectFolderType();
        if (!s_unsupportedTypes.contains(string) && (database = AbstractDBViewController.getDatabase(dBObject.getConnectionName())) != null && (dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)database, (String)string)) != null) {
            try {
                Schema schema = database.getSchema(dBObject.getSchemaName());
                if (dBEditorFactory.canCreateDBObject(schema, (DBObjectProvider)database, string)) {
                    ideAction = DBViewControllerImpl.ACTION_NEWOBJECT;
                    DBViewControllerImpl.updateAction(ideAction, dBObject, database, string, dBEditorFactory);
                }
            }
            catch (DBException dBException) {
                Logger.severe(DefaultCreateActionProvider.class, (Throwable)dBException);
            }
        }
        return ideAction;
    }

    @Override
    public IdeAction getNewAction(Element element) {
        DBObject dBObject = new DBObject(element);
        return DefaultCreateActionProvider.getDefaultNewAction(dBObject);
    }

    @Override
    public IdeAction getEditAction(Element element) {
        IdeAction ideAction = null;
        if (element instanceof TextNode && element instanceof DatabaseNode && !((DatabaseNode)element).getObjectType().equals("XML SCHEMA")) {
            ideAction = DBViewControllerImpl.ACTION_EDITOBJECT;
        } else if (element instanceof DatabaseNode) {
            DatabaseNode databaseNode = (DatabaseNode)element;
            String string = (String)databaseNode.getProperty("ConnectionName");
            String string2 = (String)databaseNode.getProperty("TYPE");
            Database database = DBViewControllerImpl.getDatabase(string);
            if (database != null && DBViewControllerImpl.canEditObject(databaseNode)) {
                ideAction = DBViewControllerImpl.ACTION_EDITOBJECT;
                ideAction.putValue("DBObjectType", (Object)string2);
                ideAction.putValue("Database", (Object)database);
                ideAction.putValue("URL", (Object)databaseNode.getURL());
            }
        }
        return ideAction;
    }
}

