/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.CreateActionProvider;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.config.NavigatorSettings;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.db.AbstractDBViewController;
import oracle.dbtools.raptor.navigator.db.ConnectionStores;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeSupport;
import oracle.dbtools.raptor.navigator.db.DefaultCreateActionProvider;
import oracle.dbtools.raptor.navigator.db.impl.FilterableTreeNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.ExceptionDialogRunnable;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.TNSPing;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class DBViewControllerImpl
extends AbstractDBViewController {
    static final String OBJECT_URL = "URL";
    public static final IdeAction ACTION_NEW_CONN = IdeAction.find((int)NEW_DBCONN_CMD_ID);
    public static final IdeAction ACTION_CONNECT = IdeAction.find((int)OPEN_CMD_ID);
    public static final IdeAction ACTION_DISCONNECT = IdeAction.find((int)CLOSE_CMD_ID);
    public static final IdeAction ACTION_RECONNECT = IdeAction.find((int)REOPEN_CMD_ID);
    public static final IdeAction ACTION_NEWOBJECT = IdeAction.find((int)NEW_OJBECT_CMD_ID);
    public static final IdeAction ACTION_EDITOBJECT = IdeAction.find((int)EDIT_OBJECT_CMD_ID);
    private static final int GROUP_CONNECTION_TYPES_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.GroupConnections");
    protected static CreateActionProvider s_actionProvider;

    public static CreateActionProvider getCreateActionProvider() {
        if (s_actionProvider == null) {
            s_actionProvider = new DefaultCreateActionProvider();
        }
        return s_actionProvider;
    }

    public static void setCreateActionProvider(CreateActionProvider createActionProvider) {
        s_actionProvider = createActionProvider;
    }

    private void connect(DatabaseConnection databaseConnection, Context context) {
        block9: {
            try {
                databaseConnection.getConnection();
                NavigatorTree navigatorTree = this.getTree();
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
                if (navigatorTreeNode == null) {
                    navigatorTreeNode = navigatorTree.findTreeNode(databaseConnection, navigatorTree.getRoot());
                }
                if (navigatorTreeNode != null && navigatorTreeNode.getElement() == databaseConnection) {
                    navigatorTree.expand(navigatorTreeNode, false);
                }
            }
            catch (IOException iOException) {
                Throwable throwable = iOException;
                if (iOException instanceof WrappedException) {
                    throwable = iOException.getCause();
                }
                Throwable throwable2 = throwable;
                while (throwable instanceof DBException) {
                    if ((throwable = throwable.getCause()) == null) continue;
                    throwable2 = throwable;
                }
                if (throwable2 instanceof ConnectionCanceledException) break block9;
                ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString("ERROR_OPENING"), throwable2);
                if (SwingUtilities.isEventDispatchThread()) {
                    exceptionDialogRunnable.run();
                }
                try {
                    SwingUtilities.invokeAndWait(exceptionDialogRunnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void reopenConnection(DatabaseConnection databaseConnection) {
        block14: {
            Database database = null;
            String string = databaseConnection.getQualifiedConnectionName();
            try {
                database = Connections.getInstance().getDatabase(string, true);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (databaseConnection.isConnectionOpen() && database != null) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                boolean bl = false;
                databaseConnection.refreshPingTime();
                if (databaseConnection.getPingTime() > TNSPing.DOWN) {
                    bl = database.isConnectionAlive() ? MessageDialog.confirm(null, (Object)DatabaseNavigatorResources.format("CONFIRM_FORCE_RECONNECT", Connections.getDisplayName(string)), (String)DatabaseNavigatorResources.getString("CONFIRM_RECONNECT_TITLE"), null) : true;
                } else {
                    bl = true;
                    object4 = Connections.getInstance().getConnectionInfo(string);
                    object3 = ((Properties)object4).getProperty("OracleConnectionType");
                    if ("SSH".equals(object3)) {
                        object2 = ((Properties)object4).getProperty("SshHost.NAME");
                        object = ((Properties)object4).getProperty("SshTunnel.NAME");
                        if (ModelUtil.hasLength((String)object2) && ModelUtil.hasLength((String)object)) {
                            Client client = Client.getInstance();
                            Store store = client.getStore();
                            HostDescriptor hostDescriptor = store.getHostDescriptor((String)object2);
                            client.closeConnection(hostDescriptor);
                        }
                    }
                }
                if (bl) {
                    try {
                        object4 = Connections.getInstance().reopenConnection(string);
                        databaseConnection.reopenConnection(object4);
                    }
                    catch (DBException dBException) {
                        object2 = object3 = dBException;
                        while (object3 instanceof DBException) {
                            if ((object3 = ((Throwable)object3).getCause()) == null) continue;
                            object2 = object3;
                        }
                        if (object2 instanceof ConnectionCanceledException) break block14;
                        object = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString("ERROR_OPENING"), (Throwable)object2);
                        if (SwingUtilities.isEventDispatchThread()) {
                            object.run();
                        }
                        try {
                            SwingUtilities.invokeAndWait((Runnable)object);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public static void deleteConnection(DatabaseConnection databaseConnection, Context context) throws ConnectionException {
        assert (databaseConnection != null);
        String string = databaseConnection.getQualifiedConnectionName();
        String string2 = DatabaseNavigatorResources.format("MGR_CONFIRM_DEL", Connections.getDisplayName(string));
        if (MessageDialog.confirm(null, (Object)string2, (String)DatabaseNavigatorResources.getString("MGR_CONFIRM_TITLE"), null, (boolean)true)) {
            DBViewControllerImpl.closeAndDeleteConnection(databaseConnection);
        }
    }

    private static boolean deleteConnectionSilent(DatabaseConnection databaseConnection) throws ConnectionException {
        assert (databaseConnection != null);
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(databaseConnection.getStoreName());
        return databaseConnections.removeConnection(databaseConnection.getConnectionName());
    }

    public static void closeAndDeleteConnection(DatabaseConnection databaseConnection) throws ConnectionException {
        DisconnectTask disconnectTask = new DisconnectTask(databaseConnection.getQualifiedConnectionName(), false);
        disconnectTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)disconnectTask, databaseConnection){
            final /* synthetic */ RaptorTask val$task;
            final /* synthetic */ DatabaseConnection val$databaseConn;
            {
                this.val$task = raptorTask;
                this.val$databaseConn = databaseConnection;
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    if (this.val$task.getResult() == Boolean.TRUE) {
                        DBViewControllerImpl.deleteConnectionSilent(this.val$databaseConn);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)disconnectTask);
    }

    static void createNewConnection(Context context) {
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getCurrentStore(context);
        String string = databaseConnections != null ? databaseConnections.getStoreName() : "IdeConnections";
        DatabaseConnectionEditor.editConnection((String)string, null);
    }

    static void editConnection(String string, String string2) {
        DatabaseConnectionEditor.editConnection((String)string, (String)string2);
    }

    DBViewControllerImpl(DBNavigatorWindow dBNavigatorWindow) {
        super((View)dBNavigatorWindow);
        Connections.getInstance().addConnectionListener(new ConnectionAdapter());
    }

    private DBNavigatorWindow getNavigatorWindow() {
        return (DBNavigatorWindow)this.getOwningView();
    }

    @Override
    protected void refreshNode(Context context) {
        Controller controller;
        View view;
        IdeAction ideAction = IdeAction.find((int)51);
        if (ideAction != null && (view = context.getView()) != null && (controller = view.getController()) != null) {
            controller.handleEvent(ideAction, context);
        }
    }

    @Override
    protected void refreshParent(Context context) {
    }

    private NavigatorTree getTree() {
        return this.getNavigatorWindow().getTree();
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        Element element = context.getElement();
        if (n == NEW_DBCONN_CMD_ID || n == NEW_CONN_CHILD_CMD_ID) {
            DBViewControllerImpl.createNewConnection(context);
            bl = true;
        } else if (n == OPEN_CMD_ID) {
            if (element instanceof DatabaseConnection) {
                this.runAsTask((String)ideAction.getValue("Name"), () -> this.connect((DatabaseConnection)element, context));
                bl = true;
            }
        } else if (n == REOPEN_CMD_ID) {
            if (element instanceof DatabaseConnection) {
                this.runAsTask((String)ideAction.getValue("Name"), () -> DBViewControllerImpl.reopenConnection((DatabaseConnection)element));
                bl = true;
            }
        } else if (n == CLOSE_CMD_ID) {
            if (element instanceof DatabaseConnection) {
                String string = ((DatabaseConnection)element).getQualifiedConnectionName();
                if (DBStarterFactory.isDebugSessionActive(string)) {
                    MessageDialog.error(null, (Object)DatabaseNavigatorResources.getString("CONTROLLER_ACTIVE_DEBUGGER_MSG"), (String)DatabaseNavigatorResources.getString("CONTROLLER_CANNOT_DISCONNECT"), null);
                } else {
                    DisconnectTask disconnectTask = new DisconnectTask(string, false);
                    RaptorTaskManager.getInstance().addTask((RaptorTask)disconnectTask);
                }
                bl = true;
            }
        } else if (n == 20) {
            for (Element element2 : context.getSelection()) {
                if (!(element2 instanceof DatabaseConnection)) continue;
                try {
                    DBViewControllerImpl.deleteConnection((DatabaseConnection)element2, context);
                }
                catch (ConnectionException connectionException) {
                    MessageDialog.error(null, (Object)connectionException.getMessage(), (String)DatabaseNavigatorResources.getString("CONTROLLER_CANNOT_DELETE"), null);
                }
                bl = true;
            }
        } else if (n == 56) {
            if (element instanceof DatabaseConnection) {
                DatabaseConnection databaseConnection = (DatabaseConnection)element;
                DBViewControllerImpl.editConnection(databaseConnection.getStoreName(), databaseConnection.getConnectionName());
                bl = true;
            }
        } else if (n == CLEAR_FILTER_CMD_ID) {
            NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
            if (navigatorTreeNode instanceof FilterableTreeNode && ((FilterableTreeNode)((Object)navigatorTreeNode)).clearFilter()) {
                DatabaseOverlayClient.updateOverlay(navigatorTreeNode.getElement());
                this.refreshNode(context);
            }
            bl = true;
        } else if (n == GROUP_CONNECTION_TYPES_ID) {
            NavigatorTreeNode navigatorTreeNode;
            Element element3;
            NavigatorTree navigatorTree = NavigatorContext.getNavigatorTreeFromContext(context);
            if (navigatorTree != null && (element3 = (navigatorTreeNode = navigatorTree.getRoot()).getElement()) instanceof ConnectionStores) {
                boolean bl2 = ideAction.getState();
                ConnectionStores connectionStores = (ConnectionStores)element3;
                NavigatorSettings.getDefaultInstance().setGroupedByType(bl2);
                UpdateMessage.fireStructureChanged((Subject)connectionStores);
                navigatorTree.getOwningView().expandVisibleRoot(navigatorTree);
            }
            bl = true;
        }
        return bl || super.handleEvent(ideAction, context);
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        Element element = context.getElement();
        int n = ideAction.getCommandId();
        if (n == 47) {
            ideAction.setEnabled(false);
            bl = true;
        } else if (n == NEW_DBCONN_CMD_ID) {
            if (ideAction.isLocalAction()) {
                View view = context.getView();
                List<String> list = DatabaseTypeSupport.getSupportedDatabaseTypes();
                int n2 = list.size();
                IdeAction[] ideActionArray = new IdeAction[n2];
                int n3 = 0;
                for (String string : list) {
                    ideActionArray[n3++] = DatabaseTypeSupport.getLocalNewAction(string, view, false);
                }
                ideAction.putValue("ActionMenuActions", (Object)ideActionArray);
            }
        } else if (n == OPEN_CMD_ID) {
            ideAction.setEnabled(element instanceof DatabaseConnection && !((DatabaseConnection)element).isConnectionOpen());
            bl = true;
        } else if (n == REOPEN_CMD_ID) {
            boolean bl2 = false;
            if (element instanceof DatabaseConnection) {
                DatabaseConnection databaseConnection = (DatabaseConnection)element;
                bl2 = Connections.getInstance().isConnectionOpenFast(databaseConnection.getQualifiedConnectionName());
            }
            ideAction.setEnabled(bl2);
            bl = true;
        } else if (n == CLOSE_CMD_ID) {
            boolean bl3 = false;
            if (element instanceof DatabaseConnection) {
                DatabaseConnection databaseConnection = (DatabaseConnection)element;
                bl3 = databaseConnection.isConnectionOpen() && !DBStarterFactory.isDebugSessionActive(databaseConnection.getQualifiedConnectionName());
            }
            ideAction.setEnabled(bl3);
            bl = true;
        } else if (n == 20) {
            if (element instanceof DatabaseConnection) {
                ideAction.setEnabled(true);
                bl = true;
            }
        } else if (n == 56) {
            if (element instanceof DatabaseConnection) {
                ideAction.setEnabled(true);
                bl = true;
            }
        } else if (n == NEW_OJBECT_CMD_ID) {
            boolean bl4 = false;
            if (element instanceof DatabaseFolder && PermissionRegistry.canCreate(new DBObject(element))) {
                String string = (String)ideAction.getValue("DBObjectType");
                Database database = (Database)ideAction.getValue("Database");
                DBEditorFactory dBEditorFactory = (DBEditorFactory)ideAction.getValue("DBEditorFactory");
                DBObject dBObject = (DBObject)((Object)ideAction.getValue("ObjectAction.DBOBJECT"));
                if (dBObject == null) {
                    ideAction.putValueDirectly("ObjectAction.DBOBJECT", context.getProperty("ObjectAction.DBOBJECT"));
                }
                bl4 = dBEditorFactory != null && dBEditorFactory.canCreateDBObject(null, (DBObjectProvider)database, string);
            }
            ideAction.setEnabled(bl4);
            bl = true;
        } else if (n == CLEAR_FILTER_CMD_ID) {
            NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
            ideAction.setEnabled(navigatorTreeNode instanceof FilterableTreeNode && ((FilterableTreeNode)((Object)navigatorTreeNode)).isFiltered());
            bl = true;
        } else if (n == FILTER_CMD_ID) {
            NavigatorTreeNode navigatorTreeNode;
            DBObject dBObject = new DBObject(element);
            boolean bl5 = false;
            if ((dBObject.isOracle() || dBObject.isTimesTen()) && (navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context)) instanceof FilterableTreeNode) {
                bl5 = ((FilterableTreeNode)((Object)navigatorTreeNode)).canHaveFilter();
            }
            ideAction.setEnabled(bl5);
            bl = true;
        } else if (n == GROUP_CONNECTION_TYPES_ID) {
            NavigatorTreeNode navigatorTreeNode;
            Element element2;
            NavigatorTree navigatorTree = NavigatorContext.getNavigatorTreeFromContext(context);
            if (navigatorTree != null && (element2 = (navigatorTreeNode = navigatorTree.getRoot()).getElement()) instanceof ConnectionStores) {
                ideAction.setState(NavigatorSettings.getDefaultInstance().isGroupedByType());
            }
            ideAction.putValueDirectly("SmallIcon", (Object)OracleIcons.getIcon((String)(ideAction.getState() ? "sortbytype.png" : "sortbyalpha.png")));
            ideAction.setEnabled(true);
            bl = true;
        }
        return bl || super.update(ideAction, context);
    }

    private void runAsTask(String string, final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(string, true, IRaptorTaskRunMode.TASKVIEWER){

            protected Void doWork() throws TaskException {
                runnable.run();
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private static class ConnectionAdapter
    implements ConnectionListener {
        private ConnectionAdapter() {
        }

        @Override
        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRenamed(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionOpened(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            DatabaseConnection databaseConnection = Databases.getConnectionNode(string, false);
            if (databaseConnection != null && databaseConnection.openConnection()) {
                this.updateOverlays(databaseConnection);
                UpdateMessage.fireObjectOpened((Subject)databaseConnection);
            }
        }

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            DatabaseConnection databaseConnection;
            String string = connectionEvent.getConnectionName();
            Database database = AbstractDBViewController.s_databases.remove(string);
            if (database != null) {
                database.close();
            }
            if ((databaseConnection = Databases.getConnectionNode(string, false)) != null && databaseConnection.isConnectionOpen()) {
                databaseConnection.closeConnection(false);
                this.updateOverlays(databaseConnection);
                UpdateMessage.fireObjectClosed((Subject)databaseConnection);
            }
        }

        private void updateOverlays(DatabaseConnection databaseConnection) {
            IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
            if (iconOverlayTracker != null) {
                iconOverlayTracker.validateOverlay((Element)databaseConnection);
                iconOverlayTracker.repaintOverlays();
            }
        }
    }

    private static class DisconnectTask
    extends DatabaseQueryTask<Boolean> {
        private String m_cName;
        private boolean m_force;

        DisconnectTask(String string, boolean bl) {
            super(DatabaseNavigatorResources.format("CONTROLLER_DISCONNECTING", Connections.getDisplayName(string)), IRaptorTaskRunMode.TASKVIEWER, false, false, true);
            this.m_cName = string;
        }

        public String getConnectionName() {
            return this.m_cName;
        }

        public String getQuery() {
            return null;
        }

        protected Boolean doWork() throws TaskException {
            return Connections.getInstance().closeConnection(this.m_cName, this.m_force);
        }
    }
}

