/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.io.IOException;
import java.net.URL;
import oracle.dbtools.raptor.navigator.db.IConnectionNode;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.util.Logger;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.WeakCache;

public abstract class BaseConnectionNode<T>
extends DefaultElement
implements ViewableElement,
Subject,
IConnectionNode<T> {
    private static WeakCache<URL, BaseConnectionNode> s_cache;
    private URL m_url = null;
    private IdeSubject m_subject = new IdeSubject();
    private Object __LOCK__ = new Object();
    private T m_conn = null;

    protected static WeakCache<URL, BaseConnectionNode> getNodeCache() {
        if (s_cache == null) {
            s_cache = new WeakCache();
        }
        return s_cache;
    }

    protected static void cacheNode(URL uRL, BaseConnectionNode baseConnectionNode) {
        WeakCache<URL, BaseConnectionNode> weakCache = BaseConnectionNode.getNodeCache();
        weakCache.put((Object)uRL, (Object)baseConnectionNode);
    }

    protected static void uncacheNode(URL uRL) {
        WeakCache<URL, BaseConnectionNode> weakCache = BaseConnectionNode.getNodeCache();
        weakCache.remove((Object)uRL);
    }

    protected static <C extends BaseConnectionNode> C findConnectionNodeImpl(URL uRL) {
        return (C)((BaseConnectionNode)BaseConnectionNode.getNodeCache().get((Object)uRL));
    }

    protected static <C extends BaseConnectionNode> C findOrCreateConnectionNodeImpl(URL uRL, Class<C> clazz) {
        Object object = BaseConnectionNode.findConnectionNodeImpl(uRL);
        if (object == null) {
            try {
                object = (BaseConnectionNode)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                Logger.severe(clazz, (Throwable)reflectiveOperationException);
            }
            ((BaseConnectionNode)object).setURL(uRL);
        }
        return object;
    }

    protected BaseConnectionNode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T getConnection() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn == null) {
                this.m_conn = this.openConnectionImpl();
            }
        }
        return this.m_conn;
    }

    public final boolean openConnection() {
        boolean bl = this.isConnectionOpen();
        if (!bl) {
            try {
                this.getConnection();
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenConnection(T t) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn != null) {
                this.m_conn = t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeConnection() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn != null) {
                this.closeConnectionImpl();
                this.m_conn = null;
            }
        }
    }

    public final void closeConnection(boolean bl) {
        if (bl) {
            this.closeConnection();
        } else {
            this.forgetConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetConnection() {
        Object object = this.getLock();
        synchronized (object) {
            this.m_conn = null;
        }
    }

    protected final boolean isConnectionSet() {
        return this.m_conn != null;
    }

    protected abstract T openConnectionImpl() throws IOException;

    protected abstract boolean closeConnectionImpl();

    @Override
    public final boolean isConnectionOpen() {
        return this.m_conn != null;
    }

    protected Object getLock() {
        return this.__LOCK__;
    }

    @Override
    public abstract String getQualifiedConnectionName();

    public String getStoreName() {
        return null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public final URL getURL() {
        return this.m_url;
    }

    public final void setURL(URL uRL) {
        boolean bl = false;
        URL uRL2 = this.m_url;
        if (uRL2 != null) {
            bl = uRL != null;
            BaseConnectionNode.uncacheNode(uRL2);
        }
        this.m_url = uRL;
        if (uRL != null) {
            BaseConnectionNode.cacheNode(uRL, this);
        }
        if (bl) {
            UpdateMessage.fireObjectRenamed((Subject)this);
        }
    }

    public final void attach(Observer observer) {
        this.m_subject.attach(observer);
    }

    public final void detach(Observer observer) {
        this.m_subject.detach(observer);
    }

    public final void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.m_subject.notifyObservers(object, updateMessage);
    }

    public static class ExceptionWrapper
    extends IOException {
        public ExceptionWrapper(Throwable throwable) {
            this.initCause(throwable);
        }
    }
}

