/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.mimeeditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;

    private WinRegistry() {
    }

    public static String readString(int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readString(systemRoot, n, string, string2);
        }
        if (n == -2147483647) {
            return WinRegistry.readString(userRoot, n, string, string2);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    public static Map<String, String> readStringValues(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readStringValues(systemRoot, n, string);
        }
        if (n == -2147483647) {
            return WinRegistry.readStringValues(userRoot, n, string);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    public static List<String> readStringSubKeys(int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readStringSubKeys(systemRoot, n, string);
        }
        if (n == -2147483647) {
            return WinRegistry.readStringSubKeys(userRoot, n, string);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    private static String readString(Preferences preferences, int n, String string, String string2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            return null;
        }
        byte[] byArray = (byte[])regQueryValueEx.invoke((Object)preferences, new Integer(nArray[0]), WinRegistry.toCstr(string2));
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return byArray != null ? new String(byArray).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, new Integer(nArray[0]));
        int n2 = nArray2[2];
        int n3 = nArray2[3];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = (byte[])regEnumValue.invoke((Object)preferences, new Integer(nArray[0]), new Integer(i), new Integer(n3 + 1));
            String string2 = WinRegistry.readString(n, string, new String(byArray));
            hashMap.put(new String(byArray).trim(), string2);
        }
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return hashMap;
    }

    private static List<String> readStringSubKeys(Preferences preferences, int n, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, new Integer(n), WinRegistry.toCstr(string), new Integer(131097));
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, new Integer(nArray[0]));
        int n2 = nArray2[2];
        int n3 = nArray2[3];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = (byte[])regEnumKeyEx.invoke((Object)preferences, new Integer(nArray[0]), new Integer(i), new Integer(n3 + 1));
            arrayList.add(new String(byArray).trim());
        }
        regCloseKey.invoke((Object)preferences, new Integer(nArray[0]));
        return arrayList;
    }

    private static byte[] toCstr(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[string.length()] = 0;
        return byArray;
    }

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }
}

