/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.mimeeditor;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.raptor.mimeeditor.AppCommandXml;
import oracle.dbtools.raptor.mimeeditor.MimeEditorArb;
import oracle.dbtools.raptor.mimeeditor.OSProperties;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.javatools.data.ListStructure;
import oracle.javatools.dialogs.MessageDialog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppCommandXmlParser
extends DefaultHandler {
    private String m_appMimeType = null;
    private String m_applicationCommand = null;
    private String m_appExecCommand = null;
    private List<AppCommandXml> appCommandList = new ArrayList<AppCommandXml>();
    private String tempVal;
    private AppCommandXml tempAppComm;
    private OSProperties m_OsProperty;
    private static String m_OsName = null;
    private static String m_xmlFileName = null;
    private static String m_appLocationCommandXML = "ApplicationLocation.xml";

    public AppCommandXmlParser() {
        this.setXMLCommandFile();
    }

    public boolean parseAppCommandXML() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.getApplicationLocationXmlFile().openStream(), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
            ExceptionHandler.handleException((Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, parserConfigurationException.getStackTrace()[0].toString(), parserConfigurationException);
            ExceptionHandler.handleException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            ExceptionHandler.handleException((Throwable)iOException);
        }
        return true;
    }

    public Map<String, List<String>> getMimeTypeExtensionCommands() {
        for (AppCommandXml appCommandXml : this.appCommandList) {
            if (!this.getOsName().equals(appCommandXml.getOSName())) continue;
            Vector<String> vector = appCommandXml.getAppMimeTypeVec();
            Vector<String> vector2 = appCommandXml.getAppExtensionVec();
            Vector<String> vector3 = appCommandXml.getApplicationCommandVec();
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            for (int i = 0; i < vector2.size(); ++i) {
                ListStructure listStructure = ListStructure.newInstance();
                listStructure.add((Object)vector.elementAt(i).toString());
                String string = vector3.elementAt(i).toString();
                if (string != null && !string.equals("")) {
                    listStructure.add((Object)this.getAppExecCommandLine(string));
                } else {
                    listStructure.add(null);
                }
                hashMap.put("." + vector2.elementAt(i).toString(), (List<String>)listStructure);
            }
            return hashMap;
        }
        return null;
    }

    public boolean parseAppCommandXML(String string) {
        this.setAppMimeType(string);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.getApplicationLocationXmlFile().openStream(), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
            ExceptionHandler.handleException((Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, parserConfigurationException.getStackTrace()[0].toString(), parserConfigurationException);
            ExceptionHandler.handleException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            ExceptionHandler.handleException((Throwable)iOException);
        }
        return true;
    }

    public String getMimeApplicationCommand() {
        for (AppCommandXml appCommandXml : this.appCommandList) {
            if (!this.getOsName().equals(appCommandXml.getOSName())) continue;
            Vector<String> vector = appCommandXml.getAppMimeTypeVec();
            Vector<String> vector2 = appCommandXml.getApplicationCommandVec();
            for (int i = 0; i < vector.size(); ++i) {
                if (!this.getAppMimeType().equals(vector.elementAt(i).toString())) continue;
                this.setApplicationCommand(vector2.elementAt(i).toString());
            }
            return this.getApplicationCommand();
        }
        return null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.tempVal = "";
        if (string3.equalsIgnoreCase("OSProperties")) {
            this.tempAppComm = new AppCommandXml();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.tempVal = new String(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("OSProperties")) {
            this.appCommandList.add(this.tempAppComm);
        }
        if (string3.equalsIgnoreCase("OSName")) {
            this.tempAppComm.setOSName(this.tempVal);
        } else if (string3.equalsIgnoreCase("MimeType")) {
            this.tempAppComm.addAppMimeType(this.tempVal);
        } else if (string3.equalsIgnoreCase("Extension")) {
            this.tempAppComm.addAppExtension(this.tempVal);
        } else if (string3.equalsIgnoreCase("Command")) {
            this.tempAppComm.addApplicationCommand(this.tempVal);
        }
    }

    public void setXMLCommandFile() {
        this.m_OsProperty = new OSProperties();
        String string = this.m_OsProperty.getOSName();
        this.setOsName(string);
        this.setXmlCommandFileName(m_appLocationCommandXML);
    }

    public String getAppExecCommandLine() {
        String string = null;
        if (this.m_OsProperty.getOSName().equals(OSProperties.osUnix)) {
            string = this.m_OsProperty.getUnixCommandLine(this.getMimeApplicationCommand());
        } else if (this.m_OsProperty.getOSName().equals(OSProperties.osWindows)) {
            string = this.m_OsProperty.getWindowsCommandLine(this.getMimeApplicationCommand());
        } else {
            System.out.println("Your OS is not support!!");
        }
        return string;
    }

    public String getAppExecCommandLine(String string) {
        String string2 = null;
        if (this.m_OsProperty.getOSName().equals(OSProperties.osUnix)) {
            string2 = this.m_OsProperty.getUnixCommandLine(string);
        } else if (this.m_OsProperty.getOSName().equals(OSProperties.osWindows)) {
            string2 = this.m_OsProperty.getWindowsCommandLine(string);
        } else if (this.m_OsProperty.getOSName().equals(OSProperties.osMac)) {
            string2 = this.m_OsProperty.getMacCommandLine(string);
        } else if (this.m_OsProperty.getOSName().equals(OSProperties.osUnknown)) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)MimeEditorArb.getString("NO_OS_SUPPORT_ERR"), (String)MimeEditorArb.getString("NO_OS_SUPPORT_ERR_TITLE"), null);
        }
        return string2;
    }

    public String getAppMimeType() {
        return this.m_appMimeType;
    }

    public void setAppMimeType(String string) {
        this.m_appMimeType = string;
    }

    public String getApplicationCommand() {
        return this.m_applicationCommand;
    }

    public void setApplicationCommand(String string) {
        this.m_applicationCommand = string;
    }

    public String getAppExecCommand() {
        return this.m_appExecCommand;
    }

    public void setAppExecCommand(String string) {
        this.m_appExecCommand = string;
    }

    public String getOsName() {
        return m_OsName;
    }

    public void setOsName(String string) {
        m_OsName = string;
    }

    public String getXmlCommandFileName() {
        return m_xmlFileName;
    }

    public void setXmlCommandFileName(String string) {
        m_xmlFileName = string;
    }

    protected URL getApplicationLocationXmlFile() {
        String string = "/oracle/dbtools/raptor/mimeeditor/ApplicationLocation.xml";
        return this.getClass().getResource(string);
    }
}

