/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.javafx.fxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.util.BuilderFactory;
import oracle.dbtools.raptor.javafx.query.FxQueryController;
import oracle.dbtools.util.Logger;
import oracle.javatools.util.ModelUtil;

public class FxmlInfo {
    String fxmlFile;
    String resourceBundle;
    ClassLoader classLoader;
    Parent parent;
    FxQueryController fxQueryController;

    public Parent getFxmlUI() {
        return this.parent;
    }

    public FxQueryController getController() {
        return this.fxQueryController;
    }

    FxmlInfo(String string, String string2, ClassLoader classLoader) {
        assert (ModelUtil.hasLength((String)string));
        assert (classLoader != null);
        this.fxmlFile = string;
        this.resourceBundle = string2;
        this.classLoader = classLoader;
        this.load();
    }

    public void setConnection(String string) {
        if (this.fxQueryController != null) {
            this.fxQueryController.setConnection(string);
        }
    }

    public void setUpdateInterval(long l) {
        if (this.fxQueryController != null) {
            this.fxQueryController.setUpdateInterval(l);
        }
    }

    public void update() {
        if (this.fxQueryController != null) {
            this.fxQueryController.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Object object;
        URL uRL = this.classLoader.getResource(this.fxmlFile);
        FXMLLoader fXMLLoader = new FXMLLoader();
        fXMLLoader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        fXMLLoader.setClassLoader(this.classLoader);
        fXMLLoader.setLocation(uRL);
        if (this.resourceBundle != null) {
            object = ResourceBundle.getBundle(this.resourceBundle, Locale.getDefault(), this.classLoader);
            fXMLLoader.setResources((ResourceBundle)object);
        }
        object = null;
        try {
            object = uRL.openStream();
            this.parent = (Parent)fXMLLoader.load((InputStream)object);
            Object object2 = fXMLLoader.getController();
            if (object2 instanceof FxQueryController) {
                this.fxQueryController = (FxQueryController)object2;
            }
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    Logger.warn(this.getClass(), (Throwable)iOException);
                }
            }
        }
    }
}

