/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.gallery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.gallery.GalleryItem;
import oracle.dbtools.raptor.gallery.GalleryResources;
import oracle.dbtools.raptor.gallery.NewConnectionItem;
import oracle.dbtools.raptor.gallery.NewFileItem;
import oracle.dbtools.raptor.gallery.NewObjectItem;
import oracle.dbtools.raptor.navigator.OracleNavigatorResource;
import oracle.javatools.icons.OracleIcons;

public final class GalleryManager {
    private static final GalleryManager INSTANCE = new GalleryManager();
    private static final String CATEGORY_CONN = "CONNECTION";
    private static final String CATEGORY_OBJECT = "OBJECT";
    private static final String CATEGORY_FILE = "FILE";
    private Map<String, List<? extends GalleryItem>> m_items;

    public static GalleryManager getInstance() {
        return INSTANCE;
    }

    private GalleryManager() {
    }

    public String[] getCategories() {
        return new String[]{CATEGORY_CONN, CATEGORY_OBJECT, CATEGORY_FILE};
    }

    public GalleryItem[] getItems(String string) {
        List<? extends GalleryItem> list;
        if (this.m_items == null) {
            this.loadItems();
        }
        return (list = this.m_items.get(string)) != null ? list.toArray(new GalleryItem[0]) : new GalleryItem[]{};
    }

    private void loadItems() {
        this.m_items = new HashMap<String, List<? extends GalleryItem>>();
        this.m_items.put(CATEGORY_CONN, Collections.singletonList(new NewConnectionItem()));
        ArrayList<GalleryItem> arrayList = new ArrayList<GalleryItem>();
        arrayList.add(new NewObjectItem("TABLE", GalleryResources.getString("TABLE_NAME"), null, GalleryResources.getString("TABLE_TOOLTIP"), OracleIcons.getIcon((String)"table.png")));
        arrayList.add(new NewObjectItem("VIEW", GalleryResources.getString("VIEW_NAME"), null, GalleryResources.getString("VIEW_TOOLTIP"), OracleIcons.getIcon((String)"view.png")));
        arrayList.add(new NewObjectItem("PACKAGE", Messages.getString("Navigator.Package"), null, GalleryResources.getString("PACKAGE_TOOLTIP"), OracleIcons.getIcon((String)"plsql_package.png")));
        arrayList.add(new NewObjectItem("PROCEDURE", Messages.getString("Navigator.Procedure"), null, GalleryResources.getString("PROCEDURE_TOOLTIP"), OracleNavigatorResource.getIcon("PROCEDURE_ICON")));
        arrayList.add(new NewObjectItem("FUNCTION", Messages.getString("Navigator.Function"), null, GalleryResources.getString("FUNCTION_TOOLTIP"), OracleNavigatorResource.getIcon("FUNCTION_ICON")));
        arrayList.add(new NewObjectItem("TRIGGER", Messages.getString("Navigator.Trigger"), null, GalleryResources.getString("TRIGGER_TOOLTIP"), OracleIcons.getIcon((String)"trigger.png")));
        this.m_items.put(CATEGORY_OBJECT, arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NewFileItem());
        this.m_items.put(CATEGORY_FILE, arrayList);
    }
}

