/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.controls.search.SearchPanel;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.panels.ByTypeSearchPanel;
import oracle.dbtools.raptor.ui.panels.SearchObjectsShuttlePanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public abstract class ExtractWizObjectShuttlePanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    static final String KEY_CNAME = "CONNECTION_NAME";
    protected final JCheckBox cbGoToSummary = new JCheckBox();
    protected TraversableContext _dataContext;
    private ExtractListModel _listModel = null;
    private SearchObjectsShuttlePanel _oPanel = null;
    private boolean _isShowGoToSummary = true;
    private boolean isTablespaceEnabled = false;
    private boolean isSchemasEnabled = false;

    public ExtractWizObjectShuttlePanel() {
        this(new ByTypeSearchPanel(), true);
    }

    public ExtractWizObjectShuttlePanel(ByTypeSearchPanel byTypeSearchPanel) {
        this(byTypeSearchPanel, true);
    }

    public ExtractWizObjectShuttlePanel(boolean bl) {
        this(new ByTypeSearchPanel(), bl);
    }

    public ExtractWizObjectShuttlePanel(SearchPanel searchPanel, boolean bl) {
        this._isShowGoToSummary = bl;
        this._oPanel = new SearchObjectsShuttlePanel(searchPanel);
        this.setLayout(new GridBagLayout());
        this.add(this._oPanel.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this._isShowGoToSummary) {
            ResourceUtils.resButton((AbstractButton)this.cbGoToSummary, (String)UiResources.getString("GOTO_SUMMARY"));
            this.add(this.cbGoToSummary, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void onExit(TraversableContext traversableContext) {
        if (this._oPanel.isAddMultipleSchemas()) {
            this._listModel.setSchemas(this.getMultipleSchemas());
        }
        if (this.isAddTableSpace()) {
            this._listModel.setTablespaces(this.getTablespaces());
            this._listModel.setSchemas(this.getTablespaceSchemas());
            this._oPanel.setAddTableSpace(true);
            this._oPanel.setTablespaceNames(this.getTablespaces());
        }
        if (this._listModel.getDataFormat() != null && this._listModel.getDataFormat().isExportEnabled()) {
            this._listModel.setSelectExtractBoth(this._oPanel.getUrlList());
        } else {
            this._listModel.setSelectExtractMetaData(this._oPanel.getUrlList());
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._dataContext = traversableContext;
        this._listModel = this.getListModel();
        this._oPanel.setDDLTypes(this.getDDLTypes());
        this._oPanel.setConName(this.getConnectionName());
        if (this.isAddMultipleSchemas()) {
            this._oPanel.setAddMultipleSchemas(true);
            this._oPanel.setMultipleSchemaNames(this.getMultipleSchemas());
        }
        if (this.isAddTableSpace()) {
            this._oPanel.setAddTableSpace(true);
            this._oPanel.setTablespaceNames(this.getTablespaces());
        }
        this._oPanel.setList(this._listModel.getListURLs(0, new int[]{100}));
        if (this.isSearchPanelUpdate()) {
            this._oPanel.updatePanel(true);
        } else {
            this._oPanel.updatePanel();
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        traversableContext.getWizardCallbacks().wizardSetInitialFocus((Component)this._oPanel);
    }

    public abstract Object getExitTransition();

    protected String getConnectionName() {
        return (String)this._dataContext.get(KEY_CNAME);
    }

    protected ExtractListModel getListModel() {
        if ((ExtractListModel)this._dataContext.get("EXTRACT_LIST_MODEL") == null) {
            this._dataContext.put("EXTRACT_LIST_MODEL", (Object)new ExtractListModel());
        }
        return (ExtractListModel)this._dataContext.get("EXTRACT_LIST_MODEL");
    }

    protected DDLTypes getDDLTypes() {
        return this._listModel.getDDLTypes();
    }

    protected void setAddTableSpace(boolean bl) {
        this.isTablespaceEnabled = bl;
    }

    protected void setAddMultipleSchemas(boolean bl) {
        this.isSchemasEnabled = bl;
    }

    private boolean isAddMultipleSchemas() {
        return this.isSchemasEnabled;
    }

    private boolean isAddTableSpace() {
        return this.isTablespaceEnabled;
    }

    private String[] getMultipleSchemas() {
        List list = (List)this._dataContext.get("EXTRACT_SCHEMA_LIST");
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    private String[] getTablespaceSchemas() {
        return (String[])this._dataContext.get("TABLESPACE_SCHEMAS");
    }

    private String[] getTablespaces() {
        return (String[])this._dataContext.get("SOURCE_TABLESPACES");
    }

    private boolean isSearchPanelUpdate() {
        if (this.isAddTableSpace() || this.isAddMultipleSchemas()) {
            return (Boolean)this._dataContext.get("EXTRACT_LIST_UPDATED");
        }
        return false;
    }
}

