/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListModel;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.controls.listtable.ListTableShuttlePanel;
import oracle.dbtools.raptor.extract.models.FilterListTableModel;
import oracle.dbtools.raptor.ui.panels.ByTypeSearchPanel;
import oracle.javatools.ui.ExtendedTextField;

public class SelectDataPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ByTypeSearchPanel searchPanel;
    private boolean _init = false;
    private DDLTypes _ddlTypes = null;
    private ListTableShuttlePanel<ExtractObject> _exportDataTablePanel;
    private FilterListTableModel _exportDataTableModel;
    private ExtractListModel _listModel = null;
    private List<ExtractObject> _EOList = null;
    private ExtendedTextField _globalPredicate;
    private JLabel _globalWhere = new JLabel(ExtractResources.getString((String)"EO_PRED_GLOBAL_WHERE"));
    private boolean isTablespaceEnabled = false;
    private boolean isSchemasEnabled = false;

    public void updatePanel() {
        if (!this._init) {
            this._init = true;
            this.searchPanel.init();
            this.addSearchResultsListener();
            this._init = true;
        }
    }

    public void updatePanel(boolean bl) {
        this._init = bl;
    }

    public void setDataObjects(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
        this.setDDLTypes(this._listModel.getDDLTypes());
        this._EOList = this._listModel.getList(0, new int[]{101});
        this.searchPanel.setConnectionName(this._listModel.getSourceConnName());
        this.updatePanel();
        this._exportDataTableModel.setRowList(this._EOList);
        this.searchPanel.setConnectionName(this._listModel.getSourceConnName());
    }

    public void onExit() {
        this._listModel.setSelectExtractData(this._exportDataTableModel.getRowList());
    }

    public void setDDLTypes(DDLTypes dDLTypes) {
        String[] stringArray2;
        this._ddlTypes = dDLTypes;
        Vector<String[]> vector = new Vector<String[]>();
        for (String[] stringArray2 : this._ddlTypes.getTypeListForData()) {
            vector.add(stringArray2);
        }
        String[] stringArray3 = new String[vector.size() + 1];
        stringArray2 = new String[vector.size()];
        int n = 0;
        stringArray3[0] = ExtractResources.getString((String)"EO_ALL_OBJS");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray3[n + 1] = string = (String)iterator.next();
            stringArray2[n++] = string;
        }
        this.searchPanel.setTypesForDisplay(stringArray3);
        this.searchPanel.setTypesForSearch(stringArray2);
    }

    public JPanel getPanel() {
        this.searchPanel = new ByTypeSearchPanel();
        this._exportDataTableModel = new FilterListTableModel(){

            @Override
            protected List<ExtractObject> add() {
                Object[] objectArray = SelectDataPanel.this.searchPanel.getResultsList().getSelectedValues();
                ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
                List list = this.getRowList();
                for (int i = 0; i < objectArray.length; ++i) {
                    URL uRL = (URL)objectArray[i];
                    ExtractObject extractObject = SelectDataPanel.this._listModel.getOrAddExtractObject(uRL);
                    if (!extractObject.isInList(list)) {
                        arrayList.add(extractObject);
                    }
                    SelectDataPanel.this.searchPanel.removeURL(uRL);
                }
                return arrayList;
            }

            @Override
            protected List<ExtractObject> addAll() {
                ListModel listModel = SelectDataPanel.this.searchPanel.getResultsList().getModel();
                ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
                List list = this.getRowList();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    URL uRL = (URL)listModel.getElementAt(i);
                    ExtractObject extractObject = SelectDataPanel.this._listModel.getOrAddExtractObject(uRL);
                    if (extractObject.isInList(list)) continue;
                    arrayList.add(extractObject);
                }
                SelectDataPanel.this.searchPanel.removeAllURL();
                return arrayList;
            }

            @Override
            protected void removeSelected() {
                DefaultListModel defaultListModel = (DefaultListModel)SelectDataPanel.this.searchPanel.getResultsList().getModel();
                JTable jTable = this.getTable();
                int[] nArray = jTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    URL uRL = (URL)jTable.getModel().getValueAt(nArray[i], 0);
                    defaultListModel.addElement(uRL);
                }
                super.removeSelected();
            }

            @Override
            protected void removeAll() {
                for (ExtractObject extractObject : this.getRowList()) {
                    SelectDataPanel.this.searchPanel.addURL(extractObject.getUrl());
                }
                super.removeAll();
            }
        };
        this._exportDataTablePanel = new ListTableShuttlePanel<ExtractObject>(this._exportDataTableModel, false);
        this._exportDataTablePanel.setEditable(true);
        this._globalPredicate = new ExtendedTextField();
        this._globalPredicate.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SelectDataPanel.this._listModel.setGlobalWhere(SelectDataPanel.this._globalPredicate.getText());
            }
        });
        JPanel jPanel = new JPanel();
        this._globalPredicate.setColumns(40);
        jPanel.setLayout(new BorderLayout(6, 0));
        jPanel.add((Component)this._globalWhere, "West");
        jPanel.add((Component)this._globalPredicate, "Center");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.searchPanel, new GridBagConstraints(0, 0, 1, 5, 1.0, 0.3, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._exportDataTablePanel, new GridBagConstraints(0, 5, 1, 5, 1.0, 0.3, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 0, 0, 0), 0, 0));
        return this;
    }

    private void addSearchResultsListener() {
        this.searchPanel.getResultsList().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = SelectDataPanel.this.searchPanel.getResultsList().getSelectedValues();
                    List list = SelectDataPanel.this._exportDataTableModel.getRowList();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        ExtractObject extractObject = SelectDataPanel.this._listModel.getOrAddExtractObject(uRL);
                        if (!extractObject.isInList(list)) {
                            list.add(extractObject);
                        }
                        SelectDataPanel.this.searchPanel.removeURL(uRL);
                    }
                    SelectDataPanel.this._exportDataTableModel.setRowList(list);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void setMultipleSchemaNames(String[] stringArray) {
        if (this.isAddMultipleSchemas()) {
            this.searchPanel.setAddMultipleSchemas(true);
            this.searchPanel.setMultipleSchemas(stringArray);
        }
    }

    public void setTablespaceNames(String[] stringArray) {
        if (this.isAddTableSpace()) {
            this.searchPanel.setAddTableSpace(true);
            this.searchPanel.setTableSpaceNames(stringArray);
        }
    }

    public void setAddTableSpace(boolean bl) {
        this.isTablespaceEnabled = bl;
    }

    public boolean isAddTableSpace() {
        return this.isTablespaceEnabled;
    }

    public void setAddMultipleSchemas(boolean bl) {
        this.isSchemasEnabled = bl;
    }

    public boolean isAddMultipleSchemas() {
        return this.isSchemasEnabled;
    }
}

