/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.wizard;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportServiceType;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ddl.TargetFormatHelper;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.export.service.ExportLauncherSD;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.extract.models.ExtractListModelHelper;
import oracle.dbtools.raptor.extract.ui.wizard.ExtractWizSummaryPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ExportWizSummaryPanel
extends ExtractWizSummaryPanel {
    private static final long serialVersionUID = 1L;
    private ExportAPI _expApi;
    ExtractListModel _listModel;
    TargetFormat _targetFormat;

    @Override
    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL");
        this._targetFormat = (TargetFormat)traversableContext.get("TARGETFORMAT");
        this.summary.removeAll();
        this.summary.setModel(this.getSummaryTreeModel(ExportWizArb.getString("EXPORT_SUMMARY")));
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            Object object;
            ExportParms exportParms = new ExportParms();
            exportParms.setListModel(this._listModel);
            exportParms.setSourceExtractObjectList(this._listModel.getList(0));
            exportParms.setTargetFormat(this._targetFormat);
            DDLFormat dDLFormat = this._listModel.getDDLFormat();
            exportParms.setDDLFormat(dDLFormat);
            ExtractDataFormat extractDataFormat = this._listModel.getDataFormat();
            exportParms.setDataFormat(extractDataFormat);
            exportParms.setServiceType(ExportServiceType.STANDARD);
            if (exportParms.getSourceExtractObjectList().size() == 1 && !(object = this._listModel.getFirstExtractObject()).isExtractMetaData() && object.getTable() != null) {
                exportParms.setServiceType(ExportServiceType.JTABLE);
            }
            object = new ExportLauncherSD();
            ((ExportLauncherSD)((Object)object)).run(exportParms);
        }
    }

    public DefaultTreeModel getSummaryTreeModel(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        ExtractListModelHelper extractListModelHelper = new ExtractListModelHelper(this._listModel);
        defaultMutableTreeNode.add(extractListModelHelper.getConnectionsNode());
        defaultMutableTreeNode.add(TargetFormatHelper.getSummaryNode(this._targetFormat));
        if (this._listModel.isDDLEnabled()) {
            defaultMutableTreeNode.add(extractListModelHelper.getDDLFormatNode());
            defaultMutableTreeNode.add(extractListModelHelper.getMetaNode());
        }
        if (this._listModel.isDataEnabled()) {
            defaultMutableTreeNode.add(extractListModelHelper.getDataFormatNode());
        }
        defaultMutableTreeNode.add(extractListModelHelper.getDataNode());
        return new DefaultTreeModel(defaultMutableTreeNode);
    }
}

