/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.editors;

import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class DBEditorController
implements Controller {
    private static DBEditorController s_instance;
    private Controller m_parent;

    public static synchronized DBEditorController getInstance() {
        if (s_instance == null) {
            s_instance = new DBEditorController((Controller)EditorManager.getEditorManager());
        }
        return s_instance;
    }

    private DBEditorController(Controller controller) {
        this.m_parent = controller;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (IDBEditor.CONN_CLOSED_CMD_ID == n) {
            IdeAction ideAction2 = IdeAction.get((int)48);
            bl = this.handleEvent(ideAction2, context);
        } else if (IDBEditor.PIN_CMD_ID == n) {
            View view = context.getView();
            Node node = context.getNode();
            if (view instanceof AsynchronousViewerEditor) {
                AsynchronousViewerEditor asynchronousViewerEditor = (AsynchronousViewerEditor)view;
                if (node instanceof ViewerNode && asynchronousViewerEditor.isPinEnabled()) {
                    ViewerNode viewerNode;
                    viewerNode.setPinned(!(viewerNode = (ViewerNode)node).getPinned());
                    asynchronousViewerEditor.checkPin();
                }
                View.updateToolbarActions((Toolbar)context.getView().getToolbar());
                return true;
            }
        }
        return bl || this.m_parent.handleEvent(ideAction, context);
    }

    public boolean update(IdeAction ideAction, Context context) {
        View view;
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (IDBEditor.PIN_CMD_ID == n && (view = context.getView()) instanceof AsynchronousViewerEditor) {
            AsynchronousViewerEditor asynchronousViewerEditor = (AsynchronousViewerEditor)view;
            ideAction.setEnabled(true);
            if (context.getNode() instanceof ViewerNode && asynchronousViewerEditor.isPinEnabled()) {
                asynchronousViewerEditor.checkPin();
            }
            return true;
        }
        return bl || this.m_parent.update(ideAction, context);
    }
}

