/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.net.URL;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.ora.ddlgen.OracleSourceDDLGenerator;

public class CreateBodyAction
extends AbstractMenuAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launch() {
        String string;
        Node node;
        URL uRL;
        DBObject dBObject = this.getDBObject();
        SchemaObject schemaObject = dBObject.getSchemaObject();
        String string2 = dBObject.getObjectName();
        URL uRL2 = CreateBodyAction.determineBodyURL(string2, uRL = (node = dBObject.getNode()).getURL());
        if (uRL2 != null && (string = OracleSourceDDLGenerator.defaultBodyForSpec((SourceObject)((SourceObject)schemaObject), (String)Service.addDoubleQuote((String)string2))) != null) {
            try {
                final Node node2 = NodeFactory.findOrCreate((URL)uRL2);
                if (node2 instanceof TextNode) {
                    node2.addNodeListener(new NodeListener(){

                        public void nodeSaved(NodeEvent nodeEvent) {
                            node2.removeNodeListener((NodeListener)this);
                            UpdateMessage.fireChildAdded((Subject)node, (Element)node2);
                        }

                        public void nodeClosed(NodeEvent nodeEvent) {
                            node2.removeNodeListener((NodeListener)this);
                        }
                    });
                    TextBuffer textBuffer = null;
                    try {
                        textBuffer = ((TextNode)node2).acquireTextBuffer();
                        textBuffer.beginEdit();
                        textBuffer.removeToEnd(0);
                        textBuffer.append(string.toCharArray());
                    }
                    finally {
                        if (textBuffer != null) {
                            textBuffer.endEdit();
                            ((TextNode)node2).releaseTextBuffer();
                        }
                    }
                }
                if (node2 != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)node2);
                            ((PlSqlNode)node).setProperty("HAS_BODY", "TRUE");
                        }
                    });
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    public static URL determineBodyURL(String string, URL uRL) {
        String string2;
        URL uRL2 = null;
        String string3 = DBURLFormatHelper.getBaseType(uRL);
        String string4 = "PACKAGE".equals(string3) ? "PACKAGE BODY" : (string2 = "TYPE".equals(string3) ? "TYPE BODY" : null);
        if (string2 != null) {
            URL uRL3 = DBURLFormatHelper.getEnclosedTypeURL(uRL, string2);
            uRL2 = DBURLFormatHelper.getURL(uRL3, string);
        }
        return uRL2;
    }

    @Override
    public boolean isEnabled(Context context) {
        Node node;
        boolean bl = false;
        DBObject dBObject = (DBObject)((Object)context.getProperty("ObjectAction.DBOBJECT"));
        if (dBObject != null && (node = dBObject.getNode()) instanceof PlSqlNode) {
            bl = !((PlSqlNode)node).hasBody();
        }
        return bl;
    }
}

