/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbtools.raptor.ContextMenuFilter;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.ChildFolder;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.utils.ContextMenuHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.MenuFilter;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.performance.PerformanceLogger;

public class BasicObjectModifier
implements ContextMenuListener {
    private static final Logger LOGGER = Logger.getLogger(BasicObjectModifier.class.getName());
    private static XMLBasedObjectAction s_xmlActions;
    private static final Set<Class<? extends Element>> s_supportedTypes;

    public static void registerSupportedType(Class<? extends Element> clazz) {
        s_supportedTypes.add(clazz);
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (!ContextMenuHelper.checkContextSelection(context, s_supportedTypes.toArray(new Class[0]))) {
            return;
        }
        this.initMenus();
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".menuWillShow");
        Element[] elementArray = context.getSelection();
        Node node = context.getNode();
        boolean bl = elementArray.length > 1;
        DBObject dBObject = (DBObject)((Object)context.getProperty("ObjectAction.DBOBJECT"));
        if (node == null && elementArray.length > 0) {
            node = elementArray[0];
        }
        if (node != null) {
            dBObject = new DBObject((Element<?, ?>)node);
        }
        if (dBObject != null) {
            context.setProperty("ObjectAction.CONN_NAME", (Object)dBObject.getConnectionName());
            context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
            if (dBObject.getObjectType() != null && dBObject.getObjectType().equals("RECYCLEBIN")) {
                contextMenu.removeAll();
            }
            LOGGER.info(Messages.getString((String)"BasicObjectModifier.2") + dBObject.getKey() + ":" + dBObject.getObjectName() + "\n");
            XMLBasedObjectAction.getInstance().addToMenu(contextMenu, dBObject, bl);
            PerformanceLogger.get().stopTiming(this.getClass().getName() + ".menuWillShow", Messages.getString((String)"BasicObjectModifier.6"));
            contextMenu.addMenuFilter((MenuFilter)ContextMenuFilter.getInstance());
            LOGGER.info(context.toString());
            contextMenu.sortContainer(contextMenu.getGUI(true));
        }
    }

    private void initMenus() {
        try {
            if (s_xmlActions == null) {
                s_xmlActions = XMLBasedObjectAction.getInstance();
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
        contextMenu.removeMenuFilter((MenuFilter)ContextMenuFilter.getInstance());
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    static {
        s_supportedTypes = new HashSet<Class<? extends Element>>();
        s_supportedTypes.add(ObjectFolder.class);
        s_supportedTypes.add(DatabaseNode.class);
        s_supportedTypes.add(OtherSchemasFolder.class);
        s_supportedTypes.add(DatabaseConnection.class);
        s_supportedTypes.add(SchemaFolder.class);
        s_supportedTypes.add(ChildObjectElement.class);
        s_supportedTypes.add(CatalogFolder.class);
        s_supportedTypes.add(CategoryFolder.class);
        s_supportedTypes.add(ChildFolder.class);
    }
}

