/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.editor.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.dbdiff.editor.tree.CheckTreeCellRenderer;
import oracle.dbtools.raptor.dbdiff.editor.tree.CheckTreeSelectionModel;

public class CheckTreeManager
extends MouseAdapter
implements TreeSelectionListener {
    private CheckTreeSelectionModel selectionModel;
    private JTree tree = new JTree();
    int hotspot;

    public CheckTreeManager(JTree jTree) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.tree = jTree;
        this.selectionModel = new CheckTreeSelectionModel(jTree.getModel());
        jTree.setCellRenderer(new CheckTreeCellRenderer(jTree.getCellRenderer(), this.selectionModel));
        jTree.addMouseListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    private static void addChildPaths(TreePath treePath, TreeModel treeModel, List<TreePath> list) {
        Object object = treePath.getLastPathComponent();
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            list.add(treePath.pathByAddingChild(treeModel.getChild(object, i)));
        }
    }

    private static ArrayList<TreePath> getDescendants(TreePath[] treePathArray, TreeModel treeModel) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        Stack<TreePath> stack = new Stack<TreePath>();
        stack.addAll(Arrays.asList(treePathArray));
        while (!stack.isEmpty()) {
            TreePath treePath = (TreePath)stack.pop();
            CheckTreeManager.addChildPaths(treePath, treeModel, stack);
            arrayList.add(treePath);
        }
        return arrayList;
    }

    public static ArrayList<TreePath> getAllCheckedPaths(CheckTreeManager checkTreeManager, JTree jTree) {
        return CheckTreeManager.getDescendants(checkTreeManager.getSelectionModel().getSelectionPaths(), jTree.getModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        if (mouseEvent.getX() > this.tree.getPathBounds((TreePath)treePath).x + this.hotspot) {
            return;
        }
        boolean bl = this.selectionModel.isPathSelected(treePath, true);
        this.selectionModel.removeTreeSelectionListener(this);
        try {
            if (bl) {
                this.selectionModel.removeSelectionPath(treePath);
            } else {
                this.selectionModel.addSelectionPath(treePath);
            }
        }
        finally {
            this.selectionModel.addTreeSelectionListener(this);
            this.tree.treeDidChange();
        }
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.tree.treeDidChange();
    }
}

