/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

class FocusLogger
extends FocusAdapter {
    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.log(focusEvent);
        super.focusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.log(focusEvent);
        super.focusLost(focusEvent);
    }

    public void watch(JComponent jComponent) {
        this.ignore(jComponent);
        jComponent.addFocusListener(this);
    }

    public void ignore(JComponent jComponent) {
        jComponent.removeFocusListener(this);
    }

    public void watchAll(JComponent jComponent) {
        this.watch(jComponent);
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.watchAll((JComponent)component);
        }
    }

    public void ignoreAll(JComponent jComponent) {
        this.ignore(jComponent);
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.ignoreAll((JComponent)component);
        }
    }

    private void log(FocusEvent focusEvent) {
        Logger.getLogger(this.getClass().getName()).log(Level.FINER, focusEvent.toString());
    }
}

