/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.datatypes.ui.cell.CellRendererHelper;

public class ChoicesCellRenderer
extends JComboBox
implements TableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;
    private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public ChoicesCellRenderer() {
        this.setOpaque(true);
        this.setBorder(this.noFocusBorder);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            Thread.dumpStack();
            return null;
        }
        this.removeAllItems();
        this.addItem(object);
        this.setSelectedItem(object);
        JComponent jComponent = this;
        if (CellRendererHelper.isReadOnly(jTable, n)) {
            jComponent = CellRendererHelper.getTextField(object.toString());
        }
        CellRendererHelper.setupLook(jComponent, jTable, bl, bl2, null, this.unselectedForeground, this.unselectedBackground);
        if (!bl2) {
            jComponent.setBorder(null);
        }
        return jComponent;
    }
}

