/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.ide.util.ResourceUtils;

public class CopyDdlOptionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int PREFERENCES = 0;
    public static int WIZARD = 1;
    private JPanel m_ddlCopyPanel = new JPanel();
    private JLabel m_labelDDL;
    private JCheckBox m_chkbxCopyDDL = new JCheckBox();
    private JRadioButton m_jRdoNotReplaceDest = new JRadioButton();
    private JRadioButton m_jRdoReplaceDest = new JRadioButton();
    private JCheckBox m_jChkbxIgnoreStorage = new JCheckBox();
    private ItemListener m_ddlCopyListener;
    private boolean m_ddlCopyListenerAdded = false;
    private boolean m_showDDLCheckBox = true;
    private boolean m_showIgnoreStorage = true;
    private int m_usage;

    public CopyDdlOptionPanel() {
        this(WIZARD);
    }

    public CopyDdlOptionPanel(int n) {
        this.m_usage = n;
    }

    public JCheckBox getCopyDDLComponent() {
        return this.m_chkbxCopyDDL;
    }

    public void showDDLCheckBox(boolean bl) {
        this.m_showDDLCheckBox = bl;
    }

    public boolean showDDLCheckBox() {
        return this.m_showDDLCheckBox;
    }

    public void showIgnoreStorage(boolean bl) {
        this.m_showIgnoreStorage = bl;
    }

    public boolean showIgnoreStorage() {
        return this.m_showIgnoreStorage;
    }

    public void allowDisable(boolean bl) {
        this.m_chkbxCopyDDL.setSelected(!bl);
        this.m_chkbxCopyDDL.setEnabled(bl);
        if (bl) {
            this.addDdlCopyListener();
        } else {
            this.removeDdlCopyListener();
        }
    }

    public JPanel getPanel() {
        this.m_ddlCopyPanel = new JPanel(new GridBagLayout());
        String string = this.m_usage == WIZARD ? this.getStringDDLOption() : this.getStringDDLOptionPref();
        ResourceUtils.resButton((AbstractButton)this.m_chkbxCopyDDL, (String)string);
        ResourceUtils.resButton((AbstractButton)this.m_jRdoNotReplaceDest, (String)this.getStringDoNotReplace());
        ResourceUtils.resButton((AbstractButton)this.m_jRdoReplaceDest, (String)this.getStringDoReplace());
        ResourceUtils.resButton((AbstractButton)this.m_jChkbxIgnoreStorage, (String)this.getStringIgnoreStorage());
        this.addDdlCopyListener();
        if (this.m_showDDLCheckBox) {
            this.m_chkbxCopyDDL.setText(StringUtils.stripMnemonic((String)(this.m_usage == WIZARD ? this.getStringDDLOption() : this.getStringDDLOptionPref())));
        } else {
            this.m_labelDDL = new JLabel(StringUtils.stripMnemonic((String)(this.m_usage == WIZARD ? this.getStringDDLOption() : this.getStringDDLOptionPref())));
        }
        this.setDoNotReplace(this.m_jRdoNotReplaceDest);
        this.m_jRdoNotReplaceDest.setSelected(true);
        this.setDoReplace(this.m_jRdoReplaceDest);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_jRdoNotReplaceDest);
        buttonGroup.add(this.m_jRdoReplaceDest);
        this.setIgnoreStorage(this.m_jChkbxIgnoreStorage);
        this.m_jChkbxIgnoreStorage.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.m_jRdoNotReplaceDest, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        jPanel.add((Component)this.m_jRdoReplaceDest, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        if (this.m_showIgnoreStorage) {
            jPanel.add((Component)this.m_jChkbxIgnoreStorage, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        }
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 6, 8, 8));
        TitledPane titledPane = new TitledPane((Component)(this.m_showDDLCheckBox ? this.m_chkbxCopyDDL : this.m_labelDDL), (Component)jPanel3);
        this.m_ddlCopyPanel.setLayout(new BorderLayout());
        this.m_ddlCopyPanel.add((Component)titledPane, "Center");
        this.m_chkbxCopyDDL.setSelected(true);
        return this.m_ddlCopyPanel;
    }

    public boolean getChkbxCopyDDL() {
        return this.m_chkbxCopyDDL.isSelected();
    }

    public void setChkbxCopyDDL(boolean bl) {
        this.m_chkbxCopyDDL.setSelected(bl);
    }

    public boolean getDoNotReplaceDest() {
        return this.m_jRdoNotReplaceDest.isSelected();
    }

    public boolean getDoReplaceDest() {
        return this.m_jRdoReplaceDest.isSelected();
    }

    public boolean getIgnoreStorage() {
        return this.m_jChkbxIgnoreStorage.isSelected();
    }

    public void setDoNotReplaceDest(boolean bl) {
        this.m_jRdoNotReplaceDest.setSelected(bl);
    }

    public void setDoReplaceDest(boolean bl) {
        this.m_jRdoReplaceDest.setSelected(bl);
    }

    public void setIgnoreStorage(boolean bl) {
        this.m_jChkbxIgnoreStorage.setSelected(bl);
    }

    public void setDefault() {
        this.m_chkbxCopyDDL.setSelected(true);
        this.m_jRdoNotReplaceDest.setSelected(true);
        this.m_jRdoReplaceDest.setSelected(false);
        this.m_jChkbxIgnoreStorage.setSelected(true);
    }

    public void removeDdlCopyListener() {
        if (this.m_ddlCopyListenerAdded) {
            this.m_chkbxCopyDDL.removeItemListener(this.m_ddlCopyListener);
        }
        this.m_ddlCopyListenerAdded = false;
    }

    void addDdlCopyListener() {
        if (!this.m_ddlCopyListenerAdded) {
            this.m_ddlCopyListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    CopyDdlOptionPanel.this.enableOptions(CopyDdlOptionPanel.this.m_chkbxCopyDDL.isSelected());
                }
            };
            this.m_chkbxCopyDDL.addItemListener(this.m_ddlCopyListener);
            this.m_ddlCopyListenerAdded = true;
        }
    }

    public void enableOptions(boolean bl) {
        this.m_chkbxCopyDDL.setSelected(bl);
        this.m_jRdoNotReplaceDest.setEnabled(bl);
        this.m_jRdoReplaceDest.setEnabled(bl);
        this.m_jChkbxIgnoreStorage.setEnabled(bl);
        if (this.m_labelDDL != null) {
            this.m_labelDDL.setEnabled(bl);
        }
    }

    protected String getStringDDLOption() {
        return CopyWizArb.getString("COPY_DDL_OPTION");
    }

    protected String getStringDDLOptionPref() {
        return CopyWizArb.getString("COPY_DDL_OPTION_PREF");
    }

    protected String getStringDoNotReplace() {
        return CopyWizArb.getString("DO_NOT_REPLACE_DEST");
    }

    protected String getStringDoReplace() {
        return CopyWizArb.getString("DO_REPLACE_DEST");
    }

    protected String getStringIgnoreStorage() {
        return CopyWizArb.getString("IGNORE_STORAGE");
    }

    protected void setDoNotReplace(JRadioButton jRadioButton) {
        ResourceUtils.resButton((AbstractButton)jRadioButton, (String)CopyWizArb.getString("DO_NOT_REPLACE_DEST"));
        jRadioButton.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("DO_NOT_REPLACE_DEST")));
        jRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("DO_NOT_REPLACE_DEST")));
    }

    protected void setDoReplace(JRadioButton jRadioButton) {
        ResourceUtils.resButton((AbstractButton)jRadioButton, (String)CopyWizArb.getString("DO_REPLACE_DEST"));
        jRadioButton.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("DO_REPLACE_DEST")));
        jRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("DO_REPLACE_DEST")));
    }

    protected void setIgnoreStorage(JCheckBox jCheckBox) {
        ResourceUtils.resButton((AbstractButton)jCheckBox, (String)CopyWizArb.getString("IGNORE_STORAGE"));
        jCheckBox.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("IGNORE_STORAGE")));
        jCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("IGNORE_STORAGE")));
    }
}

