/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy;

import java.util.HashMap;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.raptor.databasecopy.CopyAPI;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;

public class SchemasCopy
extends CopyAPI {
    public SchemasCopy(HashMap<String, Boolean> hashMap) {
        super(hashMap);
    }

    @Override
    public void setDDLFormat() {
        boolean bl;
        DDLFormat dDLFormat = new DDLFormat();
        dDLFormat.setPretty(false);
        if (this.isMaintainSchemas()) {
            dDLFormat.setSchema(true);
        }
        if (this.isConsolidateSchemas()) {
            dDLFormat.setSchema(false);
        }
        dDLFormat.setConstraint(true);
        dDLFormat.setRefConstraint(true);
        dDLFormat.setCascade(true);
        dDLFormat.setDrop(true);
        dDLFormat.setAlter(false);
        dDLFormat.isExtractEnabled(this.isCopyDDL());
        if (this.getDestinationConn() != null) {
            this.setDestVersion(RaptorVersionTracker.getDbVersion(this.getDestinationConn()));
        }
        boolean bl2 = bl = !this.compareSourceAndDesintationVersions(this.m_sourceConn, this.getDestinationConn());
        if (bl) {
            dDLFormat.setVersion(this.getDestVersion().toString());
            dDLFormat.setSegments(false);
            dDLFormat.setPartitioning(false);
            dDLFormat.setTablespace(false);
        } else {
            dDLFormat.setSegments(!this.isIgnoreStorage());
            dDLFormat.setPartitioning(!this.isIgnoreStorage());
            dDLFormat.setTablespace(!this.isIgnoreStorage());
        }
        this.getExtractListModel().setDDLFormat(dDLFormat);
    }

    @Override
    public void databaseCopyData() {
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(7, 104, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(5, 104, this.getDestinationConn());
        }
        this.getExtractListAndCopyData(8, this.getSourceConn(), this.getDestinationConn(), this.isMaintainSchemas() ? 1 : 2);
        this.getExtractListAndExecuteDDL(3, 0, this.getDestinationConn());
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(6, 104, this.getDestinationConn());
        }
    }
}

