/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy;

import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.extract.models.ExtractScript;
import oracle.dbtools.raptor.databasecopy.CopyAPI;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.databasecopy.DatabaseCopyException;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.dialogs.databasecopy.DatabaseCopyArb;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.MnemonicUtil;
import oracle.javatools.db.DBException;

public class DbCartCopy
extends CopyAPI {
    private List<ExtractObject> m_EOList;
    private String _cartName;

    public void setCartName(String string) {
        this._cartName = string;
    }

    public void setDbCartCopy() {
        this.setExtractListModel();
        this.setDbCartCopy(this.m_listModel);
    }

    public void setDbCartCopy(ExtractListModel extractListModel) {
        Object object;
        this.openLog();
        this.initELogger();
        this.eLog(CopyPanelArb.getString("OPTION") + " " + CopyPanelArb.getString("CART_COPY"));
        this.m_listModel = extractListModel;
        this.setDDLFormat();
        this.setDataFormat();
        DDLTypes dDLTypes = this.m_listModel.getDDLTypes();
        List list = this.m_listModel.getList(0, new int[]{107});
        dDLTypes.setTypes(list);
        dDLTypes.setShowConstraint(true);
        dDLTypes.setShowRefConstraint(true);
        this.m_listModel.setDDLTypes(dDLTypes);
        String string = CopyPanelArb.getString("SOURCE_CART") + " " + this._cartName;
        this.log(string);
        this.eLog(string);
        this.log(CopyPanelArb.getString("CART_OBJS"));
        for (ExtractObject extractObject : this.getExtractObjectList()) {
            BasicDBObject basicDBObject = extractObject.getDBObject();
            if (extractObject.isTypeDBO()) {
                this.log(basicDBObject != null && basicDBObject.getObjectName() != null && !basicDBObject.getObjectName().isEmpty() ? Connections.getDisplayName(basicDBObject.getConnectionName()) + "." + basicDBObject.getSchemaName() + "." + basicDBObject.getObjectType() + "." + basicDBObject.getObjectName() : Connections.getDisplayName(basicDBObject.getConnectionName()) + "." + basicDBObject.getSchemaName() + "." + basicDBObject.getObjectFolderType() + " " + CopyPanelArb.getString("FOLDER"));
            } else {
                this.log(extractObject.getUrl().toString());
            }
            this.m_listModel.setSourceConnName(extractObject.getSourceConnName());
            this.m_listModel.setDestConnName(this.getTargetConnection());
            extractObject.setListModel(this.m_listModel);
        }
        if (this.getDestinationSchemaName() == null) {
            string = CopyPanelArb.getString("DEST") + " " + Connections.getDisplayName(this.getTargetConnection());
            this.log(string);
            this.eLog(string);
        } else {
            string = CopyPanelArb.getString("DEST") + " " + Connections.getDisplayName(this.getTargetConnection()) + "." + this.getDestinationSchemaName();
            this.log(string);
            this.eLog(string);
        }
        this.log(MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString("COPY_DDL_OPTION")) + ": " + (this.isCopyDDL() ? CopyPanelArb.getString("YES") : CopyPanelArb.getString("NO")));
        if (this.isCopyDDL()) {
            this.log((String)(this.isReplaceDest() ? CopyPanelArb.getString("REPLACE") : CopyPanelArb.getString("DO_NOT_REPLACE") + " " + CopyPanelArb.getString("EXISTING_OBJECTS")));
        }
        this.log(MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString("COPY_DATA_OPTION")) + ": " + (this.isCopyData() ? CopyPanelArb.getString("YES") : CopyPanelArb.getString("NO")));
        if (this.isCopyData() && !this.isReplaceDest()) {
            object = CopyPanelArb.getString("SKIP_DATA");
            if (this.isAppendDest()) {
                object = CopyPanelArb.getString("APPEND");
            }
            if (this.isTruncateData()) {
                object = CopyPanelArb.getString("TRUNCATE");
            }
            this.log((String)object + " " + CopyPanelArb.getString("EXISTING_OBJECTS"));
        }
        object = this.m_listModel.getDataFormat();
        object.isTruncate(this.isTruncateData());
        this.m_listModel.setDataFormat(object);
        this.isReconcileTypesAndObjects(false);
        this.startDatabaseCopyWithDialog();
    }

    public void setDbCartCopyHeadless() {
        this.setExtractListModel();
        this.setDDLFormat();
        this.setDataFormat();
        DDLTypes dDLTypes = this.m_listModel.getDDLTypes();
        List list = this.m_listModel.getList(0, new int[]{107});
        dDLTypes.setTypes(list);
        dDLTypes.setShowConstraint(true);
        dDLTypes.setShowRefConstraint(true);
        this.m_listModel.setDDLTypes(dDLTypes);
        for (ExtractObject extractObject : this.getExtractObjectList()) {
            this.m_listModel.setSourceConnName(extractObject.getSourceConnName());
            this.m_listModel.setDestConnName(this.getTargetConnection());
            extractObject.setListModel(this.m_listModel);
        }
        ExtractDataFormat extractDataFormat = this.m_listModel.getDataFormat();
        extractDataFormat.isTruncate(this.isTruncateData());
        this.m_listModel.setDataFormat(extractDataFormat);
        this.startDatabaseCopy();
    }

    public void setExtractListModel() {
        this.m_listModel = new ExtractListModel();
        this.m_listModel.setSelectedExtractObjects(this.getExtractObjectList());
        this.m_listModel.setSchemas();
        try {
            this.setDestinationConn(Connections.getInstance().getConnection(this.getTargetConnection()));
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
    }

    @Override
    protected void setDDLFormat() {
        DDLFormat dDLFormat = new DDLFormat();
        dDLFormat.setPretty(false);
        dDLFormat.setSchema(false);
        dDLFormat.setConstraint(true);
        dDLFormat.setRefConstraint(true);
        dDLFormat.setCascade(true);
        dDLFormat.setDrop(true);
        dDLFormat.setAlter(false);
        dDLFormat.setSegments(false);
        dDLFormat.setPartitioning(false);
        dDLFormat.setTablespace(false);
        dDLFormat.isExtractEnabled(this.isCopyDDL());
        this.m_listModel.setDDLFormat(dDLFormat);
    }

    public void setTargetConnection(String string) {
        this.m_destinationConnName = string;
    }

    public String getTargetConnection() {
        return this.m_destinationConnName;
    }

    public List<ExtractObject> getExtractObjectList() {
        return this.m_EOList;
    }

    public void setExtractObjectList(List<ExtractObject> list) {
        this.m_EOList = list;
    }

    @Override
    public void databaseCopyData() {
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(7, 104, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(5, 104, this.getDestinationConn());
        }
        this.getExtractListAndCopyData(8, this.getDestinationConn());
        this.getExtractListAndExecuteDDL(3, 0, this.getDestinationConn());
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(6, 104, this.getDestinationConn());
        }
    }

    @Override
    protected void getExtractListAndExecuteDDL(int n, int n2, Connection connection) {
        List list = null;
        list = n2 == 0 ? this.m_listModel.getList(n) : this.m_listModel.getList(n, new int[]{n2});
        boolean bl = false;
        try {
            for (ExtractObject extractObject : list) {
                if (!bl) {
                    this.lineStart();
                    bl = true;
                }
                this.checkCancelled();
                this.setProg(DatabaseCopyArb.getString("CREATING_OBJ") + " " + extractObject.getDBObject().getObjectName());
                try {
                    String string;
                    boolean bl2;
                    if (n == 2) {
                        this.getExecutionScript(extractObject, 110);
                    }
                    boolean bl3 = bl2 = (string = extractObject.getDDL(n, ExtractObject.COPY_DDL)) != null && string.endsWith("set define off;");
                    if (!bl2) {
                        this.executeSql(extractObject.getDDL(n, ExtractObject.COPY_DDL), connection);
                    }
                    if (n != 2) continue;
                    this.getExecutionScript(extractObject, 111);
                }
                catch (Exception exception) {
                    if (this.m_ignoreAllErrors) continue;
                    DatabaseCopyException databaseCopyException = new DatabaseCopyException();
                    int n3 = 0;
                    try {
                        n3 = databaseCopyException.askContinueOnError(CopyPanelArb.getString("DBCOPY_PROGRESS_CONTINUE"));
                        if (n3 == 2) {
                            this.cancel();
                            continue;
                        }
                        this.m_ignoreAllErrors = true;
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (bl) {
            this.lineEnd();
        }
    }

    private void getExtractListAndCopyData(int n, Connection connection) {
        List list = this.m_listModel.getList(n, new int[]{103});
        String string = null;
        try {
            for (ExtractObject extractObject : list) {
                BasicDBObject basicDBObject = extractObject.getDBObject();
                if (extractObject.isExistsDest() || this.isCopyDDL()) {
                    if (!extractObject.isSelectedData()) continue;
                    this.checkCancelled();
                    string = extractObject.getFinalWhere();
                    DataMover dataMover = new DataMover(Connections.getInstance().getConnection(extractObject.getSourceConnName()), connection);
                    dataMover.setLogFile(this.m_out);
                    this.setProg(DatabaseCopyArb.getString("MOVING_DATA") + " " + basicDBObject.getObjectName());
                    this.lineStart();
                    this.log(CopyPanelArb.getString("MOVING_DATA_MESSAGE") + basicDBObject.getObjectName());
                    if (n == 8) {
                        this.getExecutionScript(extractObject, 112);
                    }
                    if (!dataMover.move(basicDBObject, string, 0, true)) {
                        this.cancel();
                        this.checkCancelled();
                        break;
                    }
                    if (n == 8) {
                        this.getExecutionScript(extractObject, 113);
                    }
                    this.lineEnd();
                    continue;
                }
                this.log(DatabaseCopyArb.format("OBJECT_NOT_EXISTS", basicDBObject.getObjectName()));
                this.eLog(DatabaseCopyArb.format("OBJECT_NOT_EXISTS", basicDBObject.getObjectName()));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void getExecutionScript(ExtractObject extractObject, int n) {
        ExtractScript extractScript = extractObject.getScript(n);
        if (extractScript != null) {
            try {
                String string = extractObject.getType() == 0 ? extractObject.getDBObject().getObjectName() : (n == 114 ? "INITIAL" : "FINAL");
                this.executeSqlScript(extractScript.getUrl());
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSqlScript(URL uRL) {
        ScriptExecutor scriptExecutor = new ScriptExecutor(uRL, this.getDestinationConn());
        try {
            this.log(this.getTerm() + MessageFormat.format(CopyPanelArb.getString("SQLEXECUTION_STARTED"), uRL.getFile()));
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.setSqlError(4);
            ScriptExecutor.enableDbmsOutput((Connection)this.getDestinationConn(), (int)20000);
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            scriptExecutor.run();
            this.log(this.getTerm() + CopyPanelArb.getString("SQLEXECUTION_SUCCESSFULL"));
        }
        catch (Exception exception) {
            try {
                this.log(this.getTerm() + CopyPanelArb.getString("SQLEXECUTION_FAILED"));
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            catch (Throwable throwable) {
                this.log(this.getTerm() + MessageFormat.format(CopyPanelArb.getString("SQLEXECUTION_ENDEDED"), uRL.getFile()) + this.getTerm());
                throw throwable;
            }
            this.log(this.getTerm() + MessageFormat.format(CopyPanelArb.getString("SQLEXECUTION_ENDEDED"), uRL.getFile()) + this.getTerm());
        }
        this.log(this.getTerm() + MessageFormat.format(CopyPanelArb.getString("SQLEXECUTION_ENDEDED"), uRL.getFile()) + this.getTerm());
    }
}

