/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.ImportGenHelper;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dbtools.util.Logger;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import org.stringtemplate.v4.ST;

public class ImportGenSqlLoader
extends ImportGen {
    public static final String NAME = ImportDataFormat.METHOD_SQLLDR_NAME;
    public static final int TYPE = 4;
    private ImportProperties _iProps;
    private ImportGenModel _iGenModel;
    private boolean _isValid = false;
    private LoadFile _loadFile;
    private String _outStub;
    private String _outWithPath;
    private String _pathStringSh;
    private String _pathStringBat;
    private String _pathStringCtl;

    public String getName() {
        return NAME;
    }

    public Integer getType() {
        return 4;
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel) {
        return this.start(importProperties, importGenModel, false);
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel, boolean bl) {
        if (importProperties == null || importGenModel == null) {
            return false;
        }
        this._iProps = importProperties;
        this._iGenModel = importGenModel;
        if (!this._iProps.getValueBoolean(ImportKeys.IS_BATCH).booleanValue()) {
            this._iGenModel.initELogger();
            this._iGenModel.eLogImportMessages();
        }
        super.start(importProperties, importGenModel, bl);
        if (!this._iGenModel.isExitCodeSuccess()) {
            return false;
        }
        return this.validate();
    }

    public boolean validate() {
        CharSequence charSequence;
        this._iGenModel.setExitCode(ExitCode.EXIT_SUCCESS);
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        String string = this._loadFile.getName();
        String string2 = this._loadFile.getCanonicalName();
        this._outStub = string2.substring(string2.lastIndexOf(File.separator) + 1, string2.lastIndexOf("."));
        boolean bl = this._iProps.getValueBoolean(ImportKeys.USEGENDIR);
        this._outWithPath = string2.substring(0, string2.lastIndexOf(File.separator));
        if (bl) {
            charSequence = (String)this._iProps.get(ImportKeys.GENDIR);
            if (this._outWithPath.endsWith(File.separator)) {
                this._outWithPath = ((String)charSequence).substring(0, this._outWithPath.length() - 2);
            }
            this._outWithPath = charSequence;
        }
        this._pathStringSh = this._outWithPath + File.separator + this._outStub + ".sh";
        this._pathStringBat = this._outWithPath + File.separator + this._outStub + ".bat";
        this._pathStringCtl = this._outWithPath + File.separator + this._outStub + ".ctl";
        charSequence = new StringBuffer();
        if (!this._iGenModel.isFileWritable(this._pathStringSh)) {
            ((StringBuffer)charSequence).append(DataImportArb.format("NEW_FILE_ERROR", this._pathStringSh));
        }
        if (!this._iGenModel.isFileWritable(this._pathStringBat)) {
            ((StringBuffer)charSequence).append(DataImportArb.format("NEW_FILE_ERROR", this._pathStringBat));
        }
        if (!this._iGenModel.isFileWritable(this._pathStringCtl)) {
            ((StringBuffer)charSequence).append(DataImportArb.format("NEW_FILE_ERROR", this._pathStringCtl));
        }
        if (((StringBuffer)charSequence).length() > 0) {
            this._iGenModel.setExitCode(ExitCode.EXIT_SEVERE);
            this._iGenModel.getExitCode().setMessage(((StringBuffer)charSequence).toString());
        } else {
            this._isValid = true;
        }
        return this._iGenModel.isExitCodeSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process() {
        if (!this._isValid) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET DEFINE OFF\n");
        if (!this._iGenModel.isExistingTable()) {
            stringBuffer.append(this._iGenModel.getCreateTableStatementWithComments());
        }
        this.doLoaderFiles();
        stringBuffer.append(DataImportArb.format("GEN_FILES_LOCATION", this._outWithPath));
        String string = stringBuffer.toString();
        string.replaceAll("\r", "");
        this._iGenModel.streamPrintln(string);
        if (!this._iGenModel.isBatch() && this._iProps.getValueBoolean(ImportKeys.SEND_TO_WORKSHEET).booleanValue()) {
            Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.77"));
        } else {
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            try {
                Closeable closeable = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream((PipedInputStream)closeable);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
                MessagePage messagePage = (MessagePage)LogManager.getLogManager().getMsgPage();
                if (messagePage == null) {
                    messagePage = new MessagePage();
                    LogManager.getLogManager().addPage((LogPage)messagePage);
                }
                OutputRedirector outputRedirector = new OutputRedirector((PipedInputStream)closeable, (LogPage)messagePage);
                Logger.info(this.getClass(), (String)(Messages.getString("ImportGenerator.78") + this._iGenModel.getTableName() + Messages.getString("ImportGenerator.79") + this._iGenModel.getConnName()));
                ScriptExecutor scriptExecutor = new ScriptExecutor(stringBuffer.toString(), this._iGenModel.getConn());
                scriptRunnerContext.setErrWriter(new PrintWriter(this._iGenModel.getStream().getBadStreamWriter()));
                scriptRunnerContext.setOutputStreamWrapper(bufferedOutputStream);
                scriptRunnerContext.setEscape(false);
                scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                scriptExecutor.setOut(bufferedOutputStream);
                Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.84"));
                scriptExecutor.run();
                outputRedirector.start();
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
            finally {
                PrintWriter printWriter = scriptRunnerContext.getErrWriter();
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                if (!this._iGenModel.isBatch() && this._iGenModel.getStream().isBadFileUsed()) {
                    try {
                        this._iGenModel.eLogHref(this._iGenModel.getStream().geturlBad());
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (Throwable)exception);
                        this._iGenModel.eLogException((Throwable)exception);
                    }
                } else {
                    this._iGenModel.getStream().deleteEmptyBadFile();
                }
                this._iGenModel.isTableCreated(true);
            }
        }
        try {
            this._iGenModel.eLogHref(new File((String)this._iProps.get(ImportKeys.GENDIR)).toURI().toURL());
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
            this._iGenModel.eLogException((Throwable)exception);
        }
        return this._iGenModel.isExitCodeSuccess();
    }

    private void doLoaderFiles() {
        Object object;
        Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.13"));
        ST sT = this._iGenModel.getTemplateGroup().getInstanceOf("CreateSqlldrStatement");
        sT.add("fileName", (Object)this._outStub);
        String string = (String)this._iProps.get(ImportKeys.LOGDIRNAME);
        Object object2 = "";
        if (string != null && string.length() > 0) {
            object2 = "LOG=" + string + File.separator + this._outStub + ".log";
        }
        sT.add("logClause", object2);
        String string2 = (String)this._iProps.get(ImportKeys.BADDIRNAME);
        Object object3 = "";
        if (string2 != null && string2.length() > 0) {
            object3 = "BAD=" + string2 + File.separator + this._outStub + ".bad";
        }
        sT.add("badClause", object3);
        Integer n = this._iGenModel.getDataFormat().isHeader() ? this._iGenModel.getDataFormat().getSkipRows() + 1 : this._iGenModel.getDataFormat().getSkipRows();
        sT.add("rowsToSkip", (Object)n.toString());
        n = (Integer)this._iProps.get(ImportKeys.LOAD_LIMIT);
        if (n > 0) {
            object = "LOAD=" + n;
            sT.add("loadLimitClause", object);
        }
        object = sT.render();
        File file = new File(this._pathStringSh);
        Object object4 = object;
        this._iGenModel.writeOutFile(file, this._iGenModel.nix((String)object4));
        File file2 = new File(this._pathStringBat);
        object4 = object;
        this._iGenModel.writeOutFile(file2, this._iGenModel.dos((String)object4));
        sT = this._iGenModel.getTemplateGroup().getInstanceOf("CreateSqlldrCtlFile");
        sT.add("tableName", (Object)this._iGenModel.addUser(this._iGenModel.addDoubleQuote(this._iGenModel.getTableName())));
        ArrayList arrayList = new ArrayList();
        ImportGenHelper.genControlFileFields(arrayList, (ImportProperties)this._iProps, (boolean)this._iGenModel.isExistingTable());
        sT.add("nameList", (Object)arrayList.toArray());
        boolean bl = this._iProps.getValueBoolean(ImportKeys.USEGENDIR);
        if (bl) {
            sT.add("fileName", (Object)this._loadFile.getCanonicalName());
        } else {
            sT.add("fileName", (Object)this._loadFile.getCanonicalName().substring(this._loadFile.getCanonicalName().lastIndexOf(File.separator) + 1));
        }
        String string3 = BaseDataFormat.singleQuote((String)BaseDataFormat.getRecordTerminatorString((String)this._iGenModel.getDataFormat().getRecordTerminator()));
        sT.add("endOfRow", (Object)string3);
        String string4 = this._iGenModel.getDataFormat().getEnclosureLeftValue();
        String string5 = this._iGenModel.getDataFormat().getEnclosureRightValue();
        Object object5 = "";
        if (string4.length() != 0) {
            object5 = "OPTIONALLY ENCLOSED BY '" + string4 + "' AND '" + string5 + "'";
        }
        sT.add("enclosures", object5);
        Object object6 = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (!((String)object6).equals("")) {
            object6 = "CHARACTERSET " + (String)object6;
        }
        sT.add("charset", object6);
        String string6 = BaseDataFormat.singleQuote((String)BaseDataFormat.getDelimiterString((String)this._iGenModel.getDataFormat().getDelimiter()));
        if (string6 == null || string6.equals("")) {
            string6 = "','";
        } else if (string6.equals("'WHITESPACE'")) {
            string6 = "WHITESPACE";
        }
        sT.add("fieldDelimiter", (Object)string6);
        String string7 = sT.render();
        File file3 = new File(this._pathStringCtl);
        this._iGenModel.writeOutFile(file3, this._iGenModel.translateEOL(string7 + "\n"));
    }
}

