/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class ImportGenInsertScript
extends ImportGen {
    public static final String NAME = ImportDataFormat.METHOD_INSERT_SCRIPT_NAME;
    public static final int TYPE = 1;
    private ImportProperties _iProps;
    private ImportGenModel _iGenModel;
    private boolean _isValid = false;
    private LoadFile _loadFile;
    private boolean _connLocked = false;
    private boolean _isRequestCancel;
    private IDataReadable _reader;
    private Column[] _insCols;
    private boolean _isIgnoreAllErrors = false;
    private Integer _loadRowsLimit;
    private boolean _isLoadLimit;
    private int _errors = 0;
    private ExitCode _exitCode;

    public String getName() {
        return NAME;
    }

    public Integer getType() {
        return 1;
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel) {
        return this.start(importProperties, importGenModel, false);
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel, boolean bl) {
        if (importProperties == null || importGenModel == null) {
            return false;
        }
        this._iProps = importProperties;
        this._iGenModel = importGenModel;
        if (!this._iProps.getValueBoolean(ImportKeys.IS_BATCH).booleanValue()) {
            this._iGenModel.initELogger();
            this._iGenModel.eLogImportMessages();
        }
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        super.start(importProperties, importGenModel, bl);
        if (this._iGenModel.isExitCodeSuccess()) {
            return this.validate();
        }
        return this._iGenModel.isExitCodeSuccess();
    }

    public boolean validate() {
        this._isValid = true;
        return this._iGenModel.isExitCodeSuccess();
    }

    public boolean isLockNeeded() {
        return false;
    }

    @Override
    public boolean process() {
        this._iGenModel.setExitCode(ExitCode.EXIT_SUCCESS);
        this._loadRowsLimit = this._iProps.getValueInteger(ImportKeys.LOAD_LIMIT);
        boolean bl = this._isLoadLimit = this._loadRowsLimit > 0;
        if (this._iGenModel.isBatch()) {
            this._iGenModel.streamPrintln("SET DEFINE OFF\n");
            this.doCreateScript();
            this.doInsertScript();
        } else {
            this.generateInsertScriptUI();
        }
        return this._iGenModel.isExitCodeSuccess();
    }

    private ExitCode generateInsertScriptUI() {
        try {
            Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.78"));
            String string = this._loadFile.getName();
            GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            int n = -1;
            n = string.lastIndexOf("/");
            if (n > 0) {
                string = string.substring(n + 1);
            }
            String string2 = genericTable.getTable().getTablename();
            Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.77"));
            try {
                this._iGenModel.streamPrintln("SET DEFINE OFF\n");
                this.doCreateScript();
                this.doInsertScript();
                if (this._isRequestCancel) {
                    this._iGenModel.getRunMode().getTask().requestCancel();
                }
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return this._iGenModel.getExitCode();
    }

    private void doCreateScript() {
        if (!this._iGenModel.isExistingTable()) {
            String string = this._iGenModel.getCreateTableStatementWithComments() + "\n";
            this._iGenModel.streamPrintln(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsertScript() {
        int n = 0;
        Object[] objectArray = null;
        this._reader = (IDataReadable)this._iProps.get(ImportKeys.DATA_READER);
        try {
            if (this._reader == null) {
                this._reader = DataReaderRegistry.getReader((String)this._loadFile.getType());
                this._reader.setDataFormat((ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT));
                String string = this._loadFile.getName();
                this._reader.setFileName(string);
            }
            this._insCols = (Column[])this._iProps.get(ImportKeys.SELECTED_COLUMNS);
            if (this._iProps.get(ImportKeys.PAGEID) != null) {
                this._reader.setPage(((Integer)this._iProps.get(ImportKeys.PAGEID)).intValue());
            }
            Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.74"));
            int n2 = 0;
            this._reader.start();
            ImportDataFormat importDataFormat = this._iGenModel.getDataFormat();
            if (importDataFormat.getSkipRows() != 0) {
                int n3 = importDataFormat.isHeader() ? importDataFormat.getSkipRows() + 1 : importDataFormat.getSkipRows();
                for (int i = 0; i < n3 && this._reader.hasMoreRows() && !this._iGenModel.isCancel(); ++i) {
                    try {
                        this._reader.readline();
                        continue;
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                }
            } else if (importDataFormat.isHeader() && this._reader.hasMoreRows()) {
                try {
                    this._reader.readline();
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
            while (this._reader.hasMoreRows() && (!this._isLoadLimit || n2 < this._loadRowsLimit)) {
                if (this._iGenModel.isCancel()) {
                    break;
                }
                try {
                    ++n2;
                    objectArray = this._reader.readline();
                    if (objectArray == null) continue;
                    this._iGenModel.streamPrintln(this.getInsertStatement(this._iGenModel.getTableName(), this._insCols, objectArray) + "\n");
                }
                catch (DataFormatException dataFormatException) {
                    ++n;
                    objectArray = dataFormatException.getColumns();
                    this.handleScriptException(n2, (Exception)((Object)dataFormatException));
                    if (this._isRequestCancel) {
                        this._iGenModel.isCancel(true);
                    }
                    this._iGenModel.streamPrintln("-- " + dataFormatException.getMessage());
                    this._iGenModel.streamPrintln("-- " + ImportResources.getString((String)"DATA_FORMAT_EXCEPTION_LINE"));
                    this._iGenModel.streamPrintln("-- " + dataFormatException.getLine());
                    this._iGenModel.streamPrintln(this.getInsertStatementForComment(this._iGenModel.getTableName(), this._insCols, objectArray) + "\n");
                    this.outBad("-- " + dataFormatException.getMessage());
                    this.outBad("-- " + ImportResources.getString((String)"DATA_FORMAT_EXCEPTION_LINE"));
                    this.outBad("-- " + dataFormatException.getLine());
                    this.outBad(this.getInsertStatement(this._iGenModel.getTableName(), this._insCols, objectArray) + "\n");
                }
            }
        }
        catch (DataReaderException dataReaderException) {
            Logger.warn(this.getClass(), (Throwable)dataReaderException);
        }
        finally {
            if (n > 0) {
                this._iGenModel.streamPrintln("-- " + ImportResources.getString((String)"DATA_FORMAT_EXCEPTION_SUMMARY"));
            }
            this._reader.closeFile();
        }
    }

    private void handleScriptException(int n, Exception exception) {
        ++this._errors;
        String string = exception.getMessage();
        string = string.substring(0, string.length() - 1);
        if (!this._iGenModel.isBatch() && !this._isIgnoreAllErrors) {
            try {
                this.askContinueOnError(string + "\n\n" + DataImportArb.getString("TASK_PROGRESS_SCRIPT_CONTINUE"));
            }
            catch (Throwable throwable) {
                Logger.warn(this.getClass(), (Throwable)throwable);
                this._isRequestCancel = true;
            }
        }
    }

    private void askContinueOnError(String string) throws Throwable {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string2, (String)ImportResources.getString((String)"TASK_SHORT_NAME"), null);
                    if (n == -1) {
                        ImportGenInsertScript.this._isRequestCancel = true;
                    } else if (n == 1) {
                        ImportGenInsertScript.this._isIgnoreAllErrors = true;
                    }
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                    ImportGenInsertScript.this._isRequestCancel = true;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }

    private void outBad(String string) {
        try {
            this._iGenModel.getStream().printlnBad(string);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private Column getColumnFromSourceName(String string, Column[] columnArray) {
        if (string == null || columnArray == null) {
            return null;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getSourceColumnName() == null || !columnArray[i].getSourceColumnName().equals(string)) continue;
            return columnArray[i];
        }
        return null;
    }
}

