/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class StagingTableOraPanel
extends JPanel {
    private JCheckBox _dropCheckBox;
    private JLabel _stagingTableSuffixLabel;
    private JTextField _stagingTableSuffixValue;
    private static final long serialVersionUID = -2739487292165944123L;

    public StagingTableOraPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.initPanel();
    }

    public JCheckBox getCheckBox() {
        return this._dropCheckBox;
    }

    void initPanel() {
        this.add((Component)this.getStagingTableSuffixLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(8, 0, 6, 0), 0, 0));
        this.add(this.getStagingTableSuffixValue(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 8, 6, 0), 0, 0));
        this._dropCheckBox = new JCheckBox();
        this._dropCheckBox.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this._dropCheckBox, (String)ImportResources.getString((String)"METHOD_DROP_STAGING"));
        this.add((Component)this._dropCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JLabel getStagingTableSuffixLabel() {
        if (this._stagingTableSuffixLabel == null) {
            this._stagingTableSuffixLabel = new JLabel();
            this._stagingTableSuffixLabel.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString("IMPORT_ORA_STAGING_SUFFIX_LABEL")));
            this._stagingTableSuffixLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("IMPORT_ORA_STAGING_SUFFIX_LABEL")));
        }
        return this._stagingTableSuffixLabel;
    }

    protected Component getStagingTableSuffixValue() {
        if (this._stagingTableSuffixValue == null) {
            this._stagingTableSuffixValue = new JTextField("", 20);
        }
        return this._stagingTableSuffixValue;
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this._stagingTableSuffixValue.setText(dBConfig.getString("IMPORT_ORA_STAGE_SUFFIX"));
        this._dropCheckBox.setSelected(dBConfig.getBoolean("IMPORT_ORA_STAGE_DROP"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("IMPORT_ORA_STAGE_DROP", this._dropCheckBox.isSelected());
        dBConfig.putString("IMPORT_ORA_STAGE_SUFFIX", this._stagingTableSuffixValue.getText());
    }
}

