/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.data.formattors.CharFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.DataUIUtils;
import oracle.dbtools.raptor.data.ui.ImportByTypeSearchPanel;
import oracle.dbtools.raptor.data.ui.ImportMethodPanel;
import oracle.dbtools.raptor.data.ui.LoadLimitPanel;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.raptor.ui.panels.SearchObjectsSelectionPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;

public class ImportMetadataPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 8282169188783793125L;
    private static final Logger LOGGER = Logger.getLogger(ImportMethodPanel.class.getName());
    protected JLabel _sConnLabel = new JLabel(DataImportArb.getString("CONN_LABEL"));
    protected OracleConnectionComboBox _sourceConnSelector = new OracleConnectionComboBox();
    private ActionListener _sConnListener;
    protected JLabel _sObjectLCmp = new JLabel("");
    protected JButton _sFindCmp;
    private JEWTDialog _subActionDialog;
    private JPanel _searchPanel;
    protected SearchObjectsSelectionPanel _searchSelectionPanel;
    protected URL _selectedUrl;
    private JPanel _sourceDbPanel;
    private JRadioButton _file = new JRadioButton();
    private JRadioButton _database = new JRadioButton();
    private JTextField _tableNameField;
    private GenericTable _table;
    private JTextPane _instructions;
    private JPanel _mainPanel;
    private LoadLimitPanel _loadLimitPanel;
    private DataPreviewGizmo _dataGizmo;
    private boolean _init = false;
    private boolean _isExistingTable;
    private boolean _isExistingTableChanged = false;
    private boolean _isExistingTableOnEntry = false;
    private boolean _isFinishEnabled = false;
    private TraversableContext _ctx;
    private String _connName;
    private DBObject _selectedDbo;
    private DBObject _dboOnEntry;
    private int _loadMethodType;
    private JComboBox<String> _loadMethod;
    private DefaultComboBoxModel<String> _loadMethodModel;
    private ImportProperties _iProps;

    public ImportMetadataPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this._instructions = new JTextPane();
        this._instructions.setEditable(false);
        this._instructions.setOpaque(false);
        this._instructions.setRequestFocusEnabled(false);
        this._instructions.setFocusable(false);
        this._mainPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(DataImportArb.getString("METHOD_LABEL"));
        this._loadMethod = new JComboBox();
        jLabel.setLabelFor(this._loadMethod);
        this._loadLimitPanel = new LoadLimitPanel(null, true);
        this._loadLimitPanel.onEntry();
        int n = 0;
        this._mainPanel.add((Component)this._instructions, LayoutControl.GBC.gbc(0, n, 4, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ImportMetadataPanel.this.changeLoadMethod(ImportDataFormat.getLoadMethodType((String)((String)ImportMetadataPanel.this._loadMethodModel.getSelectedItem())));
                }
            }
        };
        this._loadMethod.addItemListener(itemListener);
        this._mainPanel.add((Component)this.getMetadataPanel(), LayoutControl.GBC.gbc(0, ++n, 4, 1, LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Table Name");
        jLabel2.setText(DataImportArb.getString("TABLE_NAME_LABEL"));
        this._mainPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 6, 16, 8), 0, 0));
        this._tableNameField = new JTextField();
        this._tableNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                if (string != null && string.trim().length() > 0) {
                    ImportMetadataPanel.this._table.setTableName(string);
                    ImportMetadataPanel.this._table.getTable().setTablename(string);
                    ImportMetadataPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(ImportMetadataPanel.this._isExistingTable ? ImportMetadataPanel.this._selectedDbo != null : true), Boolean.valueOf(ImportMetadataPanel.this._isFinishEnabled));
                } else {
                    ImportMetadataPanel.this._tableNameField.setText("");
                    ImportMetadataPanel.this._table.setTableName("");
                    ImportMetadataPanel.this._table.getTable().setTablename("");
                    ImportMetadataPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this._tableNameField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
                ImportMetadataPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(ImportMetadataPanel.this._isExistingTable ? ImportMetadataPanel.this._selectedDbo != null : true), Boolean.valueOf(ImportMetadataPanel.this._isFinishEnabled));
            }
        });
        this._mainPanel.add((Component)this._tableNameField, new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 18, 2, new Insets(16, 6, 16, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this._ctx = traversableContext;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        ImportDataFormat importDataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        IDataReadable iDataReadable = DataReaderRegistry.getReader((String)(loadFile.getType() != null ? loadFile.getType() : importDataFormat.getFormat()));
        this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(this._isExistingTable ? this._selectedDbo != null : true), Boolean.valueOf(this._isFinishEnabled));
        this._isExistingTableOnEntry = this._isExistingTable;
        this._dboOnEntry = this._selectedDbo;
        if (!this._init) {
            this._init = true;
            this._isExistingTable = this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
            this._isFinishEnabled = this._iProps.getValueBoolean(ImportKeys.IS_FINISH_ENABLED);
            this.setDatabasePanelEnable(this._isExistingTable);
            this._loadMethodModel = null;
            this._dataGizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
            boolean bl = (Boolean)this._iProps.get(ImportKeys.IS_CONFIGFILE);
            int n = bl ? (Integer)this._iProps.get(ImportKeys.LOAD_METHOD) : ImportDataFormat.getDefaultCloudMethod((boolean)iDataReadable.isOracleLoaderReadable());
            this._loadMethodModel = new DefaultComboBoxModel<String>(ImportDataFormat.getCloudLoadMethods((boolean)iDataReadable.isOracleLoaderReadable()));
            this._loadLimitPanel.onEntry(this._iProps);
            this.setLayout(new BorderLayout());
            this.add(this._mainPanel, "North");
            this.add(this._dataGizmo, "Center");
            this._loadMethod.setModel(this._loadMethodModel);
            try {
                this._loadMethodModel.setSelectedItem(ImportDataFormat.getLoadMethodName((int)n));
            }
            catch (Exception exception) {
                n = 1;
                this._loadMethodModel.setSelectedItem(ImportDataFormat.METHOD_INSERT_SCRIPT_NAME);
            }
            this.changeLoadMethod(n);
            this._selectedDbo = (DBObject)((Object)this._iProps.get(ImportKeys.DBOBJECT));
            this._database.setSelected(this._isExistingTable);
            this._file.setSelected(!this._isExistingTable);
            if (this._selectedDbo != null && DataUIUtils.isExisting((Object)this._selectedDbo)) {
                this._sourceConnSelector.setCurrentConnection(this._selectedDbo.getConnectionName());
                this._selectedDbo = (DBObject)((Object)this._iProps.get(ImportKeys.DBOBJECT));
                this._selectedUrl = this._selectedDbo.getURL();
                this.objectSelected(this._selectedDbo.getURL());
            } else {
                this._selectedDbo = null;
                this.populateDBO(traversableContext);
                this._sObjectLCmp.setText("");
                this._sObjectLCmp.setIcon(null);
                this._sObjectLCmp.setToolTipText("");
            }
            this.populateTableName();
            if (bl) {
                this._tableNameField.setText((String)this._iProps.get(ImportKeys.TABLE_NAME));
            }
        } else {
            if (this._iProps.get(ImportKeys.TABLE) == null) {
                this.populateDBO(traversableContext);
            }
            this.remove(this._dataGizmo);
            this.add(this._dataGizmo, "Center");
        }
        traversableContext.getWizardCallbacks().wizardUpdateExpectedTransition((Object)true);
    }

    private JPanel getMetadataPanel() {
        ResourceUtils.resButton((AbstractButton)this._file, (String)DataImportArb.getString("TABLE_PROP_FILE"));
        ResourceUtils.resButton((AbstractButton)this._database, (String)DataImportArb.getString("TABLE_PROP_TABLE"));
        this._file.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportMetadataPanel.this.setDatabasePanelEnable(!ImportMetadataPanel.this._file.isSelected());
                ImportMetadataPanel.this._isExistingTable = !ImportMetadataPanel.this._file.isSelected();
                ImportMetadataPanel.this._iProps.put(ImportKeys.TABLE, null);
                ImportMetadataPanel.this._iProps.put(ImportKeys.DBOBJECT, null);
                ImportMetadataPanel.this._iProps.put(ImportKeys.IS_EXISTING_TABLE, (Object)ImportMetadataPanel.this._isExistingTable);
                ImportMetadataPanel.this.populateDBO(ImportMetadataPanel.this._ctx);
                ImportMetadataPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(ImportMetadataPanel.this._isExistingTable ? ImportMetadataPanel.this._selectedDbo != null : true), Boolean.valueOf(ImportMetadataPanel.this._isFinishEnabled));
            }
        });
        this._database.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportMetadataPanel.this.setDatabasePanelEnable(ImportMetadataPanel.this._database.isSelected());
                if (ImportMetadataPanel.this._selectedDbo == null) {
                    ImportMetadataPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                } else {
                    ImportMetadataPanel.this._isExistingTable = true;
                    ImportMetadataPanel.this._iProps.put(ImportKeys.TABLE, null);
                    ImportMetadataPanel.this._iProps.put(ImportKeys.DBOBJECT, (Object)ImportMetadataPanel.this._selectedDbo);
                    ImportMetadataPanel.this._iProps.put(ImportKeys.IS_EXISTING_TABLE, (Object)ImportMetadataPanel.this._isExistingTable);
                    ImportMetadataPanel.this.objectSelected(ImportMetadataPanel.this._selectedDbo.getURL());
                    ImportMetadataPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(ImportMetadataPanel.this._isExistingTable ? ImportMetadataPanel.this._selectedDbo != null : true), Boolean.valueOf(ImportMetadataPanel.this._isFinishEnabled));
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._file);
        buttonGroup.add(this._database);
        this._file.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)this._file, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this._database, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.getSourceTableSubPanel(), LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.SUB_PANEL, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("TABLE_PROP_SOURCE")));
        jPanel2.add((Component)jPanel, "North");
        this.initSourceTable();
        this.setDatabasePanelEnable(false);
        return jPanel2;
    }

    protected JPanel getSourceTableSubPanel() {
        int n = 0;
        this._sourceDbPanel = new JPanel(new GridBagLayout());
        this._sourceDbPanel.add((Component)this._sConnLabel, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        this._sourceDbPanel.add((Component)this._sourceConnSelector.getJComboBox(), LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X));
        this._sFindCmp = new JButton(DataImportArb.getString("FIND"));
        ResourceUtils.resButton((AbstractButton)this._sFindCmp, (String)DataImportArb.getString("FIND"));
        this._sFindCmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportMetadataPanel.this.openSearchPanel();
            }
        });
        this._sourceDbPanel.add((Component)this._sFindCmp, LayoutControl.GBC.gbc(2, n, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.NONE));
        this._sourceDbPanel.add((Component)this._sObjectLCmp, LayoutControl.GBC.gbc(3, 0, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        return this._sourceDbPanel;
    }

    private void populateTableName() {
        String string;
        String string2 = string = this._table.getTable().getTablename() == null ? "" : this._table.getTable().getTablename();
        if (!this._isExistingTable) {
            this._tableNameField.setText(string);
        } else {
            this._tableNameField.setText(DBUtil.addDoubleQuote((String)string));
        }
        if (this._tableNameField.getText().trim().length() > 0) {
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(this._isExistingTable ? this._selectedDbo != null : true), Boolean.valueOf(this._isFinishEnabled));
        } else {
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    public Object getExitTransition() {
        int n = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        return Boolean.valueOf(n == 4) != false || this._iProps.getValueBoolean(ImportKeys.IS_CART) != false;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBUtil dBUtil;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        DBObject dBObject = (DBObject)((Object)this._iProps.get(ImportKeys.DBOBJECT));
        if (traversableContext.getDirection() == 1) {
            if (this._tableNameField.getText().trim().length() > 0) {
                if (dBObject != null && !dBObject.getDatabase().isValidName("TABLE", this._tableNameField.getText().trim())) {
                    throw new TraversalException(DataImportArb.getString("INVALID_TABLE_NAME"));
                }
            } else {
                this._tableNameField.setText("");
                throw new TraversalException(DataImportArb.getString("INVALID_TABLE_NAME"));
            }
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(this._isExistingTable ? this._selectedDbo != null : true), Boolean.valueOf(this._isFinishEnabled));
            if (this._loadMethodType == 4 || this._iProps.getValueBoolean(ImportKeys.IS_CART).booleanValue()) {
                if (this._isExistingTableOnEntry != this._isExistingTable) {
                    this._isExistingTableChanged = this._isExistingTable;
                    this._iProps.put(ImportKeys.SELECTED_COLUMNS, this._iProps.get(ImportKeys.FILE_COLUMNS));
                    this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, (Object)new Column[0]);
                }
                dBUtil = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
                for (String string : dBUtil.getFields()) {
                    string.isChecked(false);
                }
            }
        }
        dBUtil = null;
        if (dBObject != null) {
            String string;
            String string2 = dBObject.getConnectionName();
            dBUtil = DBUtil.getInstance((String)string2);
            if (traversableContext.getDirection() == 1 && !this._isExistingTable && !this._iProps.getValueBoolean(ImportKeys.IS_CART).booleanValue() && dBUtil.resolveName(string = this._tableNameField.getText()) != null) {
                throw new TraversalException(DataImportArb.format("TABLE_NAME_EXISTS_ERROR", string));
            }
        }
        this._iProps.put(ImportKeys.IS_EXISTING_TABLE, (Object)DataUIUtils.isExisting((Object)dBObject));
        this._iProps.put(ImportKeys.TABLE_NAME, (Object)this._tableNameField.getText());
        this._table.setTableName(this._tableNameField.getText());
        this._loadLimitPanel.onExit(this._iProps);
        this._iProps.put(ImportKeys.LOAD_METHOD, (Object)this._loadMethodType);
    }

    private void populateDBO(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        DBObject dBObject = (DBObject)((Object)this._iProps.get(ImportKeys.DBOBJECT));
        this.setInstruction(dBObject);
        GenericTable genericTable = null;
        if (this._iProps.get(ImportKeys.TABLE) != null) {
            genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            this.setTable(genericTable);
        } else {
            LoadFile loadFile;
            for (Column column : loadFile = (LoadFile)this._iProps.get(ImportKeys.FILE_COLUMNS)) {
                if (this._isExistingTable) {
                    column.setName("");
                    continue;
                }
                column.setName(column.getSourceColumnName());
            }
            if (dBObject == null) {
                genericTable = new GenericTable();
                LoadFile loadFile2 = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
                if (this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
                    String string = null;
                    try {
                        URL uRL = new URL((String)this._iProps.get(ImportKeys.OSS_PATH));
                        string = new File(uRL.getPath()).getName();
                        string = string.substring(0, string.lastIndexOf("."));
                        genericTable.getTable().setTablename(string);
                    }
                    catch (Exception exception) {
                        if (string != null) {
                            genericTable.getTable().setTablename(string);
                        }
                    }
                } else {
                    genericTable.getTable().setTablename(loadFile2.getShortName());
                }
                genericTable.setColumns((Column[])this._iProps.get(ImportKeys.FILE_COLUMNS));
            } else if (dBObject.getObjectName() != null) {
                try {
                    genericTable = new GenericTable(Connections.getInstance().getConnection(dBObject.getConnectionName()), dBObject.getSchemaName(), dBObject.getObjectName(), true);
                }
                catch (DBException dBException) {
                    LOGGER.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                }
            } else {
                genericTable = new GenericTable();
            }
            this.setTable(genericTable);
            this._iProps.put(ImportKeys.TABLE, (Object)genericTable);
        }
    }

    private void setInstruction(DBObject dBObject) {
        this._instructions.setText(DataImportArb.getString("META_INFO"));
    }

    private void changeLoadMethod(int n) {
        this._loadMethodType = n;
        this.enableLoadLimitComponents(this._loadMethodType != 2);
        this._ctx.getWizardCallbacks().wizardUpdateExpectedTransition((Object)false);
    }

    private void enableLoadLimitComponents(boolean bl) {
        this._loadLimitPanel.getUseLoadLimitComponent().setEnabled(bl);
        this._loadLimitPanel.getLoadLimitComponent().setEnabled(bl);
    }

    private void setTable(GenericTable genericTable) {
        this._table = genericTable;
    }

    protected void resetConnection() {
        if (this._sObjectLCmp != null) {
            this._selectedUrl = null;
            this._selectedDbo = null;
            this._sObjectLCmp.setText("");
            this._sObjectLCmp.setIcon(null);
            this._sObjectLCmp.setToolTipText("");
        }
    }

    private void setDatabasePanelEnable(boolean bl) {
        this._sConnLabel.setEnabled(bl);
        this._sourceConnSelector.getJComboBox().setEnabled(bl);
        if (this._sourceConnSelector.getJComboBox().getSelectedIndex() != -1) {
            if (!bl) {
                this._sFindCmp.setEnabled(bl);
                this._sObjectLCmp.setEnabled(bl);
            } else {
                this._sObjectLCmp.setEnabled(this._database.isSelected());
                this._sFindCmp.setEnabled(this._database.isSelected());
            }
        } else {
            this._sFindCmp.setEnabled(false);
            this._sObjectLCmp.setEnabled(false);
        }
    }

    protected void enableSourceComponents(boolean bl) {
        this.setDatabasePanelEnable(bl);
        this._sourceDbPanel.revalidate();
        this._sourceDbPanel.repaint();
    }

    protected void openSearchPanel() {
        if (this.getSourceConnection() != null) {
            String string = DataImportArb.getString("SEARCH_DIALOG_TITLE");
            JPanel jPanel = new JPanel(new BorderLayout(0, 16));
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_search_dbobject_html");
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            jTextPane.setRequestFocusEnabled(false);
            jTextPane.setFocusable(false);
            jTextPane.setText(DataImportArb.getString("FIND_INSTRUCTIONS"));
            this._searchSelectionPanel = new SearchObjectsSelectionPanel(new ImportByTypeSearchPanel());
            this._searchSelectionPanel.updatePanel();
            DDLTypes dDLTypes = new DDLTypes();
            dDLTypes.setEnable(false);
            dDLTypes.setTable(true);
            dDLTypes.setShow(false);
            dDLTypes.setShowTable(true);
            this._searchSelectionPanel.setDDLTypes(dDLTypes);
            this._searchSelectionPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    URL uRL;
                    String string = propertyChangeEvent.getPropertyName();
                    if (string.equals("APPLY") && (uRL = ImportMetadataPanel.this._searchSelectionPanel.getUrl()) != null) {
                        ImportMetadataPanel.this._selectedUrl = uRL;
                        ImportMetadataPanel.this.objectSelected(ImportMetadataPanel.this._selectedUrl);
                    }
                }
            });
            this._searchSelectionPanel.setSelectionMode(0);
            this._searchPanel = this._searchSelectionPanel.getPanel();
            this._searchSelectionPanel.setConName(this.getSourceConnection());
            jPanel.add((Component)this._searchPanel, "Center");
            jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this._subActionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                        ImportMetadataPanel.this._selectedUrl = ImportMetadataPanel.this._searchSelectionPanel.getUrl();
                        if (ImportMetadataPanel.this._selectedUrl != null) {
                            ImportMetadataPanel.this.objectSelected(ImportMetadataPanel.this._selectedUrl);
                        }
                    }
                }
            };
            this._subActionDialog.addActionListener(actionListener);
            Dimension dimension = jPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 100;
            int n2 = (int)dimension.getWidth() + 200;
            this._subActionDialog.setMinimumSize(n2, n);
        }
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._subActionDialog);
        this._subActionDialog.setVisible(true);
    }

    protected void objectSelected(URL uRL) {
        Object object;
        Object object2;
        this._selectedDbo = new DBObject(uRL);
        this._isExistingTable = true;
        this._iProps.put(ImportKeys.TABLE, null);
        this._iProps.put(ImportKeys.DBOBJECT, (Object)this._selectedDbo);
        this.populateDBO(this._ctx);
        ArrayList<Column> arrayList = new ArrayList<Column>();
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        if (this._iProps.get(ImportKeys.TABLE) != null) {
            object2 = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            object = null;
            DataTypeFormatterRegistry.getInstance().registerFormattor("CLOB", CharFormattor.class, false, false, false);
            Column column = null;
            for (Column column2 : object2.getColumns()) {
                object = column2.getType();
                column = DataTypeFormatterRegistry.getInstance().getFormattor(((String)object).toUpperCase());
                if (column != null) {
                    arrayList.add(column2);
                    continue;
                }
                arrayList2.add(column2);
            }
            DataTypeFormatterRegistry.getInstance().unregisterFormattor("CLOB");
        }
        if (!arrayList2.isEmpty()) {
            object2 = new StringBuffer();
            for (Column column : arrayList2) {
                ((StringBuffer)object2).append(column.getName());
                ((StringBuffer)object2).append(": ");
                ((StringBuffer)object2).append(column.getType());
                ((StringBuffer)object2).append("\n");
            }
            object = new MessageDetailsDialog();
            ((MessageDetailsDialog)object).showErrorDialog(DataImportArb.getString("TABLE_TYPE_NOT_SUPPORTED"), ((StringBuffer)object2).toString());
            this._selectedDbo = null;
            this._sObjectLCmp.setText("");
            this._sObjectLCmp.setIcon(null);
            this._sObjectLCmp.setToolTipText("");
            this._tableNameField.setText(((LoadFile)this._iProps.get(ImportKeys.LOAD_FILE)).getShortName());
            this._iProps.put(ImportKeys.TABLE, null);
            this._iProps.put(ImportKeys.DBOBJECT, (Object)this._selectedDbo);
            this.populateDBO(this._ctx);
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(this._isFinishEnabled));
        } else {
            this._sObjectLCmp.setText(this._selectedDbo.getSchemaName() + "." + this._selectedDbo.getObjectName());
            this._sObjectLCmp.setIcon(DBURLFormatHelper.getIcon(this._selectedUrl));
            this._sObjectLCmp.setToolTipText(DataImportArb.getString("DB_OBJECT_TIP"));
            this._tableNameField.setText(DBUtil.addDoubleQuote((String)this._selectedDbo.getObjectName()));
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(this._isExistingTable ? this._selectedDbo != null : true), Boolean.valueOf(this._isFinishEnabled));
        }
        if (this._subActionDialog != null) {
            this.refreshPanel();
            this._subActionDialog.setVisible(false);
            this._subActionDialog.dispose();
        }
    }

    protected void refreshPanel() {
        this._sourceDbPanel.validate();
        this._sourceDbPanel.repaint();
        this._tableNameField.repaint();
        super.repaint();
    }

    protected void initSourceTable() {
        this.initConn();
        this._sourceConnSelector.getJComboBox().setToolTipText(DataImportArb.getString("SCONN_TOOLTIP"));
        this._sourceConnSelector.getJComboBox().addItemListener(new Connector(this._sourceConnSelector));
        this.enableSourceComponents(false);
    }

    protected void initConn() {
        this._sConnLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("CONN_LABEL")));
        this._sConnLabel.setLabelFor(this._sourceConnSelector.getJComboBox());
        this._sConnLabel.setToolTipText(DataImportArb.getString("SCONN_TOOLTIP"));
        this.addSourceConnListener();
    }

    private void addSourceConnListener() {
        this._sConnListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportMetadataPanel.this._connName = ImportMetadataPanel.this.getSourceConnection();
                ImportMetadataPanel.this.enableSourceComponents(true);
                ImportMetadataPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(ImportMetadataPanel.this._selectedDbo != null), Boolean.valueOf(ImportMetadataPanel.this._isFinishEnabled));
                ImportMetadataPanel.this._selectedDbo = null;
                ImportMetadataPanel.this._selectedUrl = null;
                if (ImportMetadataPanel.this._searchSelectionPanel != null) {
                    ImportMetadataPanel.this.resetConnection();
                }
            }
        };
        this._sourceConnSelector.getJComboBox().addActionListener(this._sConnListener);
    }

    public String getSourceConnection() {
        if (this._sourceConnSelector != null) {
            return this._sourceConnSelector.getCurrentConnectionName();
        }
        return null;
    }

    private class Connector
    implements ItemListener {
        private OracleConnectionComboBox m_selector;

        Connector(OracleConnectionComboBox oracleConnectionComboBox) {
            this.m_selector = oracleConnectionComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            block6: {
                if (this.m_selector.getJComboBox().getSelectedIndex() != -1) {
                    boolean bl = true;
                    String string = ImportMetadataPanel.this.getSourceConnection();
                    try {
                        Connections.getInstance().getConnection(string);
                        if (string.equals(ImportMetadataPanel.this._connName)) {
                            bl = false;
                        } else {
                            ImportMetadataPanel.this._connName = string;
                        }
                        if (!bl) break block6;
                        ImportMetadataPanel.this.enableSourceComponents(true);
                        ImportMetadataPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(ImportMetadataPanel.this._selectedDbo != null), Boolean.valueOf(ImportMetadataPanel.this._isFinishEnabled));
                        ImportMetadataPanel.this._selectedDbo = null;
                        ImportMetadataPanel.this._selectedUrl = null;
                        if (ImportMetadataPanel.this._searchSelectionPanel == null) break block6;
                        ImportMetadataPanel.this.resetConnection();
                    }
                    catch (Exception exception) {
                        Throwable throwable;
                        Exception exception2;
                        while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                            exception2 = (Exception)throwable;
                        }
                    }
                }
            }
        }
    }
}

