/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.readers.DataReaderEvent;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ColumnDefinitionDetective;
import oracle.dbtools.raptor.data.validators.DataTypeValidatorRegistry;
import oracle.dbtools.raptor.data.validators.ITypeValidator;
import oracle.dbtools.raptor.data.validators.LoadFieldValidator;
import oracle.dbtools.raptor.data.validators.NumberValidator;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class DataPreviewGizmo
extends JPanel {
    private static final long serialVersionUID = -5525219439802104748L;
    private JTable table;
    private IDataReadable _dataReader;
    private ImportProperties _iProps;
    private ImportDataFormat _dataFormat;
    private ColumnDefinitionDetective _detective;
    private JScrollPane scrollPane;
    private JScrollPane _oneColScrollPane;
    private JPanel _oneColPanel;
    private DefaultListModel<String> _oneColListModel;
    private JList<String> _oneColJList;
    private OneColGizmoRenderer _oneColRenderer = new OneColGizmoRenderer();
    private boolean _resetData;

    public DataPreviewGizmo(IDataReadable iDataReadable) {
        this._dataReader = iDataReadable;
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("GIZMO_TITLE")));
        this.scrollPane = new JScrollPane(22, 32);
        this.add((Component)this.scrollPane, "Center");
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.table.setAutoResizeMode(0);
        this.scrollPane.setViewportView(this.table);
    }

    public JPanel getUIOneCol(int n) {
        this._oneColPanel = new JPanel(new BorderLayout());
        this._oneColPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("GIZMO_TITLE_ONE_COL")));
        this._oneColScrollPane = new JScrollPane(22, 32);
        this._oneColPanel.add((Component)this._oneColScrollPane, "Center");
        this._oneColListModel = new DefaultListModel();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this._oneColListModel.addElement((String)this.table.getValueAt(i, n));
        }
        this._oneColJList = new JList<String>(this._oneColListModel){
            private static final long serialVersionUID = 1L;
        };
        this._oneColRenderer.setColumn(n);
        this._oneColJList.setCellRenderer(this._oneColRenderer);
        this._oneColScrollPane.setViewportView(this._oneColJList);
        return this._oneColPanel;
    }

    public void refreshOneCol(int n) {
        this._oneColListModel.removeAllElements();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            try {
                this._oneColListModel.addElement((String)this.table.getValueAt(i, n));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this._oneColRenderer.setColumn(n);
    }

    public boolean validateData(Column column, Locale locale) {
        ITypeValidator iTypeValidator = DataTypeValidatorRegistry.getInstance().getValidator(column.getType());
        if (iTypeValidator == null) {
            iTypeValidator = DataTypeValidatorRegistry.getInstance().getValidator("VARCHAR2");
        }
        iTypeValidator.setLocale(locale);
        if (iTypeValidator instanceof NumberValidator) {
            ((NumberValidator)iTypeValidator).setNlsDecimalSeparator((Character)this._iProps.get(ImportKeys.NLS_DECIMAL_SEPARATOR));
        }
        boolean bl = true;
        for (int i = 0; bl && i < this.table.getRowCount(); ++i) {
            try {
                String string = (String)this.table.getValueAt(i, column.getSourceColID());
                bl = iTypeValidator.validateData(column, string);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl = column.isNullable();
            }
        }
        return bl;
    }

    public boolean validateData(Column column, int n, Locale locale) {
        ITypeValidator iTypeValidator = DataTypeValidatorRegistry.getInstance().getValidator(column.getType());
        if (iTypeValidator == null) {
            iTypeValidator = DataTypeValidatorRegistry.getInstance().getValidator("VARCHAR2");
        }
        iTypeValidator.setLocale(locale);
        boolean bl = true;
        try {
            String string = (String)this.table.getValueAt(n, column.getSourceColID());
            bl = iTypeValidator.validateData(column, string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = column.isNullable();
        }
        return bl;
    }

    public void detectFormat(Column column, Locale locale, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this._detective.detectFormat(this._dataReader.getPreviewRows(), column, this._dataReader.isHeader());
    }

    public void initDetective(Locale locale) {
        this.initDetective(locale, null, null, null);
    }

    public void initDetective(Locale locale, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this._detective = new ColumnDefinitionDetective(locale, (Character)this._iProps.get(ImportKeys.NLS_DECIMAL_SEPARATOR));
        this._detective.setMasks(stringArray, stringArray2, stringArray3);
    }

    public void detectFormat(Column column) {
        this._detective.detectFormat(this._dataReader.getPreviewRows(), column, this._dataReader.isHeader());
    }

    public void detectColumnDefinitions(LoadFile loadFile) {
        if (this._detective != null && this._dataReader != null) {
            for (LoadField loadField : loadFile.getFields()) {
                if (!loadField.isLoad() || loadField.isChecked()) continue;
                this._detective.detect(this._dataReader.getPreviewRows(), loadField, this._dataReader.isHeader());
            }
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public void resetData(boolean bl) {
        this._resetData = true;
    }

    public IDataReadable getDataReader() {
        return this._dataReader;
    }

    public void setDataReader(IDataReadable iDataReadable) {
        this._dataReader = iDataReadable;
        this.populateDataTable(this._dataReader);
        this._resetData = true;
    }

    public void setDataFormat(ImportDataFormat importDataFormat) {
        this._dataFormat = importDataFormat;
    }

    public void setProperties(ImportProperties importProperties) {
        this._iProps = importProperties;
        this._oneColRenderer.setProperties(this._iProps);
        this._resetData = false;
    }

    public void initTable() {
        this.table = new JTable();
    }

    public void populateDataTable() {
        this.populateDataTable(this._dataReader);
    }

    public void populateDataTable(IDataReadable iDataReadable) {
        this._dataReader.refreshPreview(true);
        iDataReadable.setDataFormat(this._dataFormat);
        TableModel tableModel = iDataReadable.getTableModel();
        this.table.setModel(tableModel);
    }

    public void raiseEvent(DataReaderEvent dataReaderEvent) {
    }

    public void createFields(LoadFile loadFile) {
        TableColumnModel tableColumnModel = this.table.getTableHeader().getColumnModel();
        if (loadFile.getFieldCount() == 0 || tableColumnModel.getColumnCount() != loadFile.getFieldCount()) {
            loadFile.setFields(new LoadField[0]);
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                LoadField loadField = new LoadField();
                loadField.setName(tableColumnModel.getColumn(i).getHeaderValue().toString());
                loadField.setFormat("");
                loadField.setLength(this._dataReader.getWidth(i));
                loadField.isLoad(true);
                loadField.isCompatible(false);
                loadField.isChecked(false);
                loadFile.addField(loadField);
            }
        } else {
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                LoadField loadField = loadFile.getField(i);
                loadField.setName(tableColumnModel.getColumn(i).getHeaderValue().toString());
                loadField.setFormat("");
                loadField.setLength(this._dataReader.getWidth(i));
                loadField.isLoad(true);
                loadField.isCompatible(false);
                loadField.isChecked(false);
            }
        }
    }

    public void onExit(TraversableContext traversableContext) {
    }

    public void onEntry(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        this._oneColRenderer.setProperties(this._iProps);
        this.validate();
        this._resetData = false;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        if (this._dataReader != null) {
            this._dataReader.closeFile();
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
        if (this._dataReader != null) {
            this._dataReader.closeFile();
        }
    }

    private static class OneColGizmoRenderer
    extends DefaultListCellRenderer {
        int _colIndex;
        private ImportProperties _iProps;
        private Locale _locale;
        private DataPreviewGizmo _gizmo;
        private Font _defaultFont;
        private Font _errorFont;
        private static final long serialVersionUID = 0L;

        private OneColGizmoRenderer() {
        }

        public void setColumn(int n) {
            this._colIndex = n;
        }

        public void setProperties(ImportProperties importProperties) {
            this._iProps = importProperties;
            this._locale = (Locale)this._iProps.get(ImportKeys.LOCALE);
            this._gizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (this._iProps != null) {
                if (this._defaultFont == null) {
                    this._defaultFont = jLabel.getFont();
                    this._errorFont = new Font(jLabel.getFont().getName(), 1, jLabel.getFont().getSize());
                }
                LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
                LoadField loadField = loadFile.getField(this._colIndex);
                LoadFieldValidator[] loadFieldValidatorArray = (LoadFieldValidator[])this._iProps.get(ImportKeys.VALIDATORS);
                LoadFieldValidator loadFieldValidator = loadFieldValidatorArray[this._colIndex];
                if (loadFieldValidator.getExitCode(LoadFieldValidator.Test.COMPATIBLE_DATA) != null && loadFieldValidator.getExitCode(LoadFieldValidator.Test.COMPATIBLE_DATA) != ExitCode.EXIT_SUCCESS && !this._gizmo.validateData(loadField.getColumn(), n, this._locale)) {
                    jLabel.setFont(this._errorFont);
                    jLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    return jLabel;
                }
            }
            jLabel.setFont(this._defaultFont);
            jLabel.setIcon(null);
            return jLabel;
        }
    }
}

