/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.Table;
import oracle.dbtools.importer.core.DataType;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

abstract class ColumnPropertyPanel
extends JPanel {
    private static final long serialVersionUID = 7720631577011179873L;
    protected final DataPreviewGizmo m_gizmo;
    protected Connection _conn;
    protected Column currentSrcColumn;
    protected Table m_table;
    protected JLabel nameLabel;
    protected JLabel typeLabel;
    protected JLabel scaleLabel;
    protected JLabel precisionLabel;
    protected JLabel defaultLabel;
    protected JTextField nameField;
    protected Component typeField;
    protected JTextField scaleField;
    protected Component precisionField;
    protected JTextField defaultField;
    protected JCheckBox nullCheck;
    protected JLabel commentLabel;
    protected JTextArea commentArea;
    protected JScrollPane commentPane;
    protected JPanel dataPanel = new JPanel();
    protected GridBagConstraints precisionTextfieldConstraints;
    protected GridBagConstraints scaleTextfieldConstraints;
    protected GridBagConstraints precisionLabelConstraints;
    protected GridBagConstraints scaleLabelConstraints;
    protected GridBagConstraints dateMaskLblConstraints;
    protected GridBagConstraints dateMaskConstraints;
    protected Column column;
    protected GridBagConstraints typeFieldConstraints = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
    private ArrayList<ColumnChangeListener> listeners = new ArrayList();
    private String[] _dateMasks;
    private String[] _timestampMasks;
    private String[] _timestamptzMasks;
    protected DefaultComboBoxModel<String> dateMaskModel;
    protected DefaultComboBoxModel<String> timestampMaskModel;
    protected DefaultComboBoxModel<String> timestamptzMaskModel;
    protected DefaultComboBoxModel<String> timestampltzMaskModel;
    protected JComboBox<String> dateMask;
    protected JLabel dateMaskLbl;
    protected ImportProperties _iProps;
    protected DataType[] _datatypes;
    protected boolean _isDetectedDefault = true;
    protected boolean _isDefaultMax = false;
    protected boolean _isRounded = true;
    private static final Logger LOGGER = Logger.getLogger(ColumnPropertyPanel.class.getName());

    public ColumnPropertyPanel(ImportProperties importProperties) {
        super(new GridBagLayout());
        this._iProps = importProperties;
        this.m_gizmo = (DataPreviewGizmo)this._iProps.get(ImportKeys.GIZMO);
        try {
            this._conn = Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME));
        }
        catch (DBException dBException) {
            LOGGER.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
        }
        this._dateMasks = (String[])this._iProps.get(ImportKeys.DATE_MASKS);
        this._timestampMasks = (String[])this._iProps.get(ImportKeys.TIMESTAMP_MASKS);
        this._timestamptzMasks = (String[])this._iProps.get(ImportKeys.TIMESTAMPTZ_MASKS);
        this.dateMask = new JComboBox();
        this.dateMask.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ColumnPropertyPanel.this.column.setFormat((String)((JComboBox)itemEvent.getSource()).getSelectedItem());
                    ColumnPropertyPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertyPanel.this.column, ColumnChangeEvent.Type.FORMAT));
                }
            }
        });
        ((JTextField)this.dateMask.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.valueChanged(documentEvent);
            }

            void valueChanged(DocumentEvent documentEvent) {
                String string = "";
                try {
                    string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ColumnPropertyPanel.this.column.setFormat(string);
                ColumnPropertyPanel.this.firelisteners(new ColumnChangeEvent(ColumnPropertyPanel.this.column, ColumnChangeEvent.Type.FORMAT));
            }
        });
        this.dateMaskModel = new DefaultComboBoxModel(new Vector(this._dateMasks.length + 2, 5));
        this.dateMaskModel.addElement("");
        this.dateMask.setModel(this.dateMaskModel);
        for (String string : this._dateMasks) {
            this.addDateMask(string);
        }
        this.timestampMaskModel = new DefaultComboBoxModel(new Vector(this._timestampMasks.length + 2, 5));
        this.timestampMaskModel.addElement("");
        this.dateMask.setModel(this.timestampMaskModel);
        for (String string : this._timestampMasks) {
            this.addDateMask(string);
        }
        this.timestamptzMaskModel = new DefaultComboBoxModel(new Vector(this._timestamptzMasks.length + 2, 5));
        this.timestamptzMaskModel.addElement("");
        this.dateMask.setModel(this.timestamptzMaskModel);
        for (String string : this._timestamptzMasks) {
            this.addDateMask(string);
        }
        this.timestampltzMaskModel = new DefaultComboBoxModel(new Vector(this._timestampMasks.length + 2, 5));
        this.timestampltzMaskModel.addElement("");
        this.dateMask.setModel(this.timestampltzMaskModel);
        for (String string : this._timestampMasks) {
            this.addDateMask(string);
        }
        this.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("DATA_MAPPING_TGT_COLUMNS")));
        this.nameLabel = new JLabel();
        this.nameLabel.setText(DataImportArb.getString("COLUMN_NAME_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.typeLabel = new JLabel();
        this.typeLabel.setText(DataImportArb.getString("COLUMN_DATATYPE_LABEL"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)this.typeLabel, gridBagConstraints2);
        this.precisionLabel = new JLabel();
        this.precisionLabel.setText(DataImportArb.getString("COLUMN_PRECISION_LABEL"));
        this.precisionLabel.setToolTipText(DataImportArb.getString("COLUMN_PRECISION_TIP"));
        this.precisionLabelConstraints = new GridBagConstraints();
        this.precisionLabelConstraints.insets = new Insets(5, 5, 0, 5);
        this.precisionLabelConstraints.gridy = 3;
        this.precisionLabelConstraints.gridx = 0;
        this.precisionLabelConstraints.anchor = 13;
        this.add((Component)this.precisionLabel, this.precisionLabelConstraints);
        this.scaleLabel = new JLabel();
        this.scaleLabel.setText(DataImportArb.getString("COLUMN_SCALE_LABEL"));
        this.scaleLabelConstraints = new GridBagConstraints();
        this.scaleLabelConstraints.insets = new Insets(5, 5, 0, 5);
        this.scaleLabelConstraints.gridy = 4;
        this.scaleLabelConstraints.gridx = 0;
        this.scaleLabelConstraints.anchor = 13;
        this.add((Component)this.scaleLabel, this.scaleLabelConstraints);
        this.dateMaskLbl = new JLabel();
        this.dateMaskLbl.setText(Messages.getString("ColumnPropertyPanel.0"));
        this.dateMaskLblConstraints = new GridBagConstraints();
        this.dateMaskLblConstraints.insets = new Insets(5, 5, 0, 5);
        this.dateMaskLblConstraints.gridy = 5;
        this.dateMaskLblConstraints.gridx = 0;
        this.dateMaskLblConstraints.anchor = 13;
        this.defaultLabel = new JLabel();
        this.defaultLabel.setText(DataImportArb.getString("COLUMN_DEFAULT_LABEL"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints3.gridy = 6;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 13;
        this.add((Component)this.defaultLabel, gridBagConstraints3);
        this.precisionTextfieldConstraints = new GridBagConstraints();
        this.precisionTextfieldConstraints.gridwidth = 2;
        this.precisionTextfieldConstraints.insets = new Insets(5, 5, 0, 5);
        this.precisionTextfieldConstraints.fill = 2;
        this.precisionTextfieldConstraints.gridy = 3;
        this.precisionTextfieldConstraints.gridx = 1;
        this.scaleField = new JTextField();
        this.scaleTextfieldConstraints = new GridBagConstraints();
        this.scaleTextfieldConstraints.gridwidth = 2;
        this.scaleTextfieldConstraints.insets = new Insets(5, 5, 0, 5);
        this.scaleTextfieldConstraints.fill = 2;
        this.scaleTextfieldConstraints.weightx = 1.0;
        this.scaleTextfieldConstraints.gridy = 4;
        this.scaleTextfieldConstraints.gridx = 1;
        this.add((Component)this.scaleField, this.scaleTextfieldConstraints);
        this.scaleField.setEnabled(true);
        this.dateMaskConstraints = new GridBagConstraints();
        this.dateMaskConstraints.gridwidth = 2;
        this.dateMaskConstraints.insets = new Insets(5, 5, 0, 5);
        this.dateMaskConstraints.fill = 2;
        this.dateMaskConstraints.weightx = 1.0;
        this.dateMaskConstraints.gridy = 5;
        this.dateMaskConstraints.gridx = 1;
        this.dateMask.setEditable(true);
        this.addDateMask();
        this.defaultField = new JTextField();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridy = 6;
        gridBagConstraints4.gridx = 2;
        this.add((Component)this.defaultField, gridBagConstraints4);
        this.nullCheck = new JCheckBox(Messages.getString("ColumnPropertyPanel.2"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.gridy = 6;
        gridBagConstraints5.gridx = 0;
        this.add((Component)this.nullCheck, gridBagConstraints5);
        this.commentLabel = new JLabel();
        this.commentLabel.setText(DataImportArb.getString("COLUMN_COMMENT_LABEL"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints6.gridy = 7;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.anchor = 17;
        this.add((Component)this.commentLabel, gridBagConstraints6);
        this.commentArea = new JTextArea();
        this.commentArea.setRows(4);
        this.commentPane = new JScrollPane(this.commentArea);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.weighty = 0.2;
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.gridheight = 8;
        gridBagConstraints7.gridy = 8;
        gridBagConstraints7.gridx = 0;
        this.add((Component)this.commentPane, gridBagConstraints7);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(16, 5, 0, 5);
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.weighty = 0.8;
        gridBagConstraints8.gridwidth = 3;
        gridBagConstraints8.gridy = 16;
        gridBagConstraints8.gridx = 0;
        this.add((Component)this.m_gizmo.getUIOneCol(0), gridBagConstraints8);
        this.removeDateMask();
    }

    public void setPrecisionProfile(boolean bl, boolean bl2, boolean bl3) {
        this._isDetectedDefault = bl;
        this._isDefaultMax = bl2;
        this._isRounded = bl3;
    }

    public void setNullVisible(boolean bl) {
        this.nullCheck.setVisible(bl);
    }

    public void setDefaultVisible(boolean bl) {
        this.defaultLabel.setVisible(bl);
        this.defaultField.setVisible(bl);
    }

    public void setCommentVisible(boolean bl) {
        this.commentLabel.setVisible(bl);
        this.commentArea.setVisible(bl);
        this.commentPane.setVisible(bl);
    }

    public void setNameEnabled(boolean bl) {
        this.nameField.setEnabled(bl);
    }

    public void setPrecisionScaleEnabled(boolean bl) {
        this.precisionField.setEnabled(bl);
        this.scaleField.setEnabled(bl);
    }

    public void setPrecisionScaleVisible(boolean bl) {
        this.precisionLabel.setVisible(bl);
        this.precisionField.setVisible(bl);
        this.scaleLabel.setVisible(bl);
        this.scaleField.setVisible(bl);
    }

    protected void addPrecisionScale() {
        this.add((Component)this.precisionLabel, this.precisionLabelConstraints);
        this.add((Component)this.scaleLabel, this.scaleLabelConstraints);
        this.add(this.precisionField, this.precisionTextfieldConstraints);
        this.add((Component)this.scaleField, this.scaleTextfieldConstraints);
        this.revalidate();
        this.repaint();
    }

    protected void removePrecisionScale() {
        this.remove(this.precisionLabel);
        this.remove(this.scaleLabel);
        this.remove(this.precisionField);
        this.remove(this.scaleField);
        this.revalidate();
        this.repaint();
    }

    protected void addPrecision() {
        this.add((Component)this.precisionLabel, this.precisionLabelConstraints);
        this.add(this.precisionField, this.precisionTextfieldConstraints);
        if (this.column != null && !(this.precisionField instanceof JComboBox)) {
            ((JTextField)this.precisionField).setText(String.valueOf(this.column.getPrecision()));
        }
        this.revalidate();
        this.repaint();
    }

    protected void removePrecision() {
        this.remove(this.precisionLabel);
        this.remove(this.precisionField);
        this.revalidate();
        this.repaint();
    }

    protected void addScale() {
        this.add((Component)this.scaleLabel, this.scaleLabelConstraints);
        this.add((Component)this.scaleField, this.scaleTextfieldConstraints);
        this.enableScale();
        if (this.column != null) {
            this.scaleField.setText(String.valueOf(this.column.getScale()));
        }
        this.revalidate();
        this.repaint();
    }

    protected void enableScale() {
        String string = null;
        if (this.typeField instanceof JComboBox) {
            string = ((JComboBox)this.typeField).getSelectedItem().toString();
        } else if (this.typeField instanceof JTextField) {
            string = ((JTextField)this.typeField).getText();
        }
        String string2 = this.precisionField instanceof JComboBox ? ((JTextField)((JComboBox)this.precisionField).getEditor().getEditorComponent()).getText() : ((JTextField)this.precisionField).getText();
        this.scaleField.setEnabled(false);
        if (ModelUtil.hasLength((String)string2) && DataType.NUMBER.toString().equals(string)) {
            String string3;
            if (Integer.parseInt(string2.trim()) > 0) {
                this.scaleField.setEnabled(true);
            }
            if (ModelUtil.hasLength((String)(string3 = this.scaleField.getText())) && Integer.parseInt(string3.trim()) == 200) {
                this.scaleField.setText("0");
            }
        }
    }

    protected void removeScale() {
        this.remove(this.scaleLabel);
        this.remove(this.scaleField);
        this.revalidate();
        this.repaint();
    }

    protected void addDateMask() {
        this.add((Component)this.dateMaskLbl, this.dateMaskLblConstraints);
        this.add(this.dateMask, this.dateMaskConstraints);
        this.revalidate();
        this.repaint();
    }

    protected void removeDateMask() {
        this.remove(this.dateMaskLbl);
        this.remove(this.dateMask);
        this.revalidate();
        this.repaint();
    }

    abstract void setColumn(Column var1);

    public Column getColumn() {
        return this.column;
    }

    protected void setComment(String string) {
        this.commentArea.setText(string);
    }

    protected String getComment() {
        return this.commentArea.getText();
    }

    protected void setNullable(boolean bl) {
        this.nullCheck.setSelected(bl);
    }

    protected boolean setNullable() {
        return this.nullCheck.isSelected();
    }

    protected void setScale(int n) {
        if (this.scaleField != null) {
            this.scaleField.setText(String.valueOf(n));
        }
    }

    protected int getScale() {
        try {
            if (this.scaleField != null) {
                return Integer.parseInt(this.scaleField.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected void setPrecision(int n) {
        ((JTextField)this.precisionField).setText(String.valueOf(n));
    }

    protected int getPrecision() {
        if (this.precisionField != null) {
            try {
                if (this.precisionField instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)this.precisionField;
                    return Integer.parseInt(((JTextField)jComboBox.getEditor().getEditorComponent()).getText());
                }
                return Integer.parseInt(((JTextField)this.precisionField).getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    abstract void setDataType(String var1);

    abstract void setColumnName(String var1);

    abstract void switchColumn(Column var1);

    public void enabled(boolean bl) {
        this.precisionField.setEnabled(bl);
        this.scaleField.setEnabled(bl);
        this.commentArea.setEnabled(bl);
        this.nullCheck.setEnabled(bl);
        this.defaultField.setEnabled(bl);
    }

    public void setDataTable(GenericTable genericTable) {
        this.setTable(genericTable);
    }

    abstract void setTable(GenericTable var1);

    abstract Column getColumnDetails();

    public void addColumnChangeListener(ColumnChangeListener columnChangeListener) {
        this.listeners.add(columnChangeListener);
    }

    public void removeColumnChangeListener(ColumnChangeListener columnChangeListener) {
        this.listeners.remove(columnChangeListener);
    }

    public void firelisteners(ColumnChangeEvent columnChangeEvent) {
        Iterator<ColumnChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().columnChanged(columnChangeEvent);
        }
    }

    public JComboBox<String> getDateMask() {
        return this.dateMask;
    }

    public void setDateMaskModel(String string) {
        this.setDateMaskModel(string, null);
    }

    public void setDateMaskModel(String string, String string2) {
        if (string.equals(DataType.DATE.toString())) {
            this.dateMask.setModel(this.dateMaskModel);
        } else if (string.equals(DataType.TIMESTAMP.toString())) {
            this.dateMask.setModel(this.timestampMaskModel);
        } else if (string.equals(DataType.TIMESTAMPTZ.toString())) {
            this.dateMask.setModel(this.timestamptzMaskModel);
        } else if (string.equals(DataType.TIMESTAMPLTZ.toString())) {
            this.dateMask.setModel(this.timestampltzMaskModel);
        } else {
            return;
        }
        this.setDateMask(string2 != null ? string2 : "");
    }

    public void setDateMask(String string) {
        if (this.dateMask != null && string != null) {
            for (int i = 0; i < this.dateMask.getItemCount(); ++i) {
                if (!this.dateMask.getItemAt(i).equalsIgnoreCase(string)) continue;
                this.dateMask.setSelectedIndex(i);
                return;
            }
            this.dateMask.addItem(string);
            this.dateMask.setSelectedItem(string);
        }
    }

    public void addDateMask(String string) {
        if (this.dateMask != null) {
            for (int i = 0; i < this.dateMask.getItemCount(); ++i) {
                if (!this.dateMask.getItemAt(i).equalsIgnoreCase(string)) continue;
                return;
            }
            this.dateMask.addItem(string);
        }
    }
}

