/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.io.FileInputStream;
import java.io.InputStream;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.readers.XLSReader;
import oracle.dbtools.util.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSXReader
extends XLSReader {
    public static String NAME = Messages.getString("XLSXReader.0");
    public static final String FORMAT = "Excel 2003+ ( XLSX )".toLowerCase();
    public static final String EXT = "xlsx";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getType() {
        return EXT;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    protected XSSFWorkbook newWorkbook(FileInputStream fileInputStream) throws DataReaderException {
        try {
            return new XSSFWorkbook((InputStream)fileInputStream);
        }
        catch (Throwable throwable) {
            Logger.severe(XLSReader.class, (Throwable)throwable);
            throw new DataReaderException(throwable.getMessage());
        }
    }
}

