/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.importer.readers.DataReader;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.raptor.data.Messages;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XLSReader
extends DataReader {
    private static final String PATTERN_TIMESTAMP = "YYYY-MM-DD HH24:MI";
    private static final String PATTERN_SHORT_DATE = "MM/dd/yyyy";
    private static final String PATTERN_LONG_DATE = "MMM/dd/yyyy";
    private Map<Sheet, Map<Integer, Integer>> sheetWidths = new HashMap<Sheet, Map<Integer, Integer>>();
    private Map<Integer, Integer> colwidths;
    public static String NAME = Messages.getString("XLSReader.0");
    public static final String FORMAT = "Excel 95-2003 ( XLS)".toLowerCase();
    public static final String EXT = "xls";
    public static final String KEY_HEADER = "IMPORT_XLS_HEADER";
    private String _fileName;
    private FileInputStream _xlsFileReader;
    private Workbook _workbook;
    private FormulaEvaluator _evaluator;
    private Sheet currentSheet;
    private Row headerRow;
    private int currentRow = 0;
    private int _colCount = 0;
    private static char _decimalSeparator = ((DecimalFormat)DecimalFormat.getInstance()).getDecimalFormatSymbols().getDecimalSeparator();

    public String getName() {
        return NAME;
    }

    public String getType() {
        return EXT;
    }

    public String getFormat() {
        return FORMAT;
    }

    public List<Object[]> getPreviewRows() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object[] objectArray = null;
        int n = this.dataFormat.getPreviewLimit();
        try {
            if (!this.dataFormat.getUsePreviewLimit() || this.currentSheet.getLastRowNum() < n) {
                n = this.currentSheet.getLastRowNum();
            }
            int n2 = this.dataFormat.getSkipRows();
            int n3 = this.dataFormat.isHeader() ? this.getFirstNonEmptyRowNumber(n2) : n2;
            this._colCount = 0;
            for (int i = n3; i <= n; ++i) {
                objectArray = this.getRow(i);
                if (objectArray == null) continue;
                if (objectArray.length > this._colCount) {
                    this._colCount = objectArray.length;
                }
                arrayList.add(objectArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public int getColumnCount() {
        int n = 0;
        short s = 0;
        short s2 = 0;
        if (this.dataFormat.isHeader()) {
            int n2 = this.dataFormat.getSkipRows();
            int n3 = this.getFirstNonEmptyRowNumber(n2);
            this.headerRow = this.getHeaderRow();
            this.currentSheet.getRow(n3);
            if (this.headerRow != null) {
                s = this.headerRow.getFirstCellNum();
                s2 = this.headerRow.getLastCellNum();
                n = s == 0 ? (int)s2 : s2 - s;
            }
            return n;
        }
        return this._colCount;
    }

    public TableModel getTableModel() {
        this.m_headerRowColumnNames = null;
        this.headerRow = null;
        return super.getTableModel();
    }

    public String[] getColumnNames() {
        int n = 0;
        short s = 0;
        if (this.dataFormat.isHeader()) {
            if (this.m_headerRowColumnNames == null) {
                if (this.headerRow == null) {
                    this.headerRow = this.getHeaderRow();
                }
                if (this.headerRow != null) {
                    n = this.headerRow.getFirstCellNum();
                    s = this.headerRow.getLastCellNum();
                }
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                HashMap<CallSite, Integer> hashMap = new HashMap<CallSite, Integer>();
                for (int i = n; i < s; ++i) {
                    String string;
                    int n2 = i + 1;
                    Cell cell = this.headerRow.getCell(i);
                    Object object = cell != null ? this.Value(cell) : null;
                    String string2 = string = object != null ? object.toString().toUpperCase().replaceAll(" ", "_") : this.getDefColumn() + n2;
                    if (cell != null) {
                        if (hashMap.containsKey(string)) {
                            hashMap.put((CallSite)((Object)string), (Integer)hashMap.get(string) + 1);
                            arrayList.add((CallSite)((Object)(string.toString() + hashMap.get(string))));
                            continue;
                        }
                        hashMap.put((CallSite)((Object)string), 1);
                        arrayList.add((CallSite)((Object)string));
                        continue;
                    }
                    arrayList.add((CallSite)((Object)(this.getDefColumn() + n2)));
                }
                this.m_headerRowColumnNames = arrayList.toArray(new String[arrayList.size()]);
            }
            return this.m_headerRowColumnNames;
        }
        return this.getDefaultColumnNames();
    }

    private Row getHeaderRow() {
        int n = this.dataFormat.getSkipRows();
        int n2 = this.dataFormat.isHeader() ? this.getFirstNonEmptyRowNumber(n) : n;
        return this.currentSheet.getRow(n2);
    }

    private Object[] getRow(int n) {
        Row row = this.currentSheet.getRow(n);
        int n2 = 0;
        String[] stringArray = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (row != null) {
            boolean bl = false;
            n2 = this.headerRow == null ? row.getLastCellNum() : this.headerRow.getLastCellNum();
            for (int i = 0; i < n2; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    arrayList.add(null);
                    continue;
                }
                Object object = this.Value(cell);
                if (object != null) {
                    arrayList.add(object);
                    bl = true;
                    continue;
                }
                arrayList.add(null);
            }
            stringArray = bl ? arrayList.toArray(new String[arrayList.size()]) : null;
        }
        return stringArray;
    }

    public boolean hasMoreRows() {
        return this.currentSheet != null && this.currentRow < this.currentSheet.getLastRowNum() + 1;
    }

    public String getType(int n) {
        return null;
    }

    public int getWidth(int n) {
        int n2;
        this.colwidths = this.sheetWidths.get(this.currentSheet) != null ? this.sheetWidths.get(this.currentSheet) : new HashMap<Integer, Integer>();
        if (this.colwidths.get(n) != null) {
            return this.colwidths.get(n);
        }
        int n3 = 0;
        Row row = null;
        int n4 = this.dataFormat.getSkipRows();
        for (int i = n2 = this.dataFormat.isHeader() ? this.getFirstNonEmptyDataRowNumber(n4) : n4; i == 0 || i < this.currentSheet.getLastRowNum() + 1; ++i) {
            row = this.currentSheet.getRow(i);
            int n5 = 1;
            if (row == null) continue;
            Cell cell = row.getCell(n);
            String string = "";
            if (cell != null) {
                switch (cell.getCellType()) {
                    case STRING: {
                        if (cell.getStringCellValue() == null) {
                            n5 = 0;
                            break;
                        }
                        string = cell.getStringCellValue();
                        n5 = string != null ? string.length() : 0;
                        break;
                    }
                    case BLANK: {
                        n5 = 0;
                        break;
                    }
                    case FORMULA: {
                        short s;
                        Double d;
                        CellValue cellValue = this._evaluator.evaluate(cell);
                        switch (cellValue.getCellType()) {
                            case BOOLEAN: {
                                n5 = 0;
                                break;
                            }
                            case NUMERIC: {
                                d = cellValue.getNumberValue();
                                string = DateUtil.isCellDateFormatted((Cell)cell) ? this.handleNumberValue(cell, d) : d.toString();
                                n5 = string.length();
                                s = cell.getCellStyle().getDataFormat();
                                if (s != 0 && s != 49 || !string.endsWith(".0")) break;
                                n5 -= 2;
                                break;
                            }
                            case STRING: {
                                if (cellValue.getStringValue() == null) {
                                    n5 = 0;
                                    break;
                                }
                                string = cellValue.getStringValue();
                                n5 = string != null ? string.length() : 0;
                                break;
                            }
                            case BLANK: {
                                n5 = 0;
                                break;
                            }
                            case ERROR: {
                                n5 = 0;
                            }
                        }
                        break;
                    }
                    case NUMERIC: {
                        Double d = cell.getNumericCellValue();
                        string = DateUtil.isCellDateFormatted((Cell)cell) ? this.handleNumberValue(cell, d) : d.toString();
                        n5 = string.length();
                        short s = cell.getCellStyle().getDataFormat();
                        if (s != 0 && s != 49 || !string.endsWith(".0")) break;
                        n5 -= 2;
                        break;
                    }
                    default: {
                        n5 = 0;
                    }
                }
            }
            if (n5 <= n3) continue;
            n3 = n5;
        }
        this.colwidths.put(n, n3);
        this.sheetWidths.put(this.currentSheet, this.colwidths);
        return n3;
    }

    public int getNosPages() {
        try {
            if (this._workbook == null) {
                throw new DataReaderException(Messages.getString("XLSReader.2"));
            }
        }
        catch (DataReaderException dataReaderException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dataReaderException.getStackTrace()[0].toString(), dataReaderException);
        }
        try {
            return this._workbook.getNumberOfSheets();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String[] getPageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._workbook.getNumberOfSheets(); ++i) {
            arrayList.add(this._workbook.getSheetName(i));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPageLabel() {
        return Messages.getString("XLSReader.3");
    }

    public Sheet getCurrentPage() {
        return this.currentSheet;
    }

    public void openFile(String string) throws DataReaderException {
        Workbook workbook = null;
        try {
            this.closeFile();
            this._xlsFileReader = new FileInputStream(string);
            workbook = this.newWorkbook(this._xlsFileReader);
            this.currentSheet = workbook.getSheetAt(0);
        }
        catch (DataReaderException dataReaderException) {
            this.closeFile();
            throw dataReaderException;
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw new DataReaderException(exception.getMessage());
        }
        this._workbook = workbook;
        this._evaluator = this._workbook.getCreationHelper().createFormulaEvaluator();
        this._fileName = string;
    }

    protected Workbook newWorkbook(FileInputStream fileInputStream) throws DataReaderException {
        try {
            return new HSSFWorkbook((InputStream)fileInputStream);
        }
        catch (Throwable throwable) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            throw new DataReaderException(throwable.getMessage());
        }
    }

    public void closeFile() {
        try {
            if (this._xlsFileReader != null) {
                this._xlsFileReader.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this._xlsFileReader = null;
        this._workbook = null;
    }

    public void start() throws DataReaderException {
        this.currentRow = 0;
        if (this._xlsFileReader == null) {
            this.openFile(this._fileName);
        }
    }

    private Object Value(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case STRING: {
                    return cell.getStringCellValue() == null ? "" : cell.getStringCellValue();
                }
                case BLANK: {
                    return null;
                }
                case FORMULA: {
                    CellValue cellValue = this._evaluator.evaluate(cell);
                    switch (cellValue.getCellType()) {
                        case BOOLEAN: {
                            if (cellValue.getBooleanValue()) {
                                return "true";
                            }
                            return "false";
                        }
                        case NUMERIC: {
                            return this.handleNumberValue(cell, cellValue.getNumberValue());
                        }
                        case STRING: {
                            return cellValue.getStringValue() == null ? "" : cellValue.getStringValue();
                        }
                        case BLANK: {
                            return "";
                        }
                        case ERROR: {
                            return "";
                        }
                    }
                }
                case NUMERIC: {
                    return this.handleNumberValue(cell, cell.getNumericCellValue());
                }
                case BOOLEAN: {
                    if (cell.getBooleanCellValue()) {
                        return "true";
                    }
                    return "false";
                }
            }
            return null;
        }
        return null;
    }

    private String handleNumberValue(Cell cell, double d) {
        Object object = "";
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            short s = cell.getCellStyle().getDataFormat();
            Date date = cell.getDateCellValue();
            DataFormat dataFormat = this._workbook.createDataFormat();
            String string = dataFormat.getFormat(s);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            String string2 = this.getJavaPatternFromXLSDateFormat(string);
            if (string.equals("m/d/yy")) {
                string2 = PATTERN_SHORT_DATE;
            }
            try {
                if (string2 == null || string2.isEmpty()) {
                    string2 = this.getDefaultJavaPattern(string);
                }
                simpleDateFormat.applyPattern(string2);
                object = simpleDateFormat.format(date);
            }
            catch (Exception exception) {
                try {
                    simpleDateFormat.applyPattern(this.getDefaultJavaPattern(string));
                    object = simpleDateFormat.format(date);
                }
                catch (Exception exception2) {
                    object = date.toString();
                }
            }
        } else {
            Double d2 = d;
            short s = cell.getCellStyle().getDataFormat();
            object = d2.toString();
            long l = d2.longValue();
            double d3 = d2 - (double)l;
            if ((s == 0 || s == 1 || s == 49) && d3 == 0.0) {
                object = "" + l;
                return object;
            }
            object = ((String)object).replace('.', _decimalSeparator);
        }
        return object;
    }

    private String getDefaultJavaPattern(String string) {
        if (string.contains("h")) {
            return PATTERN_TIMESTAMP;
        }
        if (string.contains("mmm")) {
            return PATTERN_LONG_DATE;
        }
        return PATTERN_SHORT_DATE;
    }

    private String getJavaPatternFromXLSDateFormat(String string) {
        String string2 = string.replace(";@", "");
        int n = string2.indexOf("]");
        if (n != -1) {
            string2 = string2.substring(n + 1, string2.length());
        }
        string2 = string2.replace("m", "M");
        string2 = string2.replace("MMMMM", "MMM");
        string2 = string2.replace(":MM", ":mm");
        string2 = string2.replace(":M", ":m");
        string2 = string2.replace("dddd", "EEEE");
        string2 = string2.replace("ddd", "EEE");
        string2 = string2.replace("AM/PM", "a");
        if (!(string2 = string2.replace("\\", "")).contains("a")) {
            string2 = string2.replace("hh", "HH");
            string2 = string2.replace("h", "HH");
        }
        return string2;
    }

    public void setPage(int n) throws DataReaderException {
        if (this._workbook == null) {
            this.openFile(this.getFileName());
        }
        this.currentSheet = this._workbook.getSheetAt(n);
    }

    public Object[] readline() {
        Object[] objectArray = this.getRow(this.currentRow);
        ++this.currentRow;
        return objectArray;
    }

    private int getFirstNonEmptyDataRowNumber(int n) {
        int n2 = this.getFirstNonEmptyRowNumber(n);
        if (n2 != -1 && this.dataFormat.isHeader()) {
            n2 = this.getFirstNonEmptyRowNumber(n2 + 1);
        }
        return n2;
    }

    private int getFirstNonEmptyRowNumber(int n) {
        Row row = null;
        int n2 = -1;
        for (int i = n; i == 0 || this.currentSheet != null && i <= this.currentSheet.getLastRowNum(); ++i) {
            if (this.currentSheet != null) {
                row = this.currentSheet.getRow(i);
            }
            if (row == null) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private Row getFirstNonEmptyRow() {
        Row row = null;
        for (int i = 0; (i == 0 || this.currentSheet != null && i < this.currentSheet.getLastRowNum()) && (row = this.currentSheet.getRow(i)) == null; ++i) {
        }
        return row;
    }

    public void detectColumnDefinitions(LoadFile loadFile, Locale locale) {
    }

    public boolean isOracleLoaderReadable() {
        return false;
    }

    public boolean isEncodingAllowed() {
        return false;
    }

    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    public boolean isHeaderLocationSupported() {
        return false;
    }

    public int getHeaderLocation() {
        return 0;
    }

    public void setHeaderLocation(int n) {
    }

    public boolean isLineTerminatorSupported() {
        return false;
    }

    public boolean isDelimiterSupported() {
        return false;
    }

    public boolean isEnclosuresSupported() {
        return false;
    }
}

