/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.search;

import java.io.Serializable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.controls.search.InputTreePanel;
import oracle.javatools.ui.checktree.TriStateNode;

public class PastLookup
implements Serializable {
    String connection;
    String name;
    List<String> notStandardOptions;

    public PastLookup(String string, String string2, List<String> list, ImageIcon imageIcon) {
        this.connection = string;
        this.name = string2;
        this.notStandardOptions = list;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        PastLookup pastLookup = (PastLookup)object;
        return pastLookup.name.equals(this.name) && pastLookup.connection.equals(this.connection);
    }

    public void setOptions(String string, TreeNode treeNode) {
        this.processNode(treeNode, this.notStandardOptions.contains(string));
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.setOptions(string + "." + i, treeNode.getChildAt(i));
        }
    }

    public void processNode(TreeNode treeNode, boolean bl) {
        if (!(treeNode instanceof TriStateNode)) {
            return;
        }
        if (bl) {
            ((TriStateNode)treeNode).setNodeState(TriStateNode.NodeState.YES);
        } else if (treeNode.isLeaf() || treeNode.toString().equals(InputTreePanel.ALL_SOURCE)) {
            ((TriStateNode)treeNode).setNodeState(TriStateNode.NodeState.NO);
        }
    }

    public String htmlOptions() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        Boolean bl = null;
        for (String string2 : this.notStandardOptions) {
            if (bl != null) {
                stringBuilder.append("&nbsp;&nbsp;<font color=" + (bl != false ? "black" : "gray") + " size=-2>");
                stringBuilder.append(this.nodeName(Integer.parseInt(string)));
                stringBuilder.append("</font>");
                bl = null;
            }
            String string3 = string2.substring(1);
            boolean bl2 = true;
            if (-1 < string3.indexOf(46)) {
                string3 = string3.substring(0, string3.indexOf(46));
                bl2 = false;
            }
            if (!string3.equals(string)) {
                bl = bl2;
            }
            string = string3;
        }
        return stringBuilder.toString();
    }

    private String nodeName(int n) {
        switch (n) {
            case 0: {
                return InputTreePanel.ALL_SCHEMAS;
            }
            case 1: {
                return InputTreePanel.ALL_OBJECTS;
            }
            case 2: {
                return InputTreePanel.COLUMNS;
            }
            case 3: {
                return InputTreePanel.ALL_ID_TYPES;
            }
            case 4: {
                return InputTreePanel.ALL_ID_USAGES;
            }
            case 5: {
                return InputTreePanel.ALL_SOURCE;
            }
        }
        return null;
    }
}

