/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.RaptorGridFilter;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.RSTCMMessages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.db.DBException;

public class RemoveGridFilter
extends GridHeaderContextMenuItem {
    private static RemoveGridFilter _instance = null;
    public static final String _cmdRemoveFilters = "cmdRemoveFilters";
    public static final int _cmdIdRemoveFilters = Ide.findOrCreateCmdID((String)"cmdRemoveFilters");
    private IdeAction _actionRemoveFilters;
    private JMenuItem _mi = null;

    private RemoveGridFilter() {
        this.initAction();
    }

    public static RemoveGridFilter getInstance() {
        if (_instance == null) {
            _instance = new RemoveGridFilter();
        }
        return _instance;
    }

    private void initAction() {
        if (this._actionRemoveFilters == null) {
            this._actionRemoveFilters = this.createAction(_cmdIdRemoveFilters, RSTCMMessages.getString("RemoveGridFilter.0"), null);
        }
    }

    protected boolean canShow(ContextMenu contextMenu) {
        ResultSetTableModel resultSetTableModel;
        List<RaptorGridFilter> list;
        AbstractRaptorGridModel abstractRaptorGridModel;
        return this._table != null && (abstractRaptorGridModel = this._table.getGridModel()) != null && abstractRaptorGridModel instanceof ResultSetTableModel && (list = (resultSetTableModel = (ResultSetTableModel)abstractRaptorGridModel).getAllFilters()) != null && list.size() > 0;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        contextMenu.add((Component)this._mi);
    }

    private void createJMenuItem(ContextMenu contextMenu) {
        if (this._mi == null) {
            this._mi = contextMenu.createMenuItem((ToggleAction)this._actionRemoveFilters);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        ResultSetTableModel resultSetTableModel;
        List<RaptorGridFilter> list;
        AbstractRaptorGridModel abstractRaptorGridModel;
        if (ideAction.getCommandId() == _cmdIdRemoveFilters && this._table != null && (abstractRaptorGridModel = this._table.getGridModel()) != null && abstractRaptorGridModel instanceof ResultSetTableModel && (list = (resultSetTableModel = (ResultSetTableModel)abstractRaptorGridModel).getAllFilters()) != null && list.size() > 0) {
            resultSetTableModel.removeAllFilters();
            try {
                this._table.clearSelection();
                resultSetTableModel.refresh();
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (this._table != null && this._table instanceof ResultSetTable) {
            String string = ((ResultSetTable)this._table).getGridModel().getConnectionName();
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(string, false);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (connection == null) {
                ideAction.setEnabled(false);
            } else {
                ideAction.setEnabled(true);
            }
        }
        return true;
    }

    public JMenuItem[] getJMenuItems(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        return new JMenuItem[]{this._mi};
    }
}

