/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.RSTMSql;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.util.Logger;
import oracle.javatools.db.DBException;

public class OracleERSTM
extends EditableResultSetTableModel {
    private static final long serialVersionUID = 1L;
    protected boolean _isExternalTable;
    private boolean _isView;
    private boolean _isEditableView = true;
    public static final String NO_DATA_INTEGRITY_COLS = "NO_DATA_INTEGRITY_COLS";
    private boolean _initialized;
    protected static final String EDITABLE_VIEW_COLS_SQL = "editable_view_cols";
    protected static final String EDITABLE_TABLE_COLS_SQL = "editable_table_cols";
    protected static final String INSERTABLE_VIEW_COLS_SQL = "insertable_view_cols";
    private List<String> _insertableColNames;

    @Override
    protected void init(String string, String string2, List<?> list, Map<String, ?> map, DBObject dBObject) {
        super.init(string, string2, list, map, dBObject);
        this.initialize(false);
    }

    private void initialize(boolean bl) {
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (DBException dBException) {
            Logger.ignore(this.getClass(), (Throwable)dBException);
        }
        if (connection != null) {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            Version version = RaptorVersionTracker.getDbVersion(connection);
            Version version2 = new Version("8.0");
            Version version3 = new Version("10.2");
            if (version2.compareTo(version) < 0) {
                this._isExternalTable = this.isExternalTable();
            }
            if (this._queryObj == null && (this.getBindMap() == null || this.getBindMap() != null && !this.getBindMap().containsKey("IDPROJECT"))) {
                this._addRowScnColumn = Preference_USE_SCN;
                if (this._isExternalTable) {
                    this._addRowIdColumn = false;
                    this._addRowScnColumn = false;
                }
                if (version3.compareTo(version) > 0) {
                    this._addRowScnColumn = false;
                }
                if (this._dbObject != null) {
                    if ("VIEW".equals(this._dbObject.getObjectType())) {
                        this._isView = true;
                        this._addRowScnColumn = false;
                        String string = "select   NULLIF((select count(1) from all_updatable_columns where owner = '%s' and table_name = '%s' and (insertable = 'YES' or updatable = 'YES')),0),  (select rowid from %s.%s where rownum = 1) from dual";
                        String string2 = String.format(string, this.removeDoubleQuote(this._schemaName), this.removeDoubleQuote(this._tablename), DBUtil.addDoubleQuote((String)this.removeDoubleQuote(this._schemaName)), DBUtil.addDoubleQuote((String)this.removeDoubleQuote(this._tablename)));
                        String string3 = dBUtil.executeOracleReturnOneCol(string2, (Map)null);
                        SQLException sQLException = dBUtil.getLastException();
                        if (sQLException != null && 1446 != sQLException.getErrorCode()) {
                            Logger.severe(this.getClass(), (Throwable)sQLException);
                        }
                        this._addRowIdColumn = this._isEditableView = null != string3;
                    }
                    if ("HIERARCHY".equals(this._dbObject.getObjectType())) {
                        this._addRowScnColumn = false;
                        this._addRowIdColumn = false;
                        this._editableColNames = Collections.emptyList();
                        this._insertableColNames = Collections.emptyList();
                    }
                }
            } else {
                this._addRowIdColumn = false;
                this._addRowScnColumn = false;
            }
            this.getEditableColumnNames();
        }
        if (this._bindMap != null && this._bindMap.containsKey(NO_DATA_INTEGRITY_COLS)) {
            this._addRowIdColumn = false;
            this._addRowScnColumn = false;
        }
        this._initialized = bl;
    }

    protected boolean isExternalTable() {
        String string = "select   NULLIF((select count(1) from all_external_tables where owner = '%s' and table_name = '%s'),0)from dual";
        String string2 = String.format(string, this.removeDoubleQuote(this._schemaName), this.removeDoubleQuote(this._tablename));
        DBUtil dBUtil = DBUtil.getInstance((String)this.getConnectionName());
        String string3 = dBUtil.executeOracleReturnOneCol(string2, (Map)null);
        SQLException sQLException = dBUtil.getLastException();
        if (sQLException != null) {
            Logger.severe(this.getClass(), (Throwable)sQLException);
        }
        return string3 != null;
    }

    @Override
    protected ResultSet openResultSet() throws SQLException, DBException {
        if (!this._initialized) {
            this.initialize(true);
        }
        this._rs = super.openResultSet();
        return this._rs;
    }

    private String removeDoubleQuote(String string) {
        String string2 = string;
        if (string != null && string.startsWith("\"")) {
            string2 = string.substring(1, string.length() - 1);
        }
        return string2;
    }

    @Override
    public boolean isCellEditorEditable(int n, int n2) {
        if (this._isView && this.getRowModel(n).isNew()) {
            return this.getInsertableColumnNames().contains(this.getColumnName(n2));
        }
        return !this._isExternalTable && super.isCellEditorEditable(n, n2);
    }

    private List<String> getEditableColumnNames() {
        if (null == this._editableColNames) {
            String string = this._isView ? EDITABLE_VIEW_COLS_SQL : EDITABLE_TABLE_COLS_SQL;
            this._editableColNames = this.getColumnNames(string, this._editableColNames);
        }
        return this._editableColNames;
    }

    protected Query getGridQuery(String string, Connection connection) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(this.getClass().getClassLoader(), "/oracle/dbtools/raptor/controls/grid/GridQueries.xml"));
        return queryXMLSupport.getQuery(string, connection);
    }

    private List<String> getInsertableColumnNames() {
        if (null == this._insertableColNames) {
            this._insertableColNames = this.getColumnNames(INSERTABLE_VIEW_COLS_SQL, this._insertableColNames);
        }
        return this._insertableColNames;
    }

    private List<String> getColumnNames(String string, List<String> list) {
        if (list == null) {
            final ArrayList<String> arrayList = new ArrayList<String>();
            try {
                final Connection connection = this.getConnection();
                Query query = this.getGriXMLQuery(string, connection);
                final String string2 = query.getSql();
                LockManager.executeWithLock((Connection)connection, (Callable)new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        ResultSet resultSet = null;
                        try {
                            if (OracleERSTM.this._dbObject != null) {
                                resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string2, OracleERSTM.this.getDBObject().getDictionary());
                            } else if (OracleERSTM.this._tablename != null && OracleERSTM.this._schemaName != null) {
                                HashMap<String, String> hashMap = new HashMap<String, String>();
                                String string = OracleERSTM.this._tablename.toUpperCase();
                                String string22 = OracleERSTM.this._schemaName.toUpperCase();
                                hashMap.put("OBJECT_NAME", string);
                                hashMap.put("OBJECT_OWNER", string22);
                                resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string2, hashMap);
                            }
                            if (resultSet != null) {
                                while (resultSet.next()) {
                                    arrayList.add(resultSet.getString(1));
                                }
                            }
                            DBUtil.closeResultSet((ResultSet)resultSet);
                        }
                        catch (SQLException sQLException) {
                            Logger.severe(this.getClass(), (Throwable)sQLException);
                        }
                        finally {
                            DBUtil.closeResultSet(resultSet);
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                Logger.severe(this.getClass(), (Throwable)exception);
            }
            list = arrayList;
        }
        return list;
    }

    @Override
    public boolean isEditable() {
        return this.isOracle() && !this._isExternalTable && this._isEditableView && !this.getEditableColumnNames().isEmpty();
    }

    @Override
    public void closeModel() {
        this._isEditableView = true;
        super.closeModel();
        this._initialized = false;
    }

    @Override
    public String getModifiedSql() {
        return this.getModifiedSql(false);
    }

    public String getModifiedSql(boolean bl) {
        ArrayList<TabCol.Column> arrayList;
        String[] stringArray;
        Object object;
        StringBuilder stringBuilder;
        block20: {
            if (this._sql == null) {
                return null;
            }
            stringBuilder = new StringBuilder();
            if (bl && this._expandedSql == null) {
                try {
                    if (!Connections.getInstance().isOracle(this.getConnectionName())) break block20;
                    object = new TabCol(this.getConnectionName());
                    this._rstmsql.setTableName(this._tablename);
                    stringArray = null;
                    if (this._addRowIdColumn && this._addRowScnColumn) {
                        stringArray = new String[]{(String)this.DATA_INTEGRITY_COLS.get(0), (String)this.DATA_INTEGRITY_COLS.get(1)};
                    } else if (this._addRowIdColumn) {
                        stringArray = new String[]{(String)this.DATA_INTEGRITY_COLS.get(0)};
                    } else if (this._addRowIdColumn) {
                        stringArray = new String[]{(String)this.DATA_INTEGRITY_COLS.get(1)};
                    }
                    if (stringArray != null) {
                        arrayList = ((TabCol)object).fetchColumns(this._rstmsql.getModifiedSql(), false);
                        stringBuilder = new StringBuilder(((TabCol)object).disambiguate(arrayList, stringArray));
                        this._expandedSql = stringBuilder.toString();
                        break block20;
                    }
                    stringBuilder.append(this._rstmsql.getModifiedSql());
                }
                catch (Exception exception) {
                    stringBuilder.append(this._rstmsql.getModifiedSql());
                }
            } else if (this._expandedSql != null) {
                stringBuilder.append(this._rstmsql.getModifiedSql(this._expandedSql));
            } else {
                stringBuilder.append(this._rstmsql.getModifiedSql());
            }
        }
        object = this.getSortString();
        if (this._autoApplyPersistedSort && object == null && this._rs == null) {
            String string;
            stringArray = RaptorGridPersistedSettings.loadPersistedSettings((String)this.getModelUniqueName());
            arrayList = null;
            if (stringArray != null && (arrayList = stringArray.getSortClauses()) != null && arrayList.size() > 0 && (string = (String)arrayList.get(0)) != null && !string.equals("")) {
                object = string;
            }
        }
        if (object != null && ((String)object).trim().length() > 0) {
            if (this.hasDuplicateColumnNames()) {
                try {
                    if (Connections.getInstance().isOracle(this.getConnectionName())) {
                        stringArray = new TabCol(this.getConnectionName());
                        arrayList = stringArray.fetchColumns(stringBuilder.toString());
                        stringBuilder = new StringBuilder(stringArray.disambiguate(arrayList));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append((String)object);
        }
        stringArray = stringBuilder.toString();
        return OracleERSTM.NO_PARALLEL(RSTMSql.sanitizeSql((String)stringArray));
    }

    private static String NO_PARALLEL(String string) {
        Object object;
        List list = LexerToken.parse((String)string);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            object = (LexerToken)iterator.next();
            if (!((LexerToken)object).content.toUpperCase().equals("SELECT")) {
                return string;
            }
        }
        iterator = new StringBuilder("/*+ ");
        object = SqlRecognizer.getTables((String)string);
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            int n;
            String string2 = (String)iterator2.next();
            int n2 = string2.lastIndexOf(32);
            if (0 < n2) {
                string2 = string2.substring(n2 + 1);
            }
            if (0 < (n = string2.lastIndexOf(46))) {
                string2 = string2.substring(n + 1);
            }
            ((StringBuilder)((Object)iterator)).append("no_parallel(" + string2 + ") ");
        }
        ((StringBuilder)((Object)iterator)).append("*/");
        return string.substring(0, "SELECT".length()) + " " + ((StringBuilder)((Object)iterator)).toString() + " " + string.substring("SELECT".length());
    }

    @Override
    protected PreparedStatement prepareStatement() throws SQLException, DBException {
        String string = this.getModifiedSql(true);
        PreparedStatement preparedStatement = null;
        if (ModelUtil.hasLength((String)string)) {
            preparedStatement = this.getConnection().prepareStatement(string);
            preparedStatement.setEscapeProcessing(false);
            if (this.getBindList() != null && this.getBindList().size() > 0) {
                DBUtil.bind((PreparedStatement)preparedStatement, this.getBindList());
            } else if (this.getBindMap() != null && this.getBindMap().size() > 0) {
                DBUtil.bind((String)string, (PreparedStatement)preparedStatement, this.getBindMap());
            }
        }
        return preparedStatement;
    }

    @Override
    protected boolean isReturningRowidAllowed() {
        if (this._isView) {
            String string = "select   NULLIF((select count(1) from all_triggers where table_owner = '%s' and table_name = '%s' and trigger_type = 'INSTEAD OF' and triggering_event = 'INSERT' and status = 'ENABLED'),0) from dual";
            String string2 = String.format(string, this.removeDoubleQuote(this._schemaName), this.removeDoubleQuote(this._tablename));
            String string3 = DBUtil.getInstance((String)this.getConnectionName()).executeOracleReturnOneCol(string2, (Map)null);
            return null == string3;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        String string = "select \n    e.LAST_NAME , DEPARTMENT_NAME\nfrom EMPLOYEES e , DEPARTMENTS \nwhere  e.DEPARTMENT_ID = DEPARTMENT_ID;";
        System.out.println(OracleERSTM.NO_PARALLEL(RSTMSql.sanitizeSql(string)));
    }
}

