/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public class ERSTModelHook {
    private static Logger LOGGER = Logger.getLogger(ERSTModelHook.class.getName());
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-erstmodel";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-erstmodel", "sqldev-erstmodel-hook");
    public static final String HOOKELEMENTNAME = "provider";
    public static final String DRIVERCLASS = "driverClass";
    private static Map<String, MetaClass<? extends EditableResultSetTableModel>> s_provClassNames = new HashMap<String, MetaClass<? extends EditableResultSetTableModel>>();
    private static HashStructureHookListener s_listener;

    private static final Listener createListener() {
        return new Listener(){};
    }

    private static synchronized void initListener() {
        if (s_listener == null) {
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            s_listener = ERSTModelHook.createListener();
            hashStructureHook.addHashStructureHookListener(s_listener);
        }
    }

    public static EditableResultSetTableModel getRSTModel(String string) {
        ERSTModelHook.initListener();
        EditableResultSetTableModel editableResultSetTableModel = null;
        MetaClass<? extends EditableResultSetTableModel> metaClass = s_provClassNames.get(string);
        if (metaClass != null) {
            try {
                editableResultSetTableModel = (EditableResultSetTableModel)metaClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                LOGGER.log(Level.SEVERE, instantiationException.getLocalizedMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.SEVERE, illegalAccessException.getLocalizedMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.SEVERE, classNotFoundException.getLocalizedMessage(), classNotFoundException);
            }
        }
        return editableResultSetTableModel;
    }

    private static void registerERSTModelImpl(String string, MetaClass<? extends EditableResultSetTableModel> metaClass) {
        if (string == null || !ModelUtil.hasLength((String)string.trim())) {
            LOGGER.log(Level.SEVERE, RSTableMessages.getString("RSTModelHook.2"));
            return;
        }
        if (metaClass == null) {
            LOGGER.log(Level.SEVERE, RSTableMessages.getString("RSTModelHook.0"));
            return;
        }
        string = string.trim();
        s_provClassNames.put(string, metaClass);
    }

    protected static class Listener
    implements HashStructureHookListener {
        protected Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processModels(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processModels(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processModels(HashStructure hashStructure) {
            List list = hashStructure.getAsList(ERSTModelHook.HOOKELEMENTNAME);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    String string = hashStructure2.getString(ERSTModelHook.DRIVERCLASS);
                    MetaClass metaClass = LazyClassAdapter.getInstance((HashStructure)hashStructure2).getMetaClass("#text");
                    ERSTModelHook.registerERSTModelImpl(string, (MetaClass<? extends EditableResultSetTableModel>)metaClass);
                }
            }
        }
    }
}

