/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.html;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.DisplaySimpleGuage;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.controls.display.html.HtmlGenerationContext;
import oracle.dbtools.raptor.controls.display.html.IHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.ResourceGenerationContext;
import oracle.dss.gauge.Gauge;

public class GaugeHtmlGenerator
implements IHtmlGenerator {
    private DisplayModel model;
    private DisplayPanel displayPanel;
    private Gauge gauge;
    private Writer writer;
    private String gaugeImageName;

    @Override
    public void generateStaticResources(ResourceGenerationContext resourceGenerationContext) {
    }

    @Override
    public void generateHtml(HtmlGenerationContext htmlGenerationContext) {
        this.writer = htmlGenerationContext.writer();
        this.model = htmlGenerationContext.model();
        this.model.setConnName(htmlGenerationContext.connectionName());
        this.displayPanel = new DisplayPanel(htmlGenerationContext.model());
        DisplaySimpleGuage displaySimpleGuage = (DisplaySimpleGuage)this.displayPanel.getMainUI();
        displaySimpleGuage.setErrorHandler(htmlGenerationContext.errorHandler());
        displaySimpleGuage.disableRefreshInTask();
        displaySimpleGuage.appendBindMap(htmlGenerationContext.binds());
        displaySimpleGuage.refresh(htmlGenerationContext.connection());
        if (!htmlGenerationContext.errorHandler().hasErrors()) {
            this.gauge = displaySimpleGuage.getGauge();
            this.gaugeImageName = "guage." + htmlGenerationContext.id() + ".png";
            try {
                this.saveImage(htmlGenerationContext);
                this.displayPanel.close();
                this.writer.write("<img src=\"" + htmlGenerationContext.resourcePath(this.gaugeImageName) + "\"/>\n");
            }
            catch (Exception exception) {
                htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.OTHER, exception);
            }
        }
    }

    private void saveImage(HtmlGenerationContext htmlGenerationContext) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        this.gauge.setImageSize(new Dimension(1000, 333));
        this.gauge.exportToPNG((OutputStream)bufferedOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        htmlGenerationContext.addResource(this.gaugeImageName, byteArrayInputStream);
    }
}

