/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.BitSet;
import java.util.Map;
import oracle.dbtools.raptor.controls.display.chart.Alignment;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartFont;
import oracle.dbtools.raptor.controls.display.chart.ChartFontArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.EnumArchiver;
import oracle.dbtools.raptor.controls.display.chart.LegendLocation;
import oracle.dbtools.raptor.controls.display.chart.PropertyDef;
import oracle.dbtools.raptor.controls.display.chart.PropertyGroup;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.TransparentColor;
import oracle.dbtools.raptor.controls.display.chart.TransparentColorArchiver;
import oracle.dss.graph.Graph;
import oracle.dss.graph.LegendArea;
import oracle.dss.graph.LegendText;

class LegendProperties
extends PropertyGroup {
    LegendProperties() {
    }

    @Override
    void register(Map<PropertyType, PropertyDef> map) {
        BitSet bitSet = ChartType.all();
        map.put(PropertyType.LEGEND, new PropertyDef<Boolean>(bitSet){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getLegendArea().isVisible();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getLegendArea().setVisible(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet2 = ChartType.all();
        map.put(PropertyType.LEGEND_LOCATION, new PropertyDef<LegendLocation>(bitSet2){
            private EnumArchiver<LegendLocation> archiver;
            {
                this.archiver = new EnumArchiver(LegendLocation.class, (Enum[])LegendLocation.values());
            }

            @Override
            LegendLocation getGraphValue(Graph graph) {
                LegendArea legendArea = graph.getLegendArea();
                return LegendLocation.get(legendArea.getAutomaticPlacement() == 1 ? -1 : legendArea.getPosition());
            }

            @Override
            void setGraphValue(Graph graph, LegendLocation legendLocation) {
                LegendArea legendArea = graph.getLegendArea();
                if (legendLocation.automatic()) {
                    legendArea.setAutomaticPlacement(1);
                } else {
                    legendArea.setAutomaticPlacement(0);
                    legendArea.setPosition(legendLocation.graphConstant());
                }
            }

            @Override
            Archiver<LegendLocation> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet3 = ChartType.all();
        map.put(PropertyType.LEGEND_BACKGROUND_COLOR, new PropertyDef<TransparentColor>(bitSet3){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.BACKGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                LegendArea legendArea = graph.getLegendArea();
                return new TransparentColor(legendArea.isFillTransparent(), legendArea.getFillColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                LegendArea legendArea = graph.getLegendArea();
                legendArea.setFillTransparent(transparentColor.transparent().booleanValue());
                legendArea.setFillColor(transparentColor.color());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet4 = ChartType.all();
        map.put(PropertyType.LEGEND_BORDER_COLOR, new PropertyDef<TransparentColor>(bitSet4){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FOREGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                LegendArea legendArea = graph.getLegendArea();
                return new TransparentColor(legendArea.isBorderTransparent(), legendArea.getBorderColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                LegendArea legendArea = graph.getLegendArea();
                legendArea.setBorderTransparent(transparentColor.transparent().booleanValue());
                legendArea.setBorderColor(transparentColor.color());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet5 = ChartType.all();
        map.put(PropertyType.LEGEND_ALIGNMENT, new PropertyDef<Alignment>(bitSet5){
            private EnumArchiver<Alignment> archiver;
            {
                this.archiver = new EnumArchiver(Alignment.class, (Enum[])Alignment.values());
            }

            @Override
            Alignment getGraphValue(Graph graph) {
                LegendText legendText = graph.getLegendText();
                return Alignment.get(legendText.getHorizontalAlignment());
            }

            @Override
            void setGraphValue(Graph graph, Alignment alignment) {
                LegendText legendText = graph.getLegendText();
                legendText.setHorizontalAlignment(alignment.swingConstant());
            }

            @Override
            Archiver<Alignment> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet6 = ChartType.all();
        map.put(PropertyType.LEGEND_FONT, new PropertyDef<ChartFont>(bitSet6){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getLegendText().getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, graph.getLegendText().getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
    }
}

