/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.List;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerImpl;
import oracle.dbtools.raptor.controls.display.chart.ListArchiver;

abstract class EnumListArchiver<T extends Enum<T>>
extends ListArchiver<T> {
    private Class<T> enumType;

    EnumListArchiver(Class<T> clazz) {
        this.enumType = clazz;
    }

    @Override
    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<T> list) {
        for (Enum enum_ : list) {
            if (enum_.getClass().equals(this.enumType)) continue;
            throw new ClassCastException();
        }
    }

    @Override
    T itemFromRep(String string) {
        return Enum.valueOf(this.enumType, string);
    }

    @Override
    String repFromItem(T t) {
        return ((Enum)t).toString();
    }

    @Override
    Class primitiveClass() {
        return this.enumType;
    }

    @Override
    abstract Object getDefaultItem();
}

