/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.display.chart.AbstractPropertyPanel;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.ChartEditorPanel;
import oracle.dbtools.raptor.controls.display.chart.DataMapPanel;
import oracle.dbtools.raptor.controls.display.chart.DataSourcePanel;
import oracle.dbtools.raptor.controls.display.chart.ManagerAdapter;

class DataPanel
extends AbstractPropertyPanel {
    private ChartEditorPanel chartEditorPanel;
    private DataSourcePanel dataSourcePanel;
    private DataMapPanel dataMapPanel;

    DataPanel(ChartEditorPanel chartEditorPanel) {
        super(chartEditorPanel.propertyManager(), 4);
        this.chartEditorPanel = chartEditorPanel;
        this.dataSourcePanel = new DataSourcePanel(this);
        this.addPanel(this.dataSourcePanel, 1, 0, 3, ChartArb.getString("PREVIEW_LABEL"));
        this.addDivider(1);
        this.dataMapPanel = new DataMapPanel(this);
        this.addPanel(this.dataMapPanel, 2, 0, 3, ChartArb.getString("MAPPING_LABEL"));
        this.enableChildPanels();
        this.propertyManager.addManagerListener(new ManagerAdapter(){

            @Override
            public void onSetDbName() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataPanel.this.enableChildPanels();
                    }
                });
            }
        });
    }

    ChartEditorPanel chartEditorPanel() {
        return this.chartEditorPanel;
    }

    void clearLiveDataCheck() {
        this.dataSourcePanel.clearLiveDataCheck();
    }

    private void enableChildPanels() {
        String string = this.propertyManager.dbName();
        boolean bl = string != null && !string.equals("");
        this.dataMapPanel.enablePanel(bl);
        this.dataSourcePanel.enablePanel(bl);
    }
}

