/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.controls.display.DisRegObject;
import oracle.dbtools.raptor.controls.display.DisplayChartDetails;
import oracle.dbtools.raptor.controls.display.DisplayCodeEditor;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.DisplayEditableResultTable;
import oracle.dbtools.raptor.controls.display.DisplayGaugeDetails;
import oracle.dbtools.raptor.controls.display.DisplayPLSQL;
import oracle.dbtools.raptor.controls.display.DisplayResultTable;
import oracle.dbtools.raptor.controls.display.DisplayScript;
import oracle.dbtools.raptor.controls.display.DisplaySimpleChart;
import oracle.dbtools.raptor.controls.display.DisplaySimpleGuage;
import oracle.dbtools.raptor.controls.display.DisplayTableDetails;
import oracle.dbtools.raptor.controls.display.DisplayTaskScript;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;
import oracle.dbtools.raptor.controls.display.html.ChartHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.CodeHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.DocHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.GaugeHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.IHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.PLSQLHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.ScriptHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.TableHtmlGenerator;
import oracle.dbtools.raptor.extract.ui.panels.DisplayDataGizmo;

public class DisplayRegistry {
    private static Map<String, DisRegObject> _registry = new HashMap<String, DisRegObject>();

    public static synchronized void registerDisplay(String string, Class<? extends IDisplay> clazz) {
        if (!IDisplay.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IDisplay");
        }
        DisRegObject disRegObject = new DisRegObject(clazz);
        _registry.put(string, disRegObject);
    }

    public static synchronized void registerDisplay(String string, Class<? extends IDisplay> clazz, Class<? extends IDisplayDetail> clazz2, Boolean bl) {
        if (IDisplay.class.isAssignableFrom(clazz)) {
            if (clazz2 != null && !IDisplayDetail.class.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("Detail must be instance of IDisplayDetail");
            }
        } else {
            throw new IllegalArgumentException("Clazz must be instance of IDisplay");
        }
        DisRegObject disRegObject = new DisRegObject(clazz, clazz2, bl);
        _registry.put(string, disRegObject);
    }

    public static synchronized void registerDisplay(String string, Class<? extends IDisplay> clazz, Class<? extends IDisplayDetail> clazz2, Boolean bl, Boolean bl2) {
        if (IDisplay.class.isAssignableFrom(clazz)) {
            if (clazz2 != null && !IDisplayDetail.class.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("Detail must be instance of IDisplayDetail");
            }
        } else {
            throw new IllegalArgumentException("Clazz must be instance of IDisplay");
        }
        DisRegObject disRegObject = new DisRegObject(clazz, clazz2, bl, bl2);
        _registry.put(string, disRegObject);
    }

    public static synchronized void registerDisplay(String string, DisRegObject disRegObject) {
        _registry.put(string, disRegObject);
    }

    public static synchronized void unregisterDisplay(String string) {
        _registry.remove(string);
    }

    public static synchronized IDisplay getInstanceFor(String string) throws Exception {
        if (_registry.get(string) != null) {
            return _registry.get(string).getClazz().newInstance();
        }
        return _registry.get("Table").getClazz().newInstance();
    }

    public static synchronized Boolean hasDetails(String string) {
        if (_registry.get(string) != null && _registry.get(string).getEditor() != null) {
            return true;
        }
        return false;
    }

    public static synchronized Boolean allowChildren(String string) throws Exception {
        return _registry.get(string).childAllowed();
    }

    public static synchronized IDisplayDetail getDetailPanel(String string) throws Exception {
        if (_registry.get(string) != null) {
            return _registry.get(string).getEditor().newInstance();
        }
        return _registry.get("Table").getEditor().newInstance();
    }

    public static synchronized IHtmlGenerator getHtmlGenerator(String string) throws Exception {
        if (_registry.get(string) != null) {
            return _registry.get(string).getHtmlGenerator().newInstance();
        }
        return _registry.get("Table").getHtmlGenerator().newInstance();
    }

    public static synchronized ArrayList<String> getStylesAllowChildren() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            if (!_registry.get(string).childAllowed().booleanValue()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static synchronized ArrayList<String> getStylesNoChildren() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            if (_registry.get(string).childAllowed().booleanValue()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static synchronized ArrayList<String> getStyles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            if (_registry.get(string).isPrivate().booleanValue()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static ArrayList<String> getNLSStyles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DisplayConstants.REPORT_STYLES rEPORT_STYLES : DisplayConstants.REPORT_STYLES.values()) {
            arrayList.add(rEPORT_STYLES.getNLSName());
        }
        return arrayList;
    }

    public static String getNLSStyle(String string) {
        String string2 = string.toUpperCase().replace("-", "_");
        String string3 = null;
        DisplayConstants.REPORT_STYLES rEPORT_STYLES = DisplayConstants.REPORT_STYLES.valueOf(string2);
        try {
            string3 = rEPORT_STYLES.getNLSName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    public static String getStyleType(int n) {
        String string = DisplayConstants.REPORT_STYLES.values()[n].getType();
        return string;
    }

    static {
        _registry.put("Table", new DisRegObject(DisplayResultTable.class, DisplayTableDetails.class, TableHtmlGenerator.class, (Boolean)true));
        _registry.put("Code", new DisRegObject(DisplayCodeEditor.class, null, CodeHtmlGenerator.class, (Boolean)false));
        _registry.put("Chart", new DisRegObject(DisplaySimpleChart.class, DisplayChartDetails.class, ChartHtmlGenerator.class, (Boolean)true));
        _registry.put("Gauge", new DisRegObject(DisplaySimpleGuage.class, DisplayGaugeDetails.class, GaugeHtmlGenerator.class, (Boolean)false));
        _registry.put("plsql-dbms_output", new DisRegObject(DisplayPLSQL.class, null, PLSQLHtmlGenerator.class, (Boolean)false));
        _registry.put("Script", new DisRegObject(DisplayScript.class, null, ScriptHtmlGenerator.class, (Boolean)false));
        _registry.put("TaskScript", new DisRegObject(DisplayTaskScript.class, null, ScriptHtmlGenerator.class, (Boolean)false));
        _registry.put("DataGizmo", new DisRegObject(DisplayDataGizmo.class, null, (Class<? extends IHtmlGenerator>)null, (Boolean)false));
        _registry.put("EditableTable", new DisRegObject(DisplayEditableResultTable.class, null, TableHtmlGenerator.class, false, true));
        _registry.put("Doc", new DisRegObject(null, null, DocHtmlGenerator.class, false, true));
    }
}

