/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.connections.AuthenticationPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.connections.OracleAdvancedOptions;
import oracle.dbtools.raptor.connections.OracleAuthenticationPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.connections.OracleOptionsPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;

public final class OracleConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = 530419491097270959L;
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.OracleDriver";
    public static String OCI_URL = "jdbc:oracle:oci8:@";
    public static final String OS_AUTHENTICATION = "OS_AUTHENTICATION";
    public static final String KERBEROS_AUTHENTICATION = "KERBEROS_AUTHENTICATION";
    private JPanel mPnlDetails;
    private JTabbedPane mPnlTabs;
    private CardLayout layDetails;
    public static final String ORACLE_CONNECTION_PANEL_TYPE = "OracleConnectionType";
    public static final String THIN_URL = "jdbc:oracle:thin:@";
    private JComboBox<OracleConnectionType> cbxAuthType = new JComboBox();
    private JLabel lblAuthType = new JLabel();
    private Map<OracleConnectionType, OracleConnectionTypePanel> mPanels = new HashMap<OracleConnectionType, OracleConnectionTypePanel>();
    private List<OracleOptionsPanel> optionPanels = new ArrayList<OracleOptionsPanel>();

    public Component getComponent() {
        this.initUI();
        return this;
    }

    @Override
    public void initUI() {
        if (this.layDetails == null) {
            this.setLayout(new GridBagLayout());
            Object object = LayoutControl.GBC.createPanel();
            ResourceUtils.resLabel((JLabel)this.lblAuthType, this.cbxAuthType, (String)ConnectionDialogArb.getString("CONNECTION_TYPE"));
            ((Container)object).add((Component)this.lblAuthType, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            ((Container)object).add(this.cbxAuthType, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X));
            ((Container)object).add(Box.createGlue(), LayoutControl.GBC.gbc(2, 0, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            this.add((Component)object, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X));
            this.mPnlTabs = new JTabbedPane();
            this.mPnlTabs.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
            this.add(this.mPnlTabs, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
            this.layDetails = new CardLayout(0, 0);
            this.mPnlDetails = new JPanel(this.layDetails);
            for (OracleConnectionTypePanel oracleConnectionTypePanel : OracleConnectionType.getConnectionPanels()) {
                oracleConnectionTypePanel.setOwner(this);
                oracleConnectionTypePanel.setDefaultPrompts();
                OracleConnectionType oracleConnectionType = oracleConnectionTypePanel.getConnectionType();
                this.mPanels.put(oracleConnectionType, oracleConnectionTypePanel);
                this.mPnlDetails.add(oracleConnectionTypePanel.getPanel(), oracleConnectionType.name());
                this.cbxAuthType.addItem(oracleConnectionType);
            }
            this.mPnlTabs.addTab(ConnectionDialogArb.getString("ORACLE_DETAILS_TAB"), LayoutControl.GBC.createTabPanel(this.mPnlDetails));
            object = new OracleAdvancedOptions();
            this.optionPanels.add((OracleOptionsPanel)object);
            this.mPnlTabs.addTab(((OracleOptionsPanel)object).getLabel(), LayoutControl.GBC.createTabPanel(((OracleOptionsPanel)object).getPanel()));
            this.cbxAuthType.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.togglePanels();
                }
            });
        }
    }

    private void togglePanels() {
        OracleConnectionType oracleConnectionType = (OracleConnectionType)this.cbxAuthType.getSelectedItem();
        if (oracleConnectionType != null) {
            Object object;
            Object object2;
            this.layDetails.show(this.mPnlDetails, oracleConnectionType.name());
            if (this.optionPanels.size() > 1) {
                object2 = this.optionPanels.listIterator(1);
                while (object2.hasNext()) {
                    object = (OracleOptionsPanel)object2.next();
                    this.mPnlTabs.remove(((OracleOptionsPanel)object).getPanel());
                    object2.remove();
                }
            }
            object2 = this.mPanels.get(oracleConnectionType);
            object = object2.getAdditionalOptionsPanels();
            if (this.optionPanels != null) {
                for (Object object3 : object) {
                    this.optionPanels.add((OracleOptionsPanel)object3);
                    this.mPnlTabs.addTab(((OracleOptionsPanel)object3).getLabel(), ((OracleOptionsPanel)object3).getPanel());
                }
            }
        }
    }

    @Override
    protected Properties getInput(Properties properties) {
        properties.setProperty("subtype", "oraJDBC");
        properties.setProperty("driver", DRIVER_CLASS_NAME);
        properties.setProperty("oraDriverType", "thin");
        properties.setProperty("RaptorConnectionType", "Oracle");
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.generateProperties(properties);
        this.optionPanels.stream().forEach(oracleOptionsPanel -> oracleOptionsPanel.generateProperties(properties));
        return properties;
    }

    private CDComponentView getPanel() {
        Object object = this.cbxAuthType.getSelectedItem();
        return this.mPanels.get(object);
    }

    @Override
    protected void testConnection(Properties properties) throws ConnectionException {
        String string = properties.getProperty("customUrl");
        super.testConnection(properties);
    }

    @Override
    public void clear() {
        for (OracleConnectionTypePanel oracleConnectionTypePanel : this.mPanels.values()) {
            oracleConnectionTypePanel.clear();
        }
        this.optionPanels.stream().forEach(oracleOptionsPanel -> oracleOptionsPanel.clear());
    }

    public static OracleConnectionType getOracleType(Properties properties) {
        String string = properties.getProperty(ORACLE_CONNECTION_PANEL_TYPE);
        if (string != null) {
            try {
                return OracleConnectionType.findType(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String string2 = properties.getProperty("hostname");
        String string3 = properties.getProperty("sid");
        String string4 = properties.getProperty("serviceName");
        if (ModelUtil.hasLength((String)string2) && (ModelUtil.hasLength((String)string3) || ModelUtil.hasLength((String)string4))) {
            return OracleConnectionType.BASIC;
        }
        String string5 = properties.getProperty("customUrl");
        if (string5 != null && !string5.startsWith("jdbc:")) {
            return OracleConnectionType.TNS;
        }
        return OracleConnectionType.ADVANCED;
    }

    @Override
    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        OracleConnectionType oracleConnectionType = OracleConnectionPanel.getOracleType(properties);
        if (oracleConnectionType == null) {
            oracleConnectionType = OracleConnectionType.ADVANCED;
        }
        this.cbxAuthType.setSelectedItem(oracleConnectionType);
        this.mPanels.get(oracleConnectionType).updatePrompts(properties);
        this.optionPanels.stream().forEach(oracleOptionsPanel -> oracleOptionsPanel.updatePrompts(properties));
        properties.put("ConnName", this.getConnectionName());
    }

    @Override
    public String getDriver() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public void setDefaultPrompts() {
        this.mPanels.values().stream().forEach(oracleConnectionTypePanel -> oracleConnectionTypePanel.setDefaultPrompts());
        this.optionPanels.stream().forEach(oracleOptionsPanel -> oracleOptionsPanel.setDefaultPrompts());
    }

    @Override
    public String getConnectionType() {
        return "Oracle";
    }

    @Override
    protected AuthenticationPanel createAuthenticationPanel() {
        return new OracleAuthenticationPanel();
    }
}

