/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import oracle.dbtools.raptor.connections.OracleOptionsPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.border.SmallSquareButtonBorder;

public class OracleAdvancedOptions
extends OracleOptionsPanel {
    public static final String CONN_USE_OCI_KEY = "useOCI";
    public static final String ADV_PROPERTIES_PREFIX = "sqldev.advanced.";
    private AdvancedOptionsModel mdl = new AdvancedOptionsModel();
    private JCheckBox chkOCI = new JCheckBox();
    private JButton btnAdd = new JButton();
    private JButton btnRemove = new JButton();

    OracleAdvancedOptions() {
    }

    @Override
    public void generateProperties(Properties properties) {
        if (this.chkOCI.isSelected()) {
            properties.setProperty(CONN_USE_OCI_KEY, Boolean.TRUE.toString());
        }
        for (int i = 0; i < this.mdl.getRowCount(); ++i) {
            String string = (String)this.mdl.getValueAt(i, 0);
            String string2 = (String)this.mdl.getValueAt(i, 1);
            properties.setProperty(ADV_PROPERTIES_PREFIX + string, string2);
        }
    }

    @Override
    public void updatePrompts(Properties properties) {
        boolean bl = Boolean.parseBoolean(properties.getProperty(CONN_USE_OCI_KEY));
        this.chkOCI.setSelected(bl);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (String string : properties.stringPropertyNames()) {
            if (!string.startsWith(ADV_PROPERTIES_PREFIX)) continue;
            String string2 = properties.getProperty(string);
            String string3 = string.substring(ADV_PROPERTIES_PREFIX.length());
            arrayList.add(new String[]{string3, string2});
        }
        this.mdl.setData(arrayList);
    }

    @Override
    public void clear() {
        this.mdl.clearRows();
        this.chkOCI.setSelected(false);
    }

    @Override
    public void setDefaultPrompts() {
        this.clear();
    }

    @Override
    protected Component createUI() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        final JTable jTable = new JTable(this.mdl);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(false);
        jTable.getSelectionModel().setSelectionMode(1);
        jTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                this.btnRemove.setEnabled(!listSelectionModel.isSelectionEmpty());
            }
        });
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TableCellEditor tableCellEditor = jTable.getCellEditor();
                if (tableCellEditor != null) {
                    if (tableCellEditor.getCellEditorValue() != null) {
                        tableCellEditor.stopCellEditing();
                    } else {
                        tableCellEditor.cancelCellEditing();
                    }
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        jTable.setDefaultEditor(String.class, new DefaultCellEditor(jTextField));
        jPanel.add((Component)jScrollPane, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        Box box = Box.createVerticalBox();
        this.btnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.btnAdd.addActionListener(actionEvent -> this.mdl.addRow("", ""));
        this.btnAdd.setBorder((Border)new SmallSquareButtonBorder());
        this.btnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.btnRemove.addActionListener(actionEvent -> {
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            if (!listSelectionModel.isSelectionEmpty()) {
                this.mdl.deleteRows(listSelectionModel.getMinSelectionIndex(), listSelectionModel.getMaxSelectionIndex());
            }
        });
        this.btnRemove.setBorder((Border)new SmallSquareButtonBorder());
        box.add(this.btnAdd);
        box.add(this.btnRemove);
        box.add(Box.createVerticalGlue());
        jPanel.add((Component)box, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.Y, LayoutControl.GBC.Spring.NONE));
        this.chkOCI.setText(ConnectionDialogArb.getString("ORACLE_ADVANCED_USE_OCI"));
        jPanel.add((Component)this.chkOCI, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        return jPanel;
    }

    @Override
    public String getLabel() {
        return ConnectionDialogArb.getString("ORACLE_ADVANCED_TAB");
    }

    private static class AdvancedOptionsModel
    extends AbstractTableModel {
        private static String[] COLUMN = new String[]{ConnectionDialogArb.getString("ORACLE_ADVANCED_PROPERTY_NAME"), ConnectionDialogArb.getString("ORACLE_ADVANCED_PROPERTY_VALUE")};
        private List<String[]> rows = new ArrayList<String[]>();

        private AdvancedOptionsModel() {
        }

        @Override
        public String getColumnName(int n) {
            return COLUMN[n];
        }

        @Override
        public int findColumn(String string) {
            return COLUMN[0].equals(string) ? 0 : (COLUMN[1].equals(string) ? 1 : -1);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String[] stringArray = this.rows.get(n);
            return stringArray[n2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String[] stringArray = this.rows.get(n);
            stringArray[n2] = object != null ? object.toString() : "";
            this.rows.set(n, stringArray);
            this.fireTableCellUpdated(n, n2);
        }

        void clearRows() {
            int n = this.rows.size();
            if (n > 0) {
                this.rows.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
        }

        void addRow(String string, String string2) {
            int n = this.rows.size();
            this.rows.add(new String[]{string, string2});
            this.fireTableRowsInserted(n, n);
        }

        void deleteRows(int n, int n2) {
            for (int i = n2; i >= n; --i) {
                this.rows.remove(i);
            }
            this.fireTableRowsDeleted(n, n2);
        }

        void setData(List<String[]> list) {
            this.rows.clear();
            this.rows.addAll(list);
            this.fireTableDataChanged();
        }
    }
}

