/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.AuthenticationPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.util.ResourceUtils;

public class DefaultAuthenticationPanel
extends AuthenticationPanel {
    protected JTextField tfdUser = new JTextField(15);
    protected JPasswordField tfdPassword = new JPasswordField(15);
    protected JCheckBox chkSavePassword = new JCheckBox();

    @Override
    public void clear() {
        this.tfdPassword.setText("");
        this.tfdUser.setText("");
    }

    @Override
    public void setConnectionDetails(Properties properties) {
        this.tfdUser.setText(properties.getProperty("user"));
        this.tfdPassword.setText(properties.getProperty("password"));
        this.chkSavePassword.setSelected(Boolean.parseBoolean(properties.getProperty("SavePassword")));
    }

    @Override
    public Properties getConnectionDetails() {
        Properties properties = new Properties();
        properties.setProperty("user", this.tfdUser.getText());
        properties.setProperty("password", new String(this.tfdPassword.getPassword()));
        properties.setProperty("SavePassword", Boolean.toString(this.chkSavePassword.isSelected()));
        return properties;
    }

    @Override
    public void initializeToDefaults() {
        this.tfdPassword.setText("");
        this.tfdUser.setText("");
    }

    @Override
    public String getUsername() {
        return this.tfdUser.getText();
    }

    @Override
    public String getPassword() {
        return new String(this.tfdPassword.getPassword());
    }

    @Override
    protected void updatePassword(String string) {
        this.tfdPassword.setText(string);
    }

    @Override
    protected JComponent createUI() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.tfdUser, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_USER"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.tfdUser, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.tfdPassword, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_PASSWORD"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.tfdPassword, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ResourceUtils.resButton((AbstractButton)this.chkSavePassword, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_SAVE_PASSWORD"));
        if (Boolean.parseBoolean(System.getProperty("sqldev.savepasswd", "true"))) {
            jPanel.add((Component)this.chkSavePassword, LayoutControl.GBC.gbc(2, 1, 2, 1, LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        }
        return jPanel;
    }
}

