/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.SQLPlusFileChooser;
import oracle.dbtools.raptor.controls.PositiveNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class WorkSheetInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 0L;
    private JCheckBox m_openWorkSheet = new JCheckBox();
    private JCheckBox m_openUnsharedWorkSheet = new JCheckBox();
    private JTextField m_maxScriptRows = new PositiveNumberField();
    private JTextField m_maxScriptLines = new PositiveNumberField();
    private JTextField m_sqlHistoryLimit = new PositiveNumberField();
    private SQLPlusFileChooser m_sqlPlusOptions = new SQLPlusFileChooser();
    private JCheckBox m_saveBinds = new JCheckBox();
    private JCheckBox m_closeWorksheet = new JCheckBox();
    private JCheckBox m_promptWhenClose = new JCheckBox();
    private JCheckBox m_zebraRows = new JCheckBox();
    private JCheckBox m_autoPinresults = new JCheckBox();
    private JCheckBox m_reInitOnExit = new JCheckBox();
    private JCheckBox m_skipMetadataDetail = new JCheckBox();

    public WorkSheetInfo() {
        this.setHelpID(Messages.getString("WorkSheetInfo.0"));
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.m_openWorkSheet.setSelected(dBConfig.getBoolean("WORKSHEETOPEN"));
        this.m_openUnsharedWorkSheet.setSelected(dBConfig.getBoolean("UNSHAREDWORKSHEETOPEN"));
        this.m_closeWorksheet.setSelected(dBConfig.getBoolean("WORKSHEETCLOSE"));
        this.m_promptWhenClose.setSelected(dBConfig.getBoolean("PROMPTWHENCLOSE"));
        this.m_zebraRows.setSelected(dBConfig.getBoolean("ZEBRA_ROWS"));
        String string = dBConfig.getString("MAXHISTORYROWS");
        if (string == null || string.trim().equals(Integer.valueOf(Integer.MAX_VALUE).toString())) {
            this.m_sqlHistoryLimit.setText("");
        } else {
            this.m_sqlHistoryLimit.setText(string);
        }
        String string2 = dBConfig.getString("MAXSCRIPTROWS");
        if (string2 == null || string2.trim().equals(Integer.valueOf(Integer.MAX_VALUE).toString())) {
            this.m_maxScriptRows.setText("");
        } else {
            this.m_maxScriptRows.setText(string2);
        }
        String string3 = dBConfig.getString("MAXSCRIPTLINES");
        this.m_maxScriptLines.setText(string3);
        this.m_saveBinds.setSelected(dBConfig.getBoolean("SAVEBINDS"));
        this.m_sqlPlusOptions.onEntry(traversableContext);
        this.m_autoPinresults.setSelected(dBConfig.getBoolean("AUTOPIN_RESULTS_TABS"));
        this.m_reInitOnExit.setSelected(dBConfig.getBoolean("REINIT_ON_EXIT"));
        this.m_skipMetadataDetail.setSelected(dBConfig.getBoolean("SKIP_METADATA_DETAIL"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string;
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("WORKSHEETOPEN", this.m_openWorkSheet.isSelected());
        dBConfig.putBoolean("UNSHAREDWORKSHEETOPEN", this.m_openUnsharedWorkSheet.isSelected());
        dBConfig.putBoolean("WORKSHEETCLOSE", this.m_closeWorksheet.isSelected());
        dBConfig.putBoolean("PROMPTWHENCLOSE", this.m_promptWhenClose.isSelected());
        dBConfig.putBoolean("ZEBRA_ROWS", this.m_zebraRows.isSelected());
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        try {
            string = this.m_maxScriptRows.getText();
            if (string != null && !string.trim().equals("")) {
                n = Integer.parseInt(string.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = Integer.MAX_VALUE;
        }
        try {
            string = this.m_maxScriptLines.getText();
            if (string != null && !string.trim().equals("")) {
                n2 = Integer.parseInt(string.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            n2 = Integer.MAX_VALUE;
        }
        try {
            string = this.m_sqlHistoryLimit.getText();
            if (string != null && !string.trim().equals("") && (n3 = Integer.parseInt(string.trim())) <= 0) {
                n3 = Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n3 = Integer.MAX_VALUE;
        }
        dBConfig.putString("MAXSCRIPTROWS", Integer.valueOf(n).toString());
        dBConfig.putString("MAXSCRIPTLINES", Integer.valueOf(n2).toString());
        dBConfig.putString("MAXHISTORYROWS", Integer.valueOf(n3).toString());
        dBConfig.putBoolean("SAVEBINDS", this.m_saveBinds.isSelected());
        dBConfig.putBoolean("AUTOPIN_RESULTS_TABS", this.m_autoPinresults.isSelected());
        dBConfig.putBoolean("REINIT_ON_EXIT", this.m_reInitOnExit.isSelected());
        dBConfig.putBoolean("SKIP_METADATA_DETAIL", this.m_skipMetadataDetail.isSelected());
        this.m_sqlPlusOptions.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_openWorkSheet, (String)PreferencesArb.getString("WORKSHEETOPEN"));
        ResourceUtils.resButton((AbstractButton)this.m_openUnsharedWorkSheet, (String)PreferencesArb.getString("UNSHAREDWORKSHEETOPEN"));
        ResourceUtils.resButton((AbstractButton)this.m_closeWorksheet, (String)PreferencesArb.getString("WORKSHEETCLOSE"));
        ResourceUtils.resButton((AbstractButton)this.m_promptWhenClose, (String)PreferencesArb.getString("PROMPTWHENCLOSE"));
        ResourceUtils.resButton((AbstractButton)this.m_zebraRows, (String)PreferencesArb.getString("ZEBRA_ROWS"));
        ResourceUtils.resButton((AbstractButton)this.m_saveBinds, (String)PreferencesArb.getString("SAVEBINDS"));
        ResourceUtils.resButton((AbstractButton)this.m_autoPinresults, (String)PreferencesArb.getString("AUTOPIN_RESULTS_TAB"));
        ResourceUtils.resButton((AbstractButton)this.m_reInitOnExit, (String)PreferencesArb.getString("REINIT_ON_EXIT"));
        ResourceUtils.resButton((AbstractButton)this.m_skipMetadataDetail, (String)PreferencesArb.getString("SKIP_METADATA_DETAIL"));
        int n = 0;
        this.add(this.m_openWorkSheet, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_openUnsharedWorkSheet, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_closeWorksheet, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_promptWhenClose, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_zebraRows, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        String string = StringUtils.stripMnemonic((String)PreferencesArb.getString("MAXSCRIPTROWS"));
        int n2 = StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("MAXSCRIPTROWS"));
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonic(n2);
        jLabel.setLabelFor(this.m_maxScriptRows);
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_maxScriptRows, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        String string2 = StringUtils.stripMnemonic((String)PreferencesArb.getString("MAXSCRIPTLINES"));
        int n3 = StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("MAXSCRIPTLINES"));
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setDisplayedMnemonic(n3);
        jLabel2.setLabelFor(this.m_maxScriptLines);
        this.add(jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_maxScriptLines, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        String string3 = StringUtils.stripMnemonic((String)PreferencesArb.getString("SQLHISTORY_LIMIT"));
        int n4 = StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("SQLHISTORY_LIMIT"));
        JLabel jLabel3 = new JLabel(string3);
        jLabel3.setDisplayedMnemonic(n4);
        jLabel3.setLabelFor(this.m_sqlHistoryLimit);
        this.add(jLabel3, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_sqlHistoryLimit, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_sqlPlusOptions), new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_saveBinds, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_autoPinresults, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_reInitOnExit, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_skipMetadataDetail, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, n++, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel4 = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridx = 2;
        this.add(jLabel4, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridy = 10;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 2;
    }
}

