/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.Document;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.format.SQLFormatterArb;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.language.CustomSyntaxStyle;
import oracle.dbtools.raptor.plsql.language.PLSQLLanguageSupport;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriTextPane;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Service;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.icons.OracleIcons;

public class SyntaxColorCustomOptions
extends DefaultTraversablePanel
implements ActionListener {
    final JButton importJB = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FormatSQLAdvancedOptions.import")));
    final JButton exportJB = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FormatSQLAdvancedOptions.export")));
    final JButton resetJB = new JButton(StringUtils.stripMnemonic((String)RunnerArb.getString("LABEL_RESET")));
    ArboriTextPane code = new ArboriTextPane();
    protected BasicEditorPane editor = null;
    private PLSQLLanguageSupport languageSupport;
    private static String sample = null;
    public static String arboriCode = null;

    public SyntaxColorCustomOptions() {
        this.setHelpID("f1_syntaxcolorcustomoptions_html");
        this.initEditor();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(OracleIcons.getIcon((String)"run.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxColorCustomOptions.this.run();
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(50));
        this.importJB.addActionListener(this);
        jPanel.add(this.importJB);
        this.exportJB.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(20));
        jPanel.add(this.exportJB);
        this.resetJB.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(20));
        jPanel.add(this.resetJB);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Last");
        jPanel2.add((Component)this.code, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JScrollPane((Component)this.editor), "Center");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(jPanel2);
        jSplitPane.setRightComponent(jPanel3);
        this.setLayout(new BorderLayout());
        this.add(jSplitPane, "Center");
        this.editor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '\u0016') {
                    SyntaxColorCustomOptions.this.updatePreview();
                }
                if (keyEvent.getKeyChar() == '\n') {
                    SyntaxColorCustomOptions.this.updatePreview();
                }
            }
        });
    }

    public void initEditor() {
        this.editor = EditorFactory.createIdeEditorPane();
        BasicDocument basicDocument = new BasicDocument("template.plsql");
        this.editor.setDocument((Document)basicDocument);
        this.editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.editor.installPlugin((EditorPlugin)lineGutterPlugin);
        LanguageSupport languageSupport = basicDocument.getLanguageSupport();
        if (languageSupport instanceof PLSQLLanguageSupport) {
            this.languageSupport = (PLSQLLanguageSupport)languageSupport;
            this.languageSupport.parser = new BackgroundParser();
            this.languageSupport.parser.install(this.editor);
        } else {
            Logger.severe(SyntaxColorCustomOptions.class, (String)"! expected PLSQLLanguageSupport");
        }
        this.editor.setText(SyntaxColorCustomOptions.getSample());
    }

    public static String getSample() {
        if (sample != null) {
            return sample;
        }
        try {
            sample = Service.readFile(CustomSyntaxStyle.class, (String)"log.pls");
        }
        catch (IOException iOException) {
            sample = "-- " + iOException.getMessage() + " ";
        }
        return sample;
    }

    private void run() {
        try {
            arboriCode = this.code.getText();
            this.saveCustomProgram();
            this.updatePreview();
        }
        catch (Exception exception) {
            MessageDialog.error(null, (Object)exception.getMessage(), (String)"", null);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void onEntry(TraversableContext traversableContext) {
        String string = null;
        try {
            arboriCode = string = CustomSyntaxStyle.getActiveCustomSyntaxStyleProgram();
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        this.code.selectAll();
        this.code.replaceSelection(string);
        this.code.setCaretPosition(0);
        this.updatePreview();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        try {
            this.saveCustomProgram();
            arboriCode = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void updatePreview() {
        if (this.languageSupport != null) {
            this.languageSupport.oldRoot = null;
        }
        this.editor.repaint();
    }

    private void saveCustomProgram() throws IOException, TraversalException {
        String string = CustomSyntaxStyle.getDefaultURL().getFile();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        String string2 = this.code.getText();
        Parsed parsed = new Parsed(string2, Program.getArboriParser(), "program");
        SyntaxError syntaxError = parsed.getSyntaxError();
        if (syntaxError != null) {
            throw new TraversalException(syntaxError.getDetailedMessage());
        }
        fileOutputStream.write(string2.getBytes());
        fileOutputStream.close();
        CustomSyntaxStyle.resetProgramInstances();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.importExportResetArboriCode(actionEvent.getSource());
    }

    private URL lastImportExportURL() {
        DBConfig dBConfig = DBConfig.getInstance();
        try {
            String string = dBConfig.getString("CUSTOM_SYNTAX_COLOR_URL");
            if (string != null && !"N/A".equals(string)) {
                return new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return null;
    }

    private void importExportResetArboriCode(Object object) {
        if (object == this.resetJB) {
            try {
                try {
                    this.code.selectAll();
                    this.code.replaceSelection(Service.readFile(CustomSyntaxStyle.class, (String)"custom_syntax.arbori"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.code.setCaretPosition(0);
                this.saveCustomProgram();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.editor.setText(SyntaxColorCustomOptions.getSample());
            this.updatePreview();
            return;
        }
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(SQLFormatterArb.getString("PROFILE_FILTER_NAME"), ".arbori");
        uRLFileChooser.addChooseableURLFilter((URLFilter)defaultURLFilter);
        uRLFileChooser.addChooseableURLFilter(URLFileChooser.ALL_FILES_FILTER);
        uRLFileChooser.setURLFilter((URLFilter)defaultURLFilter);
        if (this.lastImportExportURL() != null) {
            uRLFileChooser.setSelectedURL(this.lastImportExportURL());
        } else {
            URL uRL = this.getUserHomeDirectory();
            if (uRL != null) {
                uRLFileChooser.setSelectedURL(uRL);
            }
        }
        int n = -1;
        n = object == this.importJB ? uRLFileChooser.showOpenDialog((Component)((Object)this), SQLFormatterArb.getString("IMPORT_CUSTOM_PROGRAM")) : uRLFileChooser.showSaveDialog((Component)((Object)this), SQLFormatterArb.getString("EXPORT_CUSTOM_PROGRAM"));
        if (n == 0) {
            Object object2;
            URL uRL = uRLFileChooser.getSelectedURL();
            if (object == this.importJB) {
                try {
                    this.code.selectAll();
                    this.code.replaceSelection(Service.readFile((String)uRL.getFile()));
                    this.saveCustomProgram();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.updatePreview();
            } else if (this.checkExistingFile(uRL)) {
                try {
                    object2 = uRL.getFile();
                    FileOutputStream fileOutputStream = new FileOutputStream((String)object2);
                    fileOutputStream.write(this.code.getText().getBytes());
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            object2 = DBConfig.getInstance();
            object2.putString("CUSTOM_SYNTAX_COLOR_URL", uRL.toString());
        }
    }

    private URL getUserHomeDirectory() {
        URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)uRL) ? uRL : null;
    }

    private boolean checkExistingFile(URL uRL) {
        if (URLFileSystem.exists((URL)uRL)) {
            String string = SQLFormatterArb.format("EXPORT_OVERWRITE_WARNING_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL));
            String string2 = SQLFormatterArb.getString("EXPORT_OVERWRITE_WARNING_TITLE");
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string, string2, 2);
            return n == 0;
        }
        return true;
    }
}

