/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JPanel;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.export.wizard.DataOptionsPanel;
import oracle.dbtools.raptor.export.wizard.ExportDdlOptionsPanel;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ExportPreferences
extends DefaultTraversablePanel {
    private static ExportDdlOptionsPanel _ddlOptions;
    private DataOptionsPanel _dataOptions;
    private TargetOptionsPanel _targetOptions;
    private JPanel _ddlPanel;
    private JPanel _dataPanel;
    private JPanel _targetPanel;
    private int _row;
    private static final long serialVersionUID = -2739487292165944123L;

    public ExportPreferences() {
        this.setHelpID("f1_dbworksheetExportparam_html");
        try {
            DDLFormat dDLFormat = new DDLFormat();
            dDLFormat.setShowDDLOptionsEnabled(true);
            dDLFormat.setShowAlter(true);
            dDLFormat.setShowSegments(true);
            dDLFormat.setShowPartitioning(true);
            dDLFormat.setShowTablespace(true);
            dDLFormat.setShowDrop(true);
            dDLFormat.setShowCascade(true);
            dDLFormat.setShowGrant(true);
            dDLFormat.setShowDep(true);
            dDLFormat.setShowConstraint(false);
            dDLFormat.setShowRefConstraint(false);
            dDLFormat.setShowTrigger(false);
            _ddlOptions = new ExportDdlOptionsPanel(dDLFormat);
            _ddlOptions.setUsage(ExportDdlOptionsPanel.PREFERENCES);
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this._ddlPanel = _ddlOptions.getPanel();
        _ddlOptions.removeExportListener();
        this.add(this._ddlPanel, new GridBagConstraints(0, this._row, 3, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this._dataOptions = new DataOptionsPanel(BaseDataFormat.EXPORT_PREFERENCES);
        this._dataPanel = this._dataOptions.getPanel();
        this.add(this._dataPanel, new GridBagConstraints(0, ++this._row, 3, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this._targetOptions = new TargetOptionsPanel((Component)((Object)this), 0, 1);
        this._dataOptions.setTargetOptions(this._targetOptions);
        this._targetPanel = this._targetOptions.getPanel();
        this.add(this._targetPanel, new GridBagConstraints(0, ++this._row, 3, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        int n = this._targetOptions.getFormat().validateSaveAs((Component)((Object)this));
        if (n != 0) {
            throw new TraversalException(this._targetOptions.getFormat().getValidationMessage());
        }
        DDLFormat dDLFormat = _ddlOptions.getFormat();
        dDLFormat.saveFormat((IStorage)DBConfig.getInstance(traversableContext));
        DDLGenerator.getInstance().setFormating(dDLFormat);
        ExtractDataFormat extractDataFormat = this._dataOptions.getFormatForPrefs();
        extractDataFormat.saveBasicPreferences((IStorage)DBConfig.getInstance(traversableContext));
        this._targetOptions.getFormat().saveFormat((IStorage)DBConfig.getInstance(traversableContext));
    }
}

