/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.config.Messages;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;

public class ConfigChangeListener
extends StructureChangeListener {
    Collection<String> m_openConns = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(ConfigChangeListener.class.getName());

    public ConfigChangeListener() {
        Connections.getInstance().addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionAdded(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
                ConfigChangeListener.this.m_openConns.remove(connectionEvent.getConnectionName());
            }

            @Override
            public void connectionModified(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionOpened(ConnectionEvent connectionEvent) {
                ConfigChangeListener.this.m_openConns.add(connectionEvent.getConnectionName());
            }

            @Override
            public void connectionRemoved(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionRenamed(ConnectionEvent connectionEvent) {
            }
        });
    }

    public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
        HashMap<String, String> hashMap = null;
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        for (ChangeInfo object : structureChangeEvent.getChangeDetails()) {
            if (object.getChangeType() == 2) continue;
            string = object.getPropertyLocalName();
            if ("MAXSCRIPTROWS".equals(string)) {
                ResultSetFormatter.setMaxRows((int)object.getNewValueAsInt());
                continue;
            }
            if ("MAXSCRIPTLINES".equals(string)) {
                ResultSetFormatter.setMaxLines((int)object.getNewValueAsInt());
                continue;
            }
            if (string.startsWith("NLS_")) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                hashMap.put(string, object.getNewValueAsString());
                bl = true;
                continue;
            }
            if ("AUTOCOMMIT".equals(string) || "ARRAYFETCHSIZE".equals(string)) {
                RaptorDBAddin.setAutoCommit(object.getNewValueAsBoolean());
                continue;
            }
            if ("PLSQLSCOPE".equalsIgnoreCase(string)) {
                string2 = object.getNewValueAsString();
                bl = true;
                continue;
            }
            if ("PLSQLOPTIMLEVEL".equals(string)) {
                string3 = object.getNewValueAsString();
                bl = true;
                continue;
            }
            if (PlSqlCompilerOptions.WarningCategory.ALL.name().equals(string)) {
                string4 = object.getNewValueAsString();
                bl = true;
                continue;
            }
            if (PlSqlCompilerOptions.WarningCategory.INFORMATIONAL.name().equals(string)) {
                string5 = object.getNewValueAsString();
                bl = true;
                continue;
            }
            if (PlSqlCompilerOptions.WarningCategory.SEVERE.name().equals(string)) {
                string6 = object.getNewValueAsString();
                bl = true;
                continue;
            }
            if (PlSqlCompilerOptions.WarningCategory.PERFORMANCE.name().equals(string)) {
                string7 = object.getNewValueAsString();
                bl = true;
                continue;
            }
            if (!"TNS_NAMES_DIR".equals(string)) continue;
            TNSHelper.forceDirty();
        }
        if (bl) {
            Connections connections = Connections.getInstance();
            for (String string8 : this.m_openConns) {
                try {
                    Connection connection = connections.getConnection(string8);
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    int n = connection.getMetaData().getDatabaseMajorVersion();
                    if (hashMap != null) {
                        this.updateNLSValues(string8, hashMap);
                    }
                    if (string2 != null && n >= 11) {
                        dBUtil.execute("alter session set PLSCOPE_SETTINGS='identifiers:" + string2.toLowerCase() + "'", Collections.emptyList());
                    }
                    if (string3 != null) {
                        if (n >= 10) {
                            dBUtil.execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + string3, Collections.emptyList());
                        }
                        if (!connections.isTimesTen(connection) && n <= 11) {
                            int n2 = Integer.parseInt(string3);
                            dBUtil.execute("alter session set PLSQL_DEBUG=" + (n2 < 2), Collections.emptyList());
                        }
                    }
                    if (string4 != null) {
                        dBUtil.execute("ALTER SESSION SET PLSQL_WARNINGS = '" + string4.toLowerCase() + ":all'", Collections.emptyList());
                    }
                    if (string5 != null) {
                        dBUtil.execute("ALTER SESSION SET PLSQL_WARNINGS = '" + string5.toLowerCase() + ":informational'", Collections.emptyList());
                    }
                    if (string6 != null) {
                        dBUtil.execute("ALTER SESSION SET PLSQL_WARNINGS = '" + string6.toLowerCase() + ":severe'", Collections.emptyList());
                    }
                    if (string7 == null) continue;
                    dBUtil.execute("ALTER SESSION SET PLSQL_WARNINGS = '" + string7.toLowerCase() + ":performance'", Collections.emptyList());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
    }

    private void updateNLSValues(final String string, final Map<String, String> map) {
        final DefaultNLSProvider defaultNLSProvider = NLSProvider.getProvider((String)string);
        DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>(Messages.getString("ConfigChangeListener.2"), IRaptorTaskRunMode.IDE_STATUSBAR, false, false){

            public String getConnectionName() {
                return string;
            }

            public String getQuery() {
                return Messages.getString("ConfigChangeListener.3");
            }

            protected Void doWork() throws TaskException {
                if (defaultNLSProvider != null) {
                    defaultNLSProvider.updateDefaults(map);
                    defaultNLSProvider.initConnection();
                }
                return null;
            }
        };
        if (defaultNLSProvider != null) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        }
    }
}

