/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.ui;

import java.awt.Component;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextField;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.util.ModelUtil;

public abstract class BaseConnectionPanel
implements Traversable {
    protected static final String USERNAME_KEY = "Cloud.Username";
    protected static final String PASSWORD_KEY = "Cloud.Password";
    public static final String NAME_KEY = "Cloud.ConnectionName";
    public static final String ROOT_KEY = "Cloud.Root";
    public static final String SERVICE_KEY = "Cloud.ServiceURI";
    public static final String NAME_LIST_KEY = "Cloud.ExistingNames";
    public static final String HIDE_SERVICE_NAME_KEY = "Cloud.HideServiceName";
    private static final String BASE_DEFAULT_NAME = "CloudConnection";
    public static final String DEFAULT_HOSTNAME_KEY = "Cloud.DefaultHostname";
    protected JTextField m_name = new JTextField();
    private Component m_component;

    protected BaseConnectionPanel() {
    }

    public abstract String getCreateTitle();

    public abstract String getEditTitle();

    protected SessionInfo createConnectionInfo(Namespace namespace) {
        return new SessionInfo((String)namespace.get(NAME_KEY), (URI)namespace.get(ROOT_KEY), (URI)namespace.get(SERVICE_KEY), (String)namespace.get(USERNAME_KEY), (char[])namespace.get(PASSWORD_KEY));
    }

    protected Namespace createNamespace(SessionInfo sessionInfo, String[] stringArray) {
        Namespace namespace = new Namespace();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        if (sessionInfo != null) {
            namespace.put(NAME_KEY, (Object)sessionInfo.getName());
            namespace.put(USERNAME_KEY, (Object)sessionInfo.getUsername());
            namespace.put(PASSWORD_KEY, (Object)sessionInfo.getPassword());
            namespace.put(ROOT_KEY, (Object)sessionInfo.getServerRoot());
            namespace.put(SERVICE_KEY, (Object)sessionInfo.getServiceRoot());
            hashSet.remove(sessionInfo.getName());
        }
        namespace.put(NAME_LIST_KEY, hashSet);
        return namespace;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_name.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(CloudBrowserResources.getString("NEW_CONN_MISSING_NAME"));
        }
        Set set = (Set)traversableContext.get(NAME_LIST_KEY);
        if (set != null && set.contains(string)) {
            throw new TraversalException(CloudBrowserResources.format("NEW_CONN_DUPLICATE_NAME", string));
        }
        traversableContext.put(NAME_KEY, (Object)string);
    }

    public void onEntry(TraversableContext traversableContext) {
        String string = (String)traversableContext.get(NAME_KEY);
        if (string != null) {
            this.m_name.setText(string);
        } else {
            Set set = (Set)traversableContext.get(NAME_LIST_KEY);
            this.m_name.setText(this.generateDefaultName(set));
        }
    }

    public Component getInitialFocusComponent() {
        return this.m_name;
    }

    protected abstract Component createComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Component getComponent() {
        BaseConnectionPanel baseConnectionPanel = this;
        synchronized (baseConnectionPanel) {
            if (this.m_component == null) {
                this.m_component = this.createComponent();
            }
        }
        return this.m_component;
    }

    public Object getExitTransition() {
        return null;
    }

    protected String getBaseDefaultName() {
        return BASE_DEFAULT_NAME;
    }

    private String generateDefaultName(Set<String> set) {
        String string = this.getBaseDefaultName();
        Object object = string;
        int n = 1;
        while (set.contains(object)) {
            object = string + n++;
        }
        return object;
    }
}

