/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.auth.basic;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.DialogTraversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class AuthenticationPanel
extends DialogTraversable {
    public static final String CONN_KEY = "AuthenticationConnection";
    public static final String USERNAME_KEY = "AuthenticationUsername";
    public static final String PASSWORD_KEY = "AuthenticationPassword";
    private JLabel m_top = new JLabel(CloudBrowserResources.getString("AUTHENTICATION_PANEL_TOP"));
    private JTextField m_user = new JTextField();
    private JPasswordField m_pass = new JPasswordField();

    public String getHelpID() {
        return "f1_authcloudconnection_html";
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_top, LayoutControl.GBC.gbc(0, 0, 2, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_user, (String)CloudBrowserResources.getString("AUTHENTICATION_PANEL_USERNAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_user, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_pass, (String)CloudBrowserResources.getString("AUTHENTICATION_PANEL_PWD"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_pass, LayoutControl.GBC.gbc(1, 2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        return jPanel;
    }

    @Override
    public Component getInitialFocusComponent() {
        return this.m_pass;
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_user.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(CloudBrowserResources.getString("AUTHENTICATION_PANEL_USERNAME_ERROR"));
        }
        char[] cArray = this.m_pass.getPassword();
        if (cArray == null || cArray.length == 0) {
            throw new TraversalException(CloudBrowserResources.getString("AUTHENTICATION_PANEL_PWD_ERROR"));
        }
        traversableContext.put(USERNAME_KEY, (Object)string);
        traversableContext.put(PASSWORD_KEY, (Object)cArray);
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        SessionInfo sessionInfo = (SessionInfo)traversableContext.get(CONN_KEY);
        this.m_top.setText(CloudBrowserResources.format("AUTHENTICATION_PANEL_TOP", sessionInfo.getName()));
        this.m_user.setText(sessionInfo.getUsername());
        char[] cArray = (char[])traversableContext.get(PASSWORD_KEY);
        if (cArray != null) {
            this.m_pass.setText(new String(cArray));
        }
    }
}

